{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Buttons')

{{-- page content --}}
@section('content')
<div class="section">
  <div class="card">
    <div class="card-content">
      <p class="caption">The advanced buttons contain gradient color buttons with customization options.</p>
    </div>
  </div>
  <!--Gradient Button-->
  <div class="row">
    <div class="col s12 m12 l12">
      <div id="gradient-buttons" class="card card-default">
        <div class="card-content">
          <h4 class="card-title">Gradient Button</h4>
          <div class="row">
            <div class="col s12 mb-2">
              <p>Here are the examples of regular & fab style gradient button with medium & large size. You can apply
                any gradient color css class to material buttons i.e <code>.gradient-45deg-purple-deep-orange</code></p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-purple-deep-orange">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-light-blue-cyan">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-red-pink">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-amber-amber">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-green-teal">button</a></p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-purple-deep-orange">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-light-blue-cyan">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-red-pink">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-amber-amber">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-green-teal">
                  <i class="material-icons">clear</i>
                </a>
              </p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p><a class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-purple-deep-orange">button</a></p>
              <p><a class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-light-blue-cyan">button</a></p>
              <p><a class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-red-pink">button</a></p>
              <p><a class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-amber-amber">button</a></p>
              <p><a class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-green-teal">button</a></p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-purple-deep-orange">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-light-blue-cyan">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-red-pink">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-amber-amber">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-green-teal">
                  <i class="material-icons">clear</i>
                </a>
              </p>
            </div>
            <div class="col s12 mb-3 mt-2">
              <p>If you want to add shadow also use <code>.gradient-shadow</code> class. All othere materialize
                framwork button classes will support with gradient buttons.</p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p><a
                  class="mb-6 btn waves-effect waves-light gradient-45deg-purple-deep-orange gradient-shadow">button</a>
              </p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-light-blue-cyan gradient-shadow">button</a>
              </p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-red-pink gradient-shadow">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-amber-amber gradient-shadow">button</a></p>
              <p><a class="mb-6 btn waves-effect waves-light gradient-45deg-green-teal gradient-shadow">button</a></p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-purple-deep-orange gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-light-blue-cyan gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-red-pink gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-amber-amber gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating waves-effect waves-light gradient-45deg-green-teal gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p><a
                  class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-purple-deep-orange gradient-shadow">button</a>
              </p>
              <p><a
                  class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-light-blue-cyan gradient-shadow">button</a>
              </p>
              <p><a
                  class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-red-pink gradient-shadow">button</a>
              </p>
              <p><a
                  class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-amber-amber gradient-shadow">button</a>
              </p>
              <p><a
                  class="mb-6 btn btn-large waves-effect waves-light gradient-45deg-green-teal gradient-shadow">button</a>
              </p>
            </div>
            <div class="col s12 m3 l3 mb-3 center">
              <p>
                <a
                  class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-purple-deep-orange gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a
                  class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-light-blue-cyan gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-red-pink gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a
                  class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-amber-amber gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
              <p>
                <a
                  class="mb-6 btn-floating btn-large waves-effect waves-light gradient-45deg-green-teal gradient-shadow">
                  <i class="material-icons">clear</i>
                </a>
              </p>
            </div>
            <div class="col s12">
              <p>
                <span class="font-weight-600">Note:</span> Please refer <a href="{{asset('css-color')}}"
                  target="_blank">css-color.html</a>
                file for all colors classes & more details.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--Round Button-->
  <div class="row">
    <div class="col s12 m12 l12">
      <div id="round-button" class="card card-default">
        <div class="card-content">
          <h4 class="card-title">Round Button</h4>
          <div class="row">
            <div class="col s12 mb-2">
              <p>For round button you need to use class <code>.border-round</code></p>
            </div>
            <div class="col s12">
              <a
                class="waves-effect waves-light  btn gradient-45deg-light-blue-cyan box-shadow-none border-round mr-1 mb-1">copy</a>
              <a
                class="waves-effect waves-light  btn gradient-45deg-red-pink box-shadow-none border-round mr-1 mb-1">upload</a>
              <a
                class="waves-effect waves-light  btn gradient-45deg-amber-amber box-shadow-none border-round mr-1 mb-1">backup</a>
              <a
                class="waves-effect waves-light  btn gradient-45deg-green-teal box-shadow-none border-round mr-1 mb-1">download</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--Border Button-->
  <div class="row">
    <div class="col s12 m12 l12">
      <div id="gradient-button-with-shadow" class="card card-default">
        <div class="card-content">
          <h4 class="card-title">Gradient button with shadow</h4>
          <div class="row">
            <div class="col s12 mb-2">
              <p>For shadow button you ave to use class
                <code>z-depth-1, z-depth-2, z-depth-3, z-depth-4, z-depth-5</code></p>
            </div>
            <div class="col s12">
              <a class="waves-effect waves-light btn gradient-45deg-light-blue-cyan z-depth-4 mr-1 mb-2">copy</a>
              <a class="waves-effect waves-light btn gradient-45deg-red-pink z-depth-4 mr-1 mb-2">upload</a>
              <a class="waves-effect waves-light btn gradient-45deg-amber-amber z-depth-4 mr-1 mb-2">backup</a>
              <a class="waves-effect waves-light btn gradient-45deg-green-teal z-depth-4 mr-1 mb-2">download</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection