/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.fineract.client.models.BodyPartHeaders;
import org.apache.fineract.client.models.BodyPartParameterizedHeaders;
import org.apache.fineract.client.models.ContentDisposition;
import org.apache.fineract.client.models.MediaType;
import org.apache.fineract.client.models.MultiPart;

/**
 * BodyPart
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class BodyPart {
  public static final String SERIALIZED_NAME_CONTENT_DISPOSITION = "contentDisposition";
  @SerializedName(SERIALIZED_NAME_CONTENT_DISPOSITION)
  private ContentDisposition contentDisposition;

  public static final String SERIALIZED_NAME_ENTITY = "entity";
  @SerializedName(SERIALIZED_NAME_ENTITY)
  private Object entity;

  public static final String SERIALIZED_NAME_HEADERS = "headers";
  @SerializedName(SERIALIZED_NAME_HEADERS)
  private BodyPartHeaders headers;

  public static final String SERIALIZED_NAME_MEDIA_TYPE = "mediaType";
  @SerializedName(SERIALIZED_NAME_MEDIA_TYPE)
  private MediaType mediaType;

  public static final String SERIALIZED_NAME_MESSAGE_BODY_WORKERS = "messageBodyWorkers";
  @SerializedName(SERIALIZED_NAME_MESSAGE_BODY_WORKERS)
  private Object messageBodyWorkers;

  public static final String SERIALIZED_NAME_PARAMETERIZED_HEADERS = "parameterizedHeaders";
  @SerializedName(SERIALIZED_NAME_PARAMETERIZED_HEADERS)
  private BodyPartParameterizedHeaders parameterizedHeaders;

  public static final String SERIALIZED_NAME_PARENT = "parent";
  @SerializedName(SERIALIZED_NAME_PARENT)
  private MultiPart parent;

  public static final String SERIALIZED_NAME_PROVIDERS = "providers";
  @SerializedName(SERIALIZED_NAME_PROVIDERS)
  private Object providers;

  public BodyPart() {
  }

  public BodyPart contentDisposition(ContentDisposition contentDisposition) {
    
    this.contentDisposition = contentDisposition;
    return this;
  }

  /**
   * Get contentDisposition
   * @return contentDisposition
   */
  @javax.annotation.Nullable

  public ContentDisposition getContentDisposition() {
    return contentDisposition;
  }


  public void setContentDisposition(ContentDisposition contentDisposition) {
    this.contentDisposition = contentDisposition;
  }

  public BodyPart entity(Object entity) {
    
    this.entity = entity;
    return this;
  }

  /**
   * Get entity
   * @return entity
   */
  @javax.annotation.Nullable

  public Object getEntity() {
    return entity;
  }


  public void setEntity(Object entity) {
    this.entity = entity;
  }

  public BodyPart headers(BodyPartHeaders headers) {
    
    this.headers = headers;
    return this;
  }

  /**
   * Get headers
   * @return headers
   */
  @javax.annotation.Nullable

  public BodyPartHeaders getHeaders() {
    return headers;
  }


  public void setHeaders(BodyPartHeaders headers) {
    this.headers = headers;
  }

  public BodyPart mediaType(MediaType mediaType) {
    
    this.mediaType = mediaType;
    return this;
  }

  /**
   * Get mediaType
   * @return mediaType
   */
  @javax.annotation.Nullable

  public MediaType getMediaType() {
    return mediaType;
  }


  public void setMediaType(MediaType mediaType) {
    this.mediaType = mediaType;
  }

  public BodyPart messageBodyWorkers(Object messageBodyWorkers) {
    
    this.messageBodyWorkers = messageBodyWorkers;
    return this;
  }

  /**
   * Get messageBodyWorkers
   * @return messageBodyWorkers
   */
  @javax.annotation.Nullable

  public Object getMessageBodyWorkers() {
    return messageBodyWorkers;
  }


  public void setMessageBodyWorkers(Object messageBodyWorkers) {
    this.messageBodyWorkers = messageBodyWorkers;
  }

  public BodyPart parameterizedHeaders(BodyPartParameterizedHeaders parameterizedHeaders) {
    
    this.parameterizedHeaders = parameterizedHeaders;
    return this;
  }

  /**
   * Get parameterizedHeaders
   * @return parameterizedHeaders
   */
  @javax.annotation.Nullable

  public BodyPartParameterizedHeaders getParameterizedHeaders() {
    return parameterizedHeaders;
  }


  public void setParameterizedHeaders(BodyPartParameterizedHeaders parameterizedHeaders) {
    this.parameterizedHeaders = parameterizedHeaders;
  }

  public BodyPart parent(MultiPart parent) {
    
    this.parent = parent;
    return this;
  }

  /**
   * Get parent
   * @return parent
   */
  @javax.annotation.Nullable

  public MultiPart getParent() {
    return parent;
  }


  public void setParent(MultiPart parent) {
    this.parent = parent;
  }

  public BodyPart providers(Object providers) {
    
    this.providers = providers;
    return this;
  }

  /**
   * Get providers
   * @return providers
   */
  @javax.annotation.Nullable

  public Object getProviders() {
    return providers;
  }


  public void setProviders(Object providers) {
    this.providers = providers;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BodyPart bodyPart = (BodyPart) o;
    return Objects.equals(this.contentDisposition, bodyPart.contentDisposition) &&
        Objects.equals(this.entity, bodyPart.entity) &&
        Objects.equals(this.headers, bodyPart.headers) &&
        Objects.equals(this.mediaType, bodyPart.mediaType) &&
        Objects.equals(this.messageBodyWorkers, bodyPart.messageBodyWorkers) &&
        Objects.equals(this.parameterizedHeaders, bodyPart.parameterizedHeaders) &&
        Objects.equals(this.parent, bodyPart.parent) &&
        Objects.equals(this.providers, bodyPart.providers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contentDisposition, entity, headers, mediaType, messageBodyWorkers, parameterizedHeaders, parent, providers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BodyPart {\n");
    sb.append("    contentDisposition: ").append(toIndentedString(contentDisposition)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    mediaType: ").append(toIndentedString(mediaType)).append("\n");
    sb.append("    messageBodyWorkers: ").append(toIndentedString(messageBodyWorkers)).append("\n");
    sb.append("    parameterizedHeaders: ").append(toIndentedString(parameterizedHeaders)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    providers: ").append(toIndentedString(providers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

