/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.ClientCollateralManagementData;
import org.apache.fineract.client.models.ClientFamilyMembersData;
import org.apache.fineract.client.models.ClientTimelineData;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.DatatableData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.ExternalId;
import org.apache.fineract.client.models.GroupGeneralData;
import org.apache.fineract.client.models.OfficeData;
import org.apache.fineract.client.models.SavingsAccountData;
import org.apache.fineract.client.models.SavingsProductData;
import org.apache.fineract.client.models.StaffData;

/**
 * ClientData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ClientData {
  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ACTIVATION_DATE = "activationDate";
  @SerializedName(SERIALIZED_NAME_ACTIVATION_DATE)
  private LocalDate activationDate;

  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_ADDRESS = "address";
  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private List<Object> address;

  public static final String SERIALIZED_NAME_CLIENT_CLASSIFICATION = "clientClassification";
  @SerializedName(SERIALIZED_NAME_CLIENT_CLASSIFICATION)
  private CodeValueData clientClassification;

  public static final String SERIALIZED_NAME_CLIENT_CLASSIFICATION_ID = "clientClassificationId";
  @SerializedName(SERIALIZED_NAME_CLIENT_CLASSIFICATION_ID)
  private Long clientClassificationId;

  public static final String SERIALIZED_NAME_CLIENT_CLASSIFICATION_OPTIONS = "clientClassificationOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_CLASSIFICATION_OPTIONS)
  private List<CodeValueData> clientClassificationOptions;

  public static final String SERIALIZED_NAME_CLIENT_COLLATERAL_MANAGEMENTS = "clientCollateralManagements";
  @SerializedName(SERIALIZED_NAME_CLIENT_COLLATERAL_MANAGEMENTS)
  private Set<ClientCollateralManagementData> clientCollateralManagements;

  public static final String SERIALIZED_NAME_CLIENT_LEGAL_FORM_OPTIONS = "clientLegalFormOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_LEGAL_FORM_OPTIONS)
  private List<EnumOptionData> clientLegalFormOptions;

  public static final String SERIALIZED_NAME_CLIENT_NON_PERSON_CONSTITUTION_OPTIONS = "clientNonPersonConstitutionOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_NON_PERSON_CONSTITUTION_OPTIONS)
  private List<CodeValueData> clientNonPersonConstitutionOptions;

  public static final String SERIALIZED_NAME_CLIENT_NON_PERSON_DETAILS = "clientNonPersonDetails";
  @SerializedName(SERIALIZED_NAME_CLIENT_NON_PERSON_DETAILS)
  private Object clientNonPersonDetails;

  public static final String SERIALIZED_NAME_CLIENT_NON_PERSON_MAIN_BUSINESS_LINE_OPTIONS = "clientNonPersonMainBusinessLineOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_NON_PERSON_MAIN_BUSINESS_LINE_OPTIONS)
  private List<CodeValueData> clientNonPersonMainBusinessLineOptions;

  public static final String SERIALIZED_NAME_CLIENT_TYPE = "clientType";
  @SerializedName(SERIALIZED_NAME_CLIENT_TYPE)
  private CodeValueData clientType;

  public static final String SERIALIZED_NAME_CLIENT_TYPE_ID = "clientTypeId";
  @SerializedName(SERIALIZED_NAME_CLIENT_TYPE_ID)
  private Long clientTypeId;

  public static final String SERIALIZED_NAME_CLIENT_TYPE_OPTIONS = "clientTypeOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_TYPE_OPTIONS)
  private List<CodeValueData> clientTypeOptions;

  public static final String SERIALIZED_NAME_DATATABLES = "datatables";
  @SerializedName(SERIALIZED_NAME_DATATABLES)
  private List<DatatableData> datatables;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_DISPLAY_NAME = "displayName";
  @SerializedName(SERIALIZED_NAME_DISPLAY_NAME)
  private String displayName;

  public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "emailAddress";
  @SerializedName(SERIALIZED_NAME_EMAIL_ADDRESS)
  private String emailAddress;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private ExternalId externalId;

  public static final String SERIALIZED_NAME_FAMILY_MEMBER_OPTIONS = "familyMemberOptions";
  @SerializedName(SERIALIZED_NAME_FAMILY_MEMBER_OPTIONS)
  private ClientFamilyMembersData familyMemberOptions;

  public static final String SERIALIZED_NAME_FIRSTNAME = "firstname";
  @SerializedName(SERIALIZED_NAME_FIRSTNAME)
  private String firstname;

  public static final String SERIALIZED_NAME_FULLNAME = "fullname";
  @SerializedName(SERIALIZED_NAME_FULLNAME)
  private String fullname;

  public static final String SERIALIZED_NAME_GENDER = "gender";
  @SerializedName(SERIALIZED_NAME_GENDER)
  private CodeValueData gender;

  public static final String SERIALIZED_NAME_GENDER_ID = "genderId";
  @SerializedName(SERIALIZED_NAME_GENDER_ID)
  private Long genderId;

  public static final String SERIALIZED_NAME_GENDER_OPTIONS = "genderOptions";
  @SerializedName(SERIALIZED_NAME_GENDER_OPTIONS)
  private List<CodeValueData> genderOptions;

  public static final String SERIALIZED_NAME_GROUPS = "groups";
  @SerializedName(SERIALIZED_NAME_GROUPS)
  private List<GroupGeneralData> groups;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IMAGE_ID = "imageId";
  @SerializedName(SERIALIZED_NAME_IMAGE_ID)
  private Long imageId;

  public static final String SERIALIZED_NAME_IMAGE_PRESENT = "imagePresent";
  @SerializedName(SERIALIZED_NAME_IMAGE_PRESENT)
  private Boolean imagePresent;

  public static final String SERIALIZED_NAME_IS_ADDRESS_ENABLED = "isAddressEnabled";
  @SerializedName(SERIALIZED_NAME_IS_ADDRESS_ENABLED)
  private Boolean isAddressEnabled;

  public static final String SERIALIZED_NAME_IS_STAFF = "isStaff";
  @SerializedName(SERIALIZED_NAME_IS_STAFF)
  private Boolean isStaff;

  public static final String SERIALIZED_NAME_LASTNAME = "lastname";
  @SerializedName(SERIALIZED_NAME_LASTNAME)
  private String lastname;

  public static final String SERIALIZED_NAME_LEGAL_FORM = "legalForm";
  @SerializedName(SERIALIZED_NAME_LEGAL_FORM)
  private EnumOptionData legalForm;

  public static final String SERIALIZED_NAME_LEGAL_FORM_ID = "legalFormId";
  @SerializedName(SERIALIZED_NAME_LEGAL_FORM_ID)
  private Long legalFormId;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MIDDLENAME = "middlename";
  @SerializedName(SERIALIZED_NAME_MIDDLENAME)
  private String middlename;

  public static final String SERIALIZED_NAME_MOBILE_NO = "mobileNo";
  @SerializedName(SERIALIZED_NAME_MOBILE_NO)
  private String mobileNo;

  public static final String SERIALIZED_NAME_NARRATIONS = "narrations";
  @SerializedName(SERIALIZED_NAME_NARRATIONS)
  private List<CodeValueData> narrations;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_OFFICE_OPTIONS = "officeOptions";
  @SerializedName(SERIALIZED_NAME_OFFICE_OPTIONS)
  private List<OfficeData> officeOptions;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SAVING_ACCOUNT_OPTIONS = "savingAccountOptions";
  @SerializedName(SERIALIZED_NAME_SAVING_ACCOUNT_OPTIONS)
  private List<SavingsAccountData> savingAccountOptions;

  public static final String SERIALIZED_NAME_SAVING_PRODUCT_OPTIONS = "savingProductOptions";
  @SerializedName(SERIALIZED_NAME_SAVING_PRODUCT_OPTIONS)
  private List<SavingsProductData> savingProductOptions;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_ID = "savingsAccountId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_ID)
  private Long savingsAccountId;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT_ID = "savingsProductId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT_ID)
  private Long savingsProductId;

  public static final String SERIALIZED_NAME_SAVINGS_PRODUCT_NAME = "savingsProductName";
  @SerializedName(SERIALIZED_NAME_SAVINGS_PRODUCT_NAME)
  private String savingsProductName;

  public static final String SERIALIZED_NAME_STAFF_ID = "staffId";
  @SerializedName(SERIALIZED_NAME_STAFF_ID)
  private Long staffId;

  public static final String SERIALIZED_NAME_STAFF_NAME = "staffName";
  @SerializedName(SERIALIZED_NAME_STAFF_NAME)
  private String staffName;

  public static final String SERIALIZED_NAME_STAFF_OPTIONS = "staffOptions";
  @SerializedName(SERIALIZED_NAME_STAFF_OPTIONS)
  private List<StaffData> staffOptions;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private EnumOptionData status;

  public static final String SERIALIZED_NAME_SUB_STATUS = "subStatus";
  @SerializedName(SERIALIZED_NAME_SUB_STATUS)
  private CodeValueData subStatus;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private ClientTimelineData timeline;

  public static final String SERIALIZED_NAME_TRANSFER_TO_OFFICE_ID = "transferToOfficeId";
  @SerializedName(SERIALIZED_NAME_TRANSFER_TO_OFFICE_ID)
  private Long transferToOfficeId;

  public static final String SERIALIZED_NAME_TRANSFER_TO_OFFICE_NAME = "transferToOfficeName";
  @SerializedName(SERIALIZED_NAME_TRANSFER_TO_OFFICE_NAME)
  private String transferToOfficeName;

  public ClientData() {
  }

  public ClientData accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public ClientData activationDate(LocalDate activationDate) {
    
    this.activationDate = activationDate;
    return this;
  }

  /**
   * Get activationDate
   * @return activationDate
   */
  @javax.annotation.Nullable

  public LocalDate getActivationDate() {
    return activationDate;
  }


  public void setActivationDate(LocalDate activationDate) {
    this.activationDate = activationDate;
  }

  public ClientData active(Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  @javax.annotation.Nullable

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }

  public ClientData address(List<Object> address) {
    
    this.address = address;
    return this;
  }

  public ClientData addAddressItem(Object addressItem) {
    if (this.address == null) {
      this.address = new ArrayList<>();
    }
    this.address.add(addressItem);
    return this;
  }

  /**
   * Get address
   * @return address
   */
  @javax.annotation.Nullable

  public List<Object> getAddress() {
    return address;
  }


  public void setAddress(List<Object> address) {
    this.address = address;
  }

  public ClientData clientClassification(CodeValueData clientClassification) {
    
    this.clientClassification = clientClassification;
    return this;
  }

  /**
   * Get clientClassification
   * @return clientClassification
   */
  @javax.annotation.Nullable

  public CodeValueData getClientClassification() {
    return clientClassification;
  }


  public void setClientClassification(CodeValueData clientClassification) {
    this.clientClassification = clientClassification;
  }

  public ClientData clientClassificationId(Long clientClassificationId) {
    
    this.clientClassificationId = clientClassificationId;
    return this;
  }

  /**
   * Get clientClassificationId
   * @return clientClassificationId
   */
  @javax.annotation.Nullable

  public Long getClientClassificationId() {
    return clientClassificationId;
  }


  public void setClientClassificationId(Long clientClassificationId) {
    this.clientClassificationId = clientClassificationId;
  }

  public ClientData clientClassificationOptions(List<CodeValueData> clientClassificationOptions) {
    
    this.clientClassificationOptions = clientClassificationOptions;
    return this;
  }

  public ClientData addClientClassificationOptionsItem(CodeValueData clientClassificationOptionsItem) {
    if (this.clientClassificationOptions == null) {
      this.clientClassificationOptions = new ArrayList<>();
    }
    this.clientClassificationOptions.add(clientClassificationOptionsItem);
    return this;
  }

  /**
   * Get clientClassificationOptions
   * @return clientClassificationOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClientClassificationOptions() {
    return clientClassificationOptions;
  }


  public void setClientClassificationOptions(List<CodeValueData> clientClassificationOptions) {
    this.clientClassificationOptions = clientClassificationOptions;
  }

  public ClientData clientCollateralManagements(Set<ClientCollateralManagementData> clientCollateralManagements) {
    
    this.clientCollateralManagements = clientCollateralManagements;
    return this;
  }

  public ClientData addClientCollateralManagementsItem(ClientCollateralManagementData clientCollateralManagementsItem) {
    if (this.clientCollateralManagements == null) {
      this.clientCollateralManagements = new LinkedHashSet<>();
    }
    this.clientCollateralManagements.add(clientCollateralManagementsItem);
    return this;
  }

  /**
   * Get clientCollateralManagements
   * @return clientCollateralManagements
   */
  @javax.annotation.Nullable

  public Set<ClientCollateralManagementData> getClientCollateralManagements() {
    return clientCollateralManagements;
  }


  public void setClientCollateralManagements(Set<ClientCollateralManagementData> clientCollateralManagements) {
    this.clientCollateralManagements = clientCollateralManagements;
  }

  public ClientData clientLegalFormOptions(List<EnumOptionData> clientLegalFormOptions) {
    
    this.clientLegalFormOptions = clientLegalFormOptions;
    return this;
  }

  public ClientData addClientLegalFormOptionsItem(EnumOptionData clientLegalFormOptionsItem) {
    if (this.clientLegalFormOptions == null) {
      this.clientLegalFormOptions = new ArrayList<>();
    }
    this.clientLegalFormOptions.add(clientLegalFormOptionsItem);
    return this;
  }

  /**
   * Get clientLegalFormOptions
   * @return clientLegalFormOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getClientLegalFormOptions() {
    return clientLegalFormOptions;
  }


  public void setClientLegalFormOptions(List<EnumOptionData> clientLegalFormOptions) {
    this.clientLegalFormOptions = clientLegalFormOptions;
  }

  public ClientData clientNonPersonConstitutionOptions(List<CodeValueData> clientNonPersonConstitutionOptions) {
    
    this.clientNonPersonConstitutionOptions = clientNonPersonConstitutionOptions;
    return this;
  }

  public ClientData addClientNonPersonConstitutionOptionsItem(CodeValueData clientNonPersonConstitutionOptionsItem) {
    if (this.clientNonPersonConstitutionOptions == null) {
      this.clientNonPersonConstitutionOptions = new ArrayList<>();
    }
    this.clientNonPersonConstitutionOptions.add(clientNonPersonConstitutionOptionsItem);
    return this;
  }

  /**
   * Get clientNonPersonConstitutionOptions
   * @return clientNonPersonConstitutionOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClientNonPersonConstitutionOptions() {
    return clientNonPersonConstitutionOptions;
  }


  public void setClientNonPersonConstitutionOptions(List<CodeValueData> clientNonPersonConstitutionOptions) {
    this.clientNonPersonConstitutionOptions = clientNonPersonConstitutionOptions;
  }

  public ClientData clientNonPersonDetails(Object clientNonPersonDetails) {
    
    this.clientNonPersonDetails = clientNonPersonDetails;
    return this;
  }

  /**
   * Get clientNonPersonDetails
   * @return clientNonPersonDetails
   */
  @javax.annotation.Nullable

  public Object getClientNonPersonDetails() {
    return clientNonPersonDetails;
  }


  public void setClientNonPersonDetails(Object clientNonPersonDetails) {
    this.clientNonPersonDetails = clientNonPersonDetails;
  }

  public ClientData clientNonPersonMainBusinessLineOptions(List<CodeValueData> clientNonPersonMainBusinessLineOptions) {
    
    this.clientNonPersonMainBusinessLineOptions = clientNonPersonMainBusinessLineOptions;
    return this;
  }

  public ClientData addClientNonPersonMainBusinessLineOptionsItem(CodeValueData clientNonPersonMainBusinessLineOptionsItem) {
    if (this.clientNonPersonMainBusinessLineOptions == null) {
      this.clientNonPersonMainBusinessLineOptions = new ArrayList<>();
    }
    this.clientNonPersonMainBusinessLineOptions.add(clientNonPersonMainBusinessLineOptionsItem);
    return this;
  }

  /**
   * Get clientNonPersonMainBusinessLineOptions
   * @return clientNonPersonMainBusinessLineOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClientNonPersonMainBusinessLineOptions() {
    return clientNonPersonMainBusinessLineOptions;
  }


  public void setClientNonPersonMainBusinessLineOptions(List<CodeValueData> clientNonPersonMainBusinessLineOptions) {
    this.clientNonPersonMainBusinessLineOptions = clientNonPersonMainBusinessLineOptions;
  }

  public ClientData clientType(CodeValueData clientType) {
    
    this.clientType = clientType;
    return this;
  }

  /**
   * Get clientType
   * @return clientType
   */
  @javax.annotation.Nullable

  public CodeValueData getClientType() {
    return clientType;
  }


  public void setClientType(CodeValueData clientType) {
    this.clientType = clientType;
  }

  public ClientData clientTypeId(Long clientTypeId) {
    
    this.clientTypeId = clientTypeId;
    return this;
  }

  /**
   * Get clientTypeId
   * @return clientTypeId
   */
  @javax.annotation.Nullable

  public Long getClientTypeId() {
    return clientTypeId;
  }


  public void setClientTypeId(Long clientTypeId) {
    this.clientTypeId = clientTypeId;
  }

  public ClientData clientTypeOptions(List<CodeValueData> clientTypeOptions) {
    
    this.clientTypeOptions = clientTypeOptions;
    return this;
  }

  public ClientData addClientTypeOptionsItem(CodeValueData clientTypeOptionsItem) {
    if (this.clientTypeOptions == null) {
      this.clientTypeOptions = new ArrayList<>();
    }
    this.clientTypeOptions.add(clientTypeOptionsItem);
    return this;
  }

  /**
   * Get clientTypeOptions
   * @return clientTypeOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClientTypeOptions() {
    return clientTypeOptions;
  }


  public void setClientTypeOptions(List<CodeValueData> clientTypeOptions) {
    this.clientTypeOptions = clientTypeOptions;
  }

  public ClientData datatables(List<DatatableData> datatables) {
    
    this.datatables = datatables;
    return this;
  }

  public ClientData addDatatablesItem(DatatableData datatablesItem) {
    if (this.datatables == null) {
      this.datatables = new ArrayList<>();
    }
    this.datatables.add(datatablesItem);
    return this;
  }

  /**
   * Get datatables
   * @return datatables
   */
  @javax.annotation.Nullable

  public List<DatatableData> getDatatables() {
    return datatables;
  }


  public void setDatatables(List<DatatableData> datatables) {
    this.datatables = datatables;
  }

  public ClientData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public ClientData dateOfBirth(LocalDate dateOfBirth) {
    
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * Get dateOfBirth
   * @return dateOfBirth
   */
  @javax.annotation.Nullable

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }


  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public ClientData displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

  /**
   * Get displayName
   * @return displayName
   */
  @javax.annotation.Nullable

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public ClientData emailAddress(String emailAddress) {
    
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * Get emailAddress
   * @return emailAddress
   */
  @javax.annotation.Nullable

  public String getEmailAddress() {
    return emailAddress;
  }


  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  public ClientData externalId(ExternalId externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public ExternalId getExternalId() {
    return externalId;
  }


  public void setExternalId(ExternalId externalId) {
    this.externalId = externalId;
  }

  public ClientData familyMemberOptions(ClientFamilyMembersData familyMemberOptions) {
    
    this.familyMemberOptions = familyMemberOptions;
    return this;
  }

  /**
   * Get familyMemberOptions
   * @return familyMemberOptions
   */
  @javax.annotation.Nullable

  public ClientFamilyMembersData getFamilyMemberOptions() {
    return familyMemberOptions;
  }


  public void setFamilyMemberOptions(ClientFamilyMembersData familyMemberOptions) {
    this.familyMemberOptions = familyMemberOptions;
  }

  public ClientData firstname(String firstname) {
    
    this.firstname = firstname;
    return this;
  }

  /**
   * Get firstname
   * @return firstname
   */
  @javax.annotation.Nullable

  public String getFirstname() {
    return firstname;
  }


  public void setFirstname(String firstname) {
    this.firstname = firstname;
  }

  public ClientData fullname(String fullname) {
    
    this.fullname = fullname;
    return this;
  }

  /**
   * Get fullname
   * @return fullname
   */
  @javax.annotation.Nullable

  public String getFullname() {
    return fullname;
  }


  public void setFullname(String fullname) {
    this.fullname = fullname;
  }

  public ClientData gender(CodeValueData gender) {
    
    this.gender = gender;
    return this;
  }

  /**
   * Get gender
   * @return gender
   */
  @javax.annotation.Nullable

  public CodeValueData getGender() {
    return gender;
  }


  public void setGender(CodeValueData gender) {
    this.gender = gender;
  }

  public ClientData genderId(Long genderId) {
    
    this.genderId = genderId;
    return this;
  }

  /**
   * Get genderId
   * @return genderId
   */
  @javax.annotation.Nullable

  public Long getGenderId() {
    return genderId;
  }


  public void setGenderId(Long genderId) {
    this.genderId = genderId;
  }

  public ClientData genderOptions(List<CodeValueData> genderOptions) {
    
    this.genderOptions = genderOptions;
    return this;
  }

  public ClientData addGenderOptionsItem(CodeValueData genderOptionsItem) {
    if (this.genderOptions == null) {
      this.genderOptions = new ArrayList<>();
    }
    this.genderOptions.add(genderOptionsItem);
    return this;
  }

  /**
   * Get genderOptions
   * @return genderOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getGenderOptions() {
    return genderOptions;
  }


  public void setGenderOptions(List<CodeValueData> genderOptions) {
    this.genderOptions = genderOptions;
  }

  public ClientData groups(List<GroupGeneralData> groups) {
    
    this.groups = groups;
    return this;
  }

  public ClientData addGroupsItem(GroupGeneralData groupsItem) {
    if (this.groups == null) {
      this.groups = new ArrayList<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

  /**
   * Get groups
   * @return groups
   */
  @javax.annotation.Nullable

  public List<GroupGeneralData> getGroups() {
    return groups;
  }


  public void setGroups(List<GroupGeneralData> groups) {
    this.groups = groups;
  }

  public ClientData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public ClientData imageId(Long imageId) {
    
    this.imageId = imageId;
    return this;
  }

  /**
   * Get imageId
   * @return imageId
   */
  @javax.annotation.Nullable

  public Long getImageId() {
    return imageId;
  }


  public void setImageId(Long imageId) {
    this.imageId = imageId;
  }

  public ClientData imagePresent(Boolean imagePresent) {
    
    this.imagePresent = imagePresent;
    return this;
  }

  /**
   * Get imagePresent
   * @return imagePresent
   */
  @javax.annotation.Nullable

  public Boolean getImagePresent() {
    return imagePresent;
  }


  public void setImagePresent(Boolean imagePresent) {
    this.imagePresent = imagePresent;
  }

  public ClientData isAddressEnabled(Boolean isAddressEnabled) {
    
    this.isAddressEnabled = isAddressEnabled;
    return this;
  }

  /**
   * Get isAddressEnabled
   * @return isAddressEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsAddressEnabled() {
    return isAddressEnabled;
  }


  public void setIsAddressEnabled(Boolean isAddressEnabled) {
    this.isAddressEnabled = isAddressEnabled;
  }

  public ClientData isStaff(Boolean isStaff) {
    
    this.isStaff = isStaff;
    return this;
  }

  /**
   * Get isStaff
   * @return isStaff
   */
  @javax.annotation.Nullable

  public Boolean getIsStaff() {
    return isStaff;
  }


  public void setIsStaff(Boolean isStaff) {
    this.isStaff = isStaff;
  }

  public ClientData lastname(String lastname) {
    
    this.lastname = lastname;
    return this;
  }

  /**
   * Get lastname
   * @return lastname
   */
  @javax.annotation.Nullable

  public String getLastname() {
    return lastname;
  }


  public void setLastname(String lastname) {
    this.lastname = lastname;
  }

  public ClientData legalForm(EnumOptionData legalForm) {
    
    this.legalForm = legalForm;
    return this;
  }

  /**
   * Get legalForm
   * @return legalForm
   */
  @javax.annotation.Nullable

  public EnumOptionData getLegalForm() {
    return legalForm;
  }


  public void setLegalForm(EnumOptionData legalForm) {
    this.legalForm = legalForm;
  }

  public ClientData legalFormId(Long legalFormId) {
    
    this.legalFormId = legalFormId;
    return this;
  }

  /**
   * Get legalFormId
   * @return legalFormId
   */
  @javax.annotation.Nullable

  public Long getLegalFormId() {
    return legalFormId;
  }


  public void setLegalFormId(Long legalFormId) {
    this.legalFormId = legalFormId;
  }

  public ClientData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public ClientData middlename(String middlename) {
    
    this.middlename = middlename;
    return this;
  }

  /**
   * Get middlename
   * @return middlename
   */
  @javax.annotation.Nullable

  public String getMiddlename() {
    return middlename;
  }


  public void setMiddlename(String middlename) {
    this.middlename = middlename;
  }

  public ClientData mobileNo(String mobileNo) {
    
    this.mobileNo = mobileNo;
    return this;
  }

  /**
   * Get mobileNo
   * @return mobileNo
   */
  @javax.annotation.Nullable

  public String getMobileNo() {
    return mobileNo;
  }


  public void setMobileNo(String mobileNo) {
    this.mobileNo = mobileNo;
  }

  public ClientData narrations(List<CodeValueData> narrations) {
    
    this.narrations = narrations;
    return this;
  }

  public ClientData addNarrationsItem(CodeValueData narrationsItem) {
    if (this.narrations == null) {
      this.narrations = new ArrayList<>();
    }
    this.narrations.add(narrationsItem);
    return this;
  }

  /**
   * Get narrations
   * @return narrations
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getNarrations() {
    return narrations;
  }


  public void setNarrations(List<CodeValueData> narrations) {
    this.narrations = narrations;
  }

  public ClientData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public ClientData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public ClientData officeOptions(List<OfficeData> officeOptions) {
    
    this.officeOptions = officeOptions;
    return this;
  }

  public ClientData addOfficeOptionsItem(OfficeData officeOptionsItem) {
    if (this.officeOptions == null) {
      this.officeOptions = new ArrayList<>();
    }
    this.officeOptions.add(officeOptionsItem);
    return this;
  }

  /**
   * Get officeOptions
   * @return officeOptions
   */
  @javax.annotation.Nullable

  public List<OfficeData> getOfficeOptions() {
    return officeOptions;
  }


  public void setOfficeOptions(List<OfficeData> officeOptions) {
    this.officeOptions = officeOptions;
  }

  public ClientData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public ClientData savingAccountOptions(List<SavingsAccountData> savingAccountOptions) {
    
    this.savingAccountOptions = savingAccountOptions;
    return this;
  }

  public ClientData addSavingAccountOptionsItem(SavingsAccountData savingAccountOptionsItem) {
    if (this.savingAccountOptions == null) {
      this.savingAccountOptions = new ArrayList<>();
    }
    this.savingAccountOptions.add(savingAccountOptionsItem);
    return this;
  }

  /**
   * Get savingAccountOptions
   * @return savingAccountOptions
   */
  @javax.annotation.Nullable

  public List<SavingsAccountData> getSavingAccountOptions() {
    return savingAccountOptions;
  }


  public void setSavingAccountOptions(List<SavingsAccountData> savingAccountOptions) {
    this.savingAccountOptions = savingAccountOptions;
  }

  public ClientData savingProductOptions(List<SavingsProductData> savingProductOptions) {
    
    this.savingProductOptions = savingProductOptions;
    return this;
  }

  public ClientData addSavingProductOptionsItem(SavingsProductData savingProductOptionsItem) {
    if (this.savingProductOptions == null) {
      this.savingProductOptions = new ArrayList<>();
    }
    this.savingProductOptions.add(savingProductOptionsItem);
    return this;
  }

  /**
   * Get savingProductOptions
   * @return savingProductOptions
   */
  @javax.annotation.Nullable

  public List<SavingsProductData> getSavingProductOptions() {
    return savingProductOptions;
  }


  public void setSavingProductOptions(List<SavingsProductData> savingProductOptions) {
    this.savingProductOptions = savingProductOptions;
  }

  public ClientData savingsAccountId(Long savingsAccountId) {
    
    this.savingsAccountId = savingsAccountId;
    return this;
  }

  /**
   * Get savingsAccountId
   * @return savingsAccountId
   */
  @javax.annotation.Nullable

  public Long getSavingsAccountId() {
    return savingsAccountId;
  }


  public void setSavingsAccountId(Long savingsAccountId) {
    this.savingsAccountId = savingsAccountId;
  }

  public ClientData savingsProductId(Long savingsProductId) {
    
    this.savingsProductId = savingsProductId;
    return this;
  }

  /**
   * Get savingsProductId
   * @return savingsProductId
   */
  @javax.annotation.Nullable

  public Long getSavingsProductId() {
    return savingsProductId;
  }


  public void setSavingsProductId(Long savingsProductId) {
    this.savingsProductId = savingsProductId;
  }

  public ClientData savingsProductName(String savingsProductName) {
    
    this.savingsProductName = savingsProductName;
    return this;
  }

  /**
   * Get savingsProductName
   * @return savingsProductName
   */
  @javax.annotation.Nullable

  public String getSavingsProductName() {
    return savingsProductName;
  }


  public void setSavingsProductName(String savingsProductName) {
    this.savingsProductName = savingsProductName;
  }

  public ClientData staffId(Long staffId) {
    
    this.staffId = staffId;
    return this;
  }

  /**
   * Get staffId
   * @return staffId
   */
  @javax.annotation.Nullable

  public Long getStaffId() {
    return staffId;
  }


  public void setStaffId(Long staffId) {
    this.staffId = staffId;
  }

  public ClientData staffName(String staffName) {
    
    this.staffName = staffName;
    return this;
  }

  /**
   * Get staffName
   * @return staffName
   */
  @javax.annotation.Nullable

  public String getStaffName() {
    return staffName;
  }


  public void setStaffName(String staffName) {
    this.staffName = staffName;
  }

  public ClientData staffOptions(List<StaffData> staffOptions) {
    
    this.staffOptions = staffOptions;
    return this;
  }

  public ClientData addStaffOptionsItem(StaffData staffOptionsItem) {
    if (this.staffOptions == null) {
      this.staffOptions = new ArrayList<>();
    }
    this.staffOptions.add(staffOptionsItem);
    return this;
  }

  /**
   * Get staffOptions
   * @return staffOptions
   */
  @javax.annotation.Nullable

  public List<StaffData> getStaffOptions() {
    return staffOptions;
  }


  public void setStaffOptions(List<StaffData> staffOptions) {
    this.staffOptions = staffOptions;
  }

  public ClientData status(EnumOptionData status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public EnumOptionData getStatus() {
    return status;
  }


  public void setStatus(EnumOptionData status) {
    this.status = status;
  }

  public ClientData subStatus(CodeValueData subStatus) {
    
    this.subStatus = subStatus;
    return this;
  }

  /**
   * Get subStatus
   * @return subStatus
   */
  @javax.annotation.Nullable

  public CodeValueData getSubStatus() {
    return subStatus;
  }


  public void setSubStatus(CodeValueData subStatus) {
    this.subStatus = subStatus;
  }

  public ClientData submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public ClientData timeline(ClientTimelineData timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public ClientTimelineData getTimeline() {
    return timeline;
  }


  public void setTimeline(ClientTimelineData timeline) {
    this.timeline = timeline;
  }

  public ClientData transferToOfficeId(Long transferToOfficeId) {
    
    this.transferToOfficeId = transferToOfficeId;
    return this;
  }

  /**
   * Get transferToOfficeId
   * @return transferToOfficeId
   */
  @javax.annotation.Nullable

  public Long getTransferToOfficeId() {
    return transferToOfficeId;
  }


  public void setTransferToOfficeId(Long transferToOfficeId) {
    this.transferToOfficeId = transferToOfficeId;
  }

  public ClientData transferToOfficeName(String transferToOfficeName) {
    
    this.transferToOfficeName = transferToOfficeName;
    return this;
  }

  /**
   * Get transferToOfficeName
   * @return transferToOfficeName
   */
  @javax.annotation.Nullable

  public String getTransferToOfficeName() {
    return transferToOfficeName;
  }


  public void setTransferToOfficeName(String transferToOfficeName) {
    this.transferToOfficeName = transferToOfficeName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientData clientData = (ClientData) o;
    return Objects.equals(this.accountNo, clientData.accountNo) &&
        Objects.equals(this.activationDate, clientData.activationDate) &&
        Objects.equals(this.active, clientData.active) &&
        Objects.equals(this.address, clientData.address) &&
        Objects.equals(this.clientClassification, clientData.clientClassification) &&
        Objects.equals(this.clientClassificationId, clientData.clientClassificationId) &&
        Objects.equals(this.clientClassificationOptions, clientData.clientClassificationOptions) &&
        Objects.equals(this.clientCollateralManagements, clientData.clientCollateralManagements) &&
        Objects.equals(this.clientLegalFormOptions, clientData.clientLegalFormOptions) &&
        Objects.equals(this.clientNonPersonConstitutionOptions, clientData.clientNonPersonConstitutionOptions) &&
        Objects.equals(this.clientNonPersonDetails, clientData.clientNonPersonDetails) &&
        Objects.equals(this.clientNonPersonMainBusinessLineOptions, clientData.clientNonPersonMainBusinessLineOptions) &&
        Objects.equals(this.clientType, clientData.clientType) &&
        Objects.equals(this.clientTypeId, clientData.clientTypeId) &&
        Objects.equals(this.clientTypeOptions, clientData.clientTypeOptions) &&
        Objects.equals(this.datatables, clientData.datatables) &&
        Objects.equals(this.dateFormat, clientData.dateFormat) &&
        Objects.equals(this.dateOfBirth, clientData.dateOfBirth) &&
        Objects.equals(this.displayName, clientData.displayName) &&
        Objects.equals(this.emailAddress, clientData.emailAddress) &&
        Objects.equals(this.externalId, clientData.externalId) &&
        Objects.equals(this.familyMemberOptions, clientData.familyMemberOptions) &&
        Objects.equals(this.firstname, clientData.firstname) &&
        Objects.equals(this.fullname, clientData.fullname) &&
        Objects.equals(this.gender, clientData.gender) &&
        Objects.equals(this.genderId, clientData.genderId) &&
        Objects.equals(this.genderOptions, clientData.genderOptions) &&
        Objects.equals(this.groups, clientData.groups) &&
        Objects.equals(this.id, clientData.id) &&
        Objects.equals(this.imageId, clientData.imageId) &&
        Objects.equals(this.imagePresent, clientData.imagePresent) &&
        Objects.equals(this.isAddressEnabled, clientData.isAddressEnabled) &&
        Objects.equals(this.isStaff, clientData.isStaff) &&
        Objects.equals(this.lastname, clientData.lastname) &&
        Objects.equals(this.legalForm, clientData.legalForm) &&
        Objects.equals(this.legalFormId, clientData.legalFormId) &&
        Objects.equals(this.locale, clientData.locale) &&
        Objects.equals(this.middlename, clientData.middlename) &&
        Objects.equals(this.mobileNo, clientData.mobileNo) &&
        Objects.equals(this.narrations, clientData.narrations) &&
        Objects.equals(this.officeId, clientData.officeId) &&
        Objects.equals(this.officeName, clientData.officeName) &&
        Objects.equals(this.officeOptions, clientData.officeOptions) &&
        Objects.equals(this.rowIndex, clientData.rowIndex) &&
        Objects.equals(this.savingAccountOptions, clientData.savingAccountOptions) &&
        Objects.equals(this.savingProductOptions, clientData.savingProductOptions) &&
        Objects.equals(this.savingsAccountId, clientData.savingsAccountId) &&
        Objects.equals(this.savingsProductId, clientData.savingsProductId) &&
        Objects.equals(this.savingsProductName, clientData.savingsProductName) &&
        Objects.equals(this.staffId, clientData.staffId) &&
        Objects.equals(this.staffName, clientData.staffName) &&
        Objects.equals(this.staffOptions, clientData.staffOptions) &&
        Objects.equals(this.status, clientData.status) &&
        Objects.equals(this.subStatus, clientData.subStatus) &&
        Objects.equals(this.submittedOnDate, clientData.submittedOnDate) &&
        Objects.equals(this.timeline, clientData.timeline) &&
        Objects.equals(this.transferToOfficeId, clientData.transferToOfficeId) &&
        Objects.equals(this.transferToOfficeName, clientData.transferToOfficeName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNo, activationDate, active, address, clientClassification, clientClassificationId, clientClassificationOptions, clientCollateralManagements, clientLegalFormOptions, clientNonPersonConstitutionOptions, clientNonPersonDetails, clientNonPersonMainBusinessLineOptions, clientType, clientTypeId, clientTypeOptions, datatables, dateFormat, dateOfBirth, displayName, emailAddress, externalId, familyMemberOptions, firstname, fullname, gender, genderId, genderOptions, groups, id, imageId, imagePresent, isAddressEnabled, isStaff, lastname, legalForm, legalFormId, locale, middlename, mobileNo, narrations, officeId, officeName, officeOptions, rowIndex, savingAccountOptions, savingProductOptions, savingsAccountId, savingsProductId, savingsProductName, staffId, staffName, staffOptions, status, subStatus, submittedOnDate, timeline, transferToOfficeId, transferToOfficeName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientData {\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    activationDate: ").append(toIndentedString(activationDate)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    clientClassification: ").append(toIndentedString(clientClassification)).append("\n");
    sb.append("    clientClassificationId: ").append(toIndentedString(clientClassificationId)).append("\n");
    sb.append("    clientClassificationOptions: ").append(toIndentedString(clientClassificationOptions)).append("\n");
    sb.append("    clientCollateralManagements: ").append(toIndentedString(clientCollateralManagements)).append("\n");
    sb.append("    clientLegalFormOptions: ").append(toIndentedString(clientLegalFormOptions)).append("\n");
    sb.append("    clientNonPersonConstitutionOptions: ").append(toIndentedString(clientNonPersonConstitutionOptions)).append("\n");
    sb.append("    clientNonPersonDetails: ").append(toIndentedString(clientNonPersonDetails)).append("\n");
    sb.append("    clientNonPersonMainBusinessLineOptions: ").append(toIndentedString(clientNonPersonMainBusinessLineOptions)).append("\n");
    sb.append("    clientType: ").append(toIndentedString(clientType)).append("\n");
    sb.append("    clientTypeId: ").append(toIndentedString(clientTypeId)).append("\n");
    sb.append("    clientTypeOptions: ").append(toIndentedString(clientTypeOptions)).append("\n");
    sb.append("    datatables: ").append(toIndentedString(datatables)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    familyMemberOptions: ").append(toIndentedString(familyMemberOptions)).append("\n");
    sb.append("    firstname: ").append(toIndentedString(firstname)).append("\n");
    sb.append("    fullname: ").append(toIndentedString(fullname)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    genderId: ").append(toIndentedString(genderId)).append("\n");
    sb.append("    genderOptions: ").append(toIndentedString(genderOptions)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
    sb.append("    imagePresent: ").append(toIndentedString(imagePresent)).append("\n");
    sb.append("    isAddressEnabled: ").append(toIndentedString(isAddressEnabled)).append("\n");
    sb.append("    isStaff: ").append(toIndentedString(isStaff)).append("\n");
    sb.append("    lastname: ").append(toIndentedString(lastname)).append("\n");
    sb.append("    legalForm: ").append(toIndentedString(legalForm)).append("\n");
    sb.append("    legalFormId: ").append(toIndentedString(legalFormId)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    middlename: ").append(toIndentedString(middlename)).append("\n");
    sb.append("    mobileNo: ").append(toIndentedString(mobileNo)).append("\n");
    sb.append("    narrations: ").append(toIndentedString(narrations)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    officeOptions: ").append(toIndentedString(officeOptions)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    savingAccountOptions: ").append(toIndentedString(savingAccountOptions)).append("\n");
    sb.append("    savingProductOptions: ").append(toIndentedString(savingProductOptions)).append("\n");
    sb.append("    savingsAccountId: ").append(toIndentedString(savingsAccountId)).append("\n");
    sb.append("    savingsProductId: ").append(toIndentedString(savingsProductId)).append("\n");
    sb.append("    savingsProductName: ").append(toIndentedString(savingsProductName)).append("\n");
    sb.append("    staffId: ").append(toIndentedString(staffId)).append("\n");
    sb.append("    staffName: ").append(toIndentedString(staffName)).append("\n");
    sb.append("    staffOptions: ").append(toIndentedString(staffOptions)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subStatus: ").append(toIndentedString(subStatus)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("    transferToOfficeId: ").append(toIndentedString(transferToOfficeId)).append("\n");
    sb.append("    transferToOfficeName: ").append(toIndentedString(transferToOfficeName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

