/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.FloatingRatePeriodData;

/**
 * FloatingRateData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class FloatingRateData {
  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_BASE_LENDING_RATE = "baseLendingRate";
  @SerializedName(SERIALIZED_NAME_BASE_LENDING_RATE)
  private Boolean baseLendingRate;

  public static final String SERIALIZED_NAME_CREATED_BY = "createdBy";
  @SerializedName(SERIALIZED_NAME_CREATED_BY)
  private String createdBy;

  public static final String SERIALIZED_NAME_CREATED_ON = "createdOn";
  @SerializedName(SERIALIZED_NAME_CREATED_ON)
  private OffsetDateTime createdOn;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IS_ACTIVE = "isActive";
  @SerializedName(SERIALIZED_NAME_IS_ACTIVE)
  private Boolean isActive;

  public static final String SERIALIZED_NAME_IS_BASE_LENDING_RATE = "isBaseLendingRate";
  @SerializedName(SERIALIZED_NAME_IS_BASE_LENDING_RATE)
  private Boolean isBaseLendingRate;

  public static final String SERIALIZED_NAME_MODIFIED_BY = "modifiedBy";
  @SerializedName(SERIALIZED_NAME_MODIFIED_BY)
  private String modifiedBy;

  public static final String SERIALIZED_NAME_MODIFIED_ON = "modifiedOn";
  @SerializedName(SERIALIZED_NAME_MODIFIED_ON)
  private OffsetDateTime modifiedOn;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_RATE_PERIODS = "ratePeriods";
  @SerializedName(SERIALIZED_NAME_RATE_PERIODS)
  private List<FloatingRatePeriodData> ratePeriods;

  public FloatingRateData() {
  }

  public FloatingRateData active(Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  @javax.annotation.Nullable

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }

  public FloatingRateData baseLendingRate(Boolean baseLendingRate) {
    
    this.baseLendingRate = baseLendingRate;
    return this;
  }

  /**
   * Get baseLendingRate
   * @return baseLendingRate
   */
  @javax.annotation.Nullable

  public Boolean getBaseLendingRate() {
    return baseLendingRate;
  }


  public void setBaseLendingRate(Boolean baseLendingRate) {
    this.baseLendingRate = baseLendingRate;
  }

  public FloatingRateData createdBy(String createdBy) {
    
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
   */
  @javax.annotation.Nullable

  public String getCreatedBy() {
    return createdBy;
  }


  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public FloatingRateData createdOn(OffsetDateTime createdOn) {
    
    this.createdOn = createdOn;
    return this;
  }

  /**
   * Get createdOn
   * @return createdOn
   */
  @javax.annotation.Nullable

  public OffsetDateTime getCreatedOn() {
    return createdOn;
  }


  public void setCreatedOn(OffsetDateTime createdOn) {
    this.createdOn = createdOn;
  }

  public FloatingRateData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public FloatingRateData isActive(Boolean isActive) {
    
    this.isActive = isActive;
    return this;
  }

  /**
   * Get isActive
   * @return isActive
   */
  @javax.annotation.Nullable

  public Boolean getIsActive() {
    return isActive;
  }


  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public FloatingRateData isBaseLendingRate(Boolean isBaseLendingRate) {
    
    this.isBaseLendingRate = isBaseLendingRate;
    return this;
  }

  /**
   * Get isBaseLendingRate
   * @return isBaseLendingRate
   */
  @javax.annotation.Nullable

  public Boolean getIsBaseLendingRate() {
    return isBaseLendingRate;
  }


  public void setIsBaseLendingRate(Boolean isBaseLendingRate) {
    this.isBaseLendingRate = isBaseLendingRate;
  }

  public FloatingRateData modifiedBy(String modifiedBy) {
    
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
   */
  @javax.annotation.Nullable

  public String getModifiedBy() {
    return modifiedBy;
  }


  public void setModifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public FloatingRateData modifiedOn(OffsetDateTime modifiedOn) {
    
    this.modifiedOn = modifiedOn;
    return this;
  }

  /**
   * Get modifiedOn
   * @return modifiedOn
   */
  @javax.annotation.Nullable

  public OffsetDateTime getModifiedOn() {
    return modifiedOn;
  }


  public void setModifiedOn(OffsetDateTime modifiedOn) {
    this.modifiedOn = modifiedOn;
  }

  public FloatingRateData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public FloatingRateData ratePeriods(List<FloatingRatePeriodData> ratePeriods) {
    
    this.ratePeriods = ratePeriods;
    return this;
  }

  public FloatingRateData addRatePeriodsItem(FloatingRatePeriodData ratePeriodsItem) {
    if (this.ratePeriods == null) {
      this.ratePeriods = new ArrayList<>();
    }
    this.ratePeriods.add(ratePeriodsItem);
    return this;
  }

  /**
   * Get ratePeriods
   * @return ratePeriods
   */
  @javax.annotation.Nullable

  public List<FloatingRatePeriodData> getRatePeriods() {
    return ratePeriods;
  }


  public void setRatePeriods(List<FloatingRatePeriodData> ratePeriods) {
    this.ratePeriods = ratePeriods;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FloatingRateData floatingRateData = (FloatingRateData) o;
    return Objects.equals(this.active, floatingRateData.active) &&
        Objects.equals(this.baseLendingRate, floatingRateData.baseLendingRate) &&
        Objects.equals(this.createdBy, floatingRateData.createdBy) &&
        Objects.equals(this.createdOn, floatingRateData.createdOn) &&
        Objects.equals(this.id, floatingRateData.id) &&
        Objects.equals(this.isActive, floatingRateData.isActive) &&
        Objects.equals(this.isBaseLendingRate, floatingRateData.isBaseLendingRate) &&
        Objects.equals(this.modifiedBy, floatingRateData.modifiedBy) &&
        Objects.equals(this.modifiedOn, floatingRateData.modifiedOn) &&
        Objects.equals(this.name, floatingRateData.name) &&
        Objects.equals(this.ratePeriods, floatingRateData.ratePeriods);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, baseLendingRate, createdBy, createdOn, id, isActive, isBaseLendingRate, modifiedBy, modifiedOn, name, ratePeriods);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FloatingRateData {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    baseLendingRate: ").append(toIndentedString(baseLendingRate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    isActive: ").append(toIndentedString(isActive)).append("\n");
    sb.append("    isBaseLendingRate: ").append(toIndentedString(isBaseLendingRate)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedOn: ").append(toIndentedString(modifiedOn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ratePeriods: ").append(toIndentedString(ratePeriods)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

