/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.CalendarData;
import org.apache.fineract.client.models.CenterData;
import org.apache.fineract.client.models.ClientData;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.DatatableData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GroupRoleData;
import org.apache.fineract.client.models.OfficeData;
import org.apache.fineract.client.models.StaffData;

/**
 * GroupGeneralData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GroupGeneralData {
  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ACTIVATION_DATE = "activationDate";
  @SerializedName(SERIALIZED_NAME_ACTIVATION_DATE)
  private LocalDate activationDate;

  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_ACTIVE_CLIENT_MEMBERS = "activeClientMembers";
  @SerializedName(SERIALIZED_NAME_ACTIVE_CLIENT_MEMBERS)
  private List<ClientData> activeClientMembers;

  public static final String SERIALIZED_NAME_AVAILABLE_ROLES = "availableRoles";
  @SerializedName(SERIALIZED_NAME_AVAILABLE_ROLES)
  private List<CodeValueData> availableRoles;

  public static final String SERIALIZED_NAME_CALENDARS_DATA = "calendarsData";
  @SerializedName(SERIALIZED_NAME_CALENDARS_DATA)
  private List<CalendarData> calendarsData;

  public static final String SERIALIZED_NAME_CENTER_ID = "centerId";
  @SerializedName(SERIALIZED_NAME_CENTER_ID)
  private Long centerId;

  public static final String SERIALIZED_NAME_CENTER_NAME = "centerName";
  @SerializedName(SERIALIZED_NAME_CENTER_NAME)
  private String centerName;

  public static final String SERIALIZED_NAME_CENTER_OPTIONS = "centerOptions";
  @SerializedName(SERIALIZED_NAME_CENTER_OPTIONS)
  private List<CenterData> centerOptions;

  public static final String SERIALIZED_NAME_CHILD_GROUP = "childGroup";
  @SerializedName(SERIALIZED_NAME_CHILD_GROUP)
  private Boolean childGroup;

  public static final String SERIALIZED_NAME_CLIENT_MEMBERS = "clientMembers";
  @SerializedName(SERIALIZED_NAME_CLIENT_MEMBERS)
  private List<ClientData> clientMembers;

  public static final String SERIALIZED_NAME_CLIENT_OPTIONS = "clientOptions";
  @SerializedName(SERIALIZED_NAME_CLIENT_OPTIONS)
  private List<ClientData> clientOptions;

  public static final String SERIALIZED_NAME_CLOSURE_REASONS = "closureReasons";
  @SerializedName(SERIALIZED_NAME_CLOSURE_REASONS)
  private List<CodeValueData> closureReasons;

  public static final String SERIALIZED_NAME_COLLECTION_MEETING_CALENDAR = "collectionMeetingCalendar";
  @SerializedName(SERIALIZED_NAME_COLLECTION_MEETING_CALENDAR)
  private CalendarData collectionMeetingCalendar;

  public static final String SERIALIZED_NAME_DATATABLES = "datatables";
  @SerializedName(SERIALIZED_NAME_DATATABLES)
  private List<DatatableData> datatables;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_GROUP_LEVEL = "groupLevel";
  @SerializedName(SERIALIZED_NAME_GROUP_LEVEL)
  private String groupLevel;

  public static final String SERIALIZED_NAME_GROUP_ROLES = "groupRoles";
  @SerializedName(SERIALIZED_NAME_GROUP_ROLES)
  private List<GroupRoleData> groupRoles;

  public static final String SERIALIZED_NAME_HIERARCHY = "hierarchy";
  @SerializedName(SERIALIZED_NAME_HIERARCHY)
  private String hierarchy;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_OFFICE_OPTIONS = "officeOptions";
  @SerializedName(SERIALIZED_NAME_OFFICE_OPTIONS)
  private List<OfficeData> officeOptions;

  public static final String SERIALIZED_NAME_PARENT_ID = "parentId";
  @SerializedName(SERIALIZED_NAME_PARENT_ID)
  private Long parentId;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SELECTED_ROLE = "selectedRole";
  @SerializedName(SERIALIZED_NAME_SELECTED_ROLE)
  private GroupRoleData selectedRole;

  public static final String SERIALIZED_NAME_STAFF_ID = "staffId";
  @SerializedName(SERIALIZED_NAME_STAFF_ID)
  private Long staffId;

  public static final String SERIALIZED_NAME_STAFF_NAME = "staffName";
  @SerializedName(SERIALIZED_NAME_STAFF_NAME)
  private String staffName;

  public static final String SERIALIZED_NAME_STAFF_OPTIONS = "staffOptions";
  @SerializedName(SERIALIZED_NAME_STAFF_OPTIONS)
  private List<StaffData> staffOptions;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private EnumOptionData status;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private Object timeline;

  public GroupGeneralData() {
  }

  public GroupGeneralData accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public GroupGeneralData activationDate(LocalDate activationDate) {
    
    this.activationDate = activationDate;
    return this;
  }

  /**
   * Get activationDate
   * @return activationDate
   */
  @javax.annotation.Nullable

  public LocalDate getActivationDate() {
    return activationDate;
  }


  public void setActivationDate(LocalDate activationDate) {
    this.activationDate = activationDate;
  }

  public GroupGeneralData active(Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  @javax.annotation.Nullable

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }

  public GroupGeneralData activeClientMembers(List<ClientData> activeClientMembers) {
    
    this.activeClientMembers = activeClientMembers;
    return this;
  }

  public GroupGeneralData addActiveClientMembersItem(ClientData activeClientMembersItem) {
    if (this.activeClientMembers == null) {
      this.activeClientMembers = new ArrayList<>();
    }
    this.activeClientMembers.add(activeClientMembersItem);
    return this;
  }

  /**
   * Get activeClientMembers
   * @return activeClientMembers
   */
  @javax.annotation.Nullable

  public List<ClientData> getActiveClientMembers() {
    return activeClientMembers;
  }


  public void setActiveClientMembers(List<ClientData> activeClientMembers) {
    this.activeClientMembers = activeClientMembers;
  }

  public GroupGeneralData availableRoles(List<CodeValueData> availableRoles) {
    
    this.availableRoles = availableRoles;
    return this;
  }

  public GroupGeneralData addAvailableRolesItem(CodeValueData availableRolesItem) {
    if (this.availableRoles == null) {
      this.availableRoles = new ArrayList<>();
    }
    this.availableRoles.add(availableRolesItem);
    return this;
  }

  /**
   * Get availableRoles
   * @return availableRoles
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getAvailableRoles() {
    return availableRoles;
  }


  public void setAvailableRoles(List<CodeValueData> availableRoles) {
    this.availableRoles = availableRoles;
  }

  public GroupGeneralData calendarsData(List<CalendarData> calendarsData) {
    
    this.calendarsData = calendarsData;
    return this;
  }

  public GroupGeneralData addCalendarsDataItem(CalendarData calendarsDataItem) {
    if (this.calendarsData == null) {
      this.calendarsData = new ArrayList<>();
    }
    this.calendarsData.add(calendarsDataItem);
    return this;
  }

  /**
   * Get calendarsData
   * @return calendarsData
   */
  @javax.annotation.Nullable

  public List<CalendarData> getCalendarsData() {
    return calendarsData;
  }


  public void setCalendarsData(List<CalendarData> calendarsData) {
    this.calendarsData = calendarsData;
  }

  public GroupGeneralData centerId(Long centerId) {
    
    this.centerId = centerId;
    return this;
  }

  /**
   * Get centerId
   * @return centerId
   */
  @javax.annotation.Nullable

  public Long getCenterId() {
    return centerId;
  }


  public void setCenterId(Long centerId) {
    this.centerId = centerId;
  }

  public GroupGeneralData centerName(String centerName) {
    
    this.centerName = centerName;
    return this;
  }

  /**
   * Get centerName
   * @return centerName
   */
  @javax.annotation.Nullable

  public String getCenterName() {
    return centerName;
  }


  public void setCenterName(String centerName) {
    this.centerName = centerName;
  }

  public GroupGeneralData centerOptions(List<CenterData> centerOptions) {
    
    this.centerOptions = centerOptions;
    return this;
  }

  public GroupGeneralData addCenterOptionsItem(CenterData centerOptionsItem) {
    if (this.centerOptions == null) {
      this.centerOptions = new ArrayList<>();
    }
    this.centerOptions.add(centerOptionsItem);
    return this;
  }

  /**
   * Get centerOptions
   * @return centerOptions
   */
  @javax.annotation.Nullable

  public List<CenterData> getCenterOptions() {
    return centerOptions;
  }


  public void setCenterOptions(List<CenterData> centerOptions) {
    this.centerOptions = centerOptions;
  }

  public GroupGeneralData childGroup(Boolean childGroup) {
    
    this.childGroup = childGroup;
    return this;
  }

  /**
   * Get childGroup
   * @return childGroup
   */
  @javax.annotation.Nullable

  public Boolean getChildGroup() {
    return childGroup;
  }


  public void setChildGroup(Boolean childGroup) {
    this.childGroup = childGroup;
  }

  public GroupGeneralData clientMembers(List<ClientData> clientMembers) {
    
    this.clientMembers = clientMembers;
    return this;
  }

  public GroupGeneralData addClientMembersItem(ClientData clientMembersItem) {
    if (this.clientMembers == null) {
      this.clientMembers = new ArrayList<>();
    }
    this.clientMembers.add(clientMembersItem);
    return this;
  }

  /**
   * Get clientMembers
   * @return clientMembers
   */
  @javax.annotation.Nullable

  public List<ClientData> getClientMembers() {
    return clientMembers;
  }


  public void setClientMembers(List<ClientData> clientMembers) {
    this.clientMembers = clientMembers;
  }

  public GroupGeneralData clientOptions(List<ClientData> clientOptions) {
    
    this.clientOptions = clientOptions;
    return this;
  }

  public GroupGeneralData addClientOptionsItem(ClientData clientOptionsItem) {
    if (this.clientOptions == null) {
      this.clientOptions = new ArrayList<>();
    }
    this.clientOptions.add(clientOptionsItem);
    return this;
  }

  /**
   * Get clientOptions
   * @return clientOptions
   */
  @javax.annotation.Nullable

  public List<ClientData> getClientOptions() {
    return clientOptions;
  }


  public void setClientOptions(List<ClientData> clientOptions) {
    this.clientOptions = clientOptions;
  }

  public GroupGeneralData closureReasons(List<CodeValueData> closureReasons) {
    
    this.closureReasons = closureReasons;
    return this;
  }

  public GroupGeneralData addClosureReasonsItem(CodeValueData closureReasonsItem) {
    if (this.closureReasons == null) {
      this.closureReasons = new ArrayList<>();
    }
    this.closureReasons.add(closureReasonsItem);
    return this;
  }

  /**
   * Get closureReasons
   * @return closureReasons
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClosureReasons() {
    return closureReasons;
  }


  public void setClosureReasons(List<CodeValueData> closureReasons) {
    this.closureReasons = closureReasons;
  }

  public GroupGeneralData collectionMeetingCalendar(CalendarData collectionMeetingCalendar) {
    
    this.collectionMeetingCalendar = collectionMeetingCalendar;
    return this;
  }

  /**
   * Get collectionMeetingCalendar
   * @return collectionMeetingCalendar
   */
  @javax.annotation.Nullable

  public CalendarData getCollectionMeetingCalendar() {
    return collectionMeetingCalendar;
  }


  public void setCollectionMeetingCalendar(CalendarData collectionMeetingCalendar) {
    this.collectionMeetingCalendar = collectionMeetingCalendar;
  }

  public GroupGeneralData datatables(List<DatatableData> datatables) {
    
    this.datatables = datatables;
    return this;
  }

  public GroupGeneralData addDatatablesItem(DatatableData datatablesItem) {
    if (this.datatables == null) {
      this.datatables = new ArrayList<>();
    }
    this.datatables.add(datatablesItem);
    return this;
  }

  /**
   * Get datatables
   * @return datatables
   */
  @javax.annotation.Nullable

  public List<DatatableData> getDatatables() {
    return datatables;
  }


  public void setDatatables(List<DatatableData> datatables) {
    this.datatables = datatables;
  }

  public GroupGeneralData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public GroupGeneralData externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public GroupGeneralData groupLevel(String groupLevel) {
    
    this.groupLevel = groupLevel;
    return this;
  }

  /**
   * Get groupLevel
   * @return groupLevel
   */
  @javax.annotation.Nullable

  public String getGroupLevel() {
    return groupLevel;
  }


  public void setGroupLevel(String groupLevel) {
    this.groupLevel = groupLevel;
  }

  public GroupGeneralData groupRoles(List<GroupRoleData> groupRoles) {
    
    this.groupRoles = groupRoles;
    return this;
  }

  public GroupGeneralData addGroupRolesItem(GroupRoleData groupRolesItem) {
    if (this.groupRoles == null) {
      this.groupRoles = new ArrayList<>();
    }
    this.groupRoles.add(groupRolesItem);
    return this;
  }

  /**
   * Get groupRoles
   * @return groupRoles
   */
  @javax.annotation.Nullable

  public List<GroupRoleData> getGroupRoles() {
    return groupRoles;
  }


  public void setGroupRoles(List<GroupRoleData> groupRoles) {
    this.groupRoles = groupRoles;
  }

  public GroupGeneralData hierarchy(String hierarchy) {
    
    this.hierarchy = hierarchy;
    return this;
  }

  /**
   * Get hierarchy
   * @return hierarchy
   */
  @javax.annotation.Nullable

  public String getHierarchy() {
    return hierarchy;
  }


  public void setHierarchy(String hierarchy) {
    this.hierarchy = hierarchy;
  }

  public GroupGeneralData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GroupGeneralData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public GroupGeneralData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public GroupGeneralData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public GroupGeneralData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public GroupGeneralData officeOptions(List<OfficeData> officeOptions) {
    
    this.officeOptions = officeOptions;
    return this;
  }

  public GroupGeneralData addOfficeOptionsItem(OfficeData officeOptionsItem) {
    if (this.officeOptions == null) {
      this.officeOptions = new ArrayList<>();
    }
    this.officeOptions.add(officeOptionsItem);
    return this;
  }

  /**
   * Get officeOptions
   * @return officeOptions
   */
  @javax.annotation.Nullable

  public List<OfficeData> getOfficeOptions() {
    return officeOptions;
  }


  public void setOfficeOptions(List<OfficeData> officeOptions) {
    this.officeOptions = officeOptions;
  }

  public GroupGeneralData parentId(Long parentId) {
    
    this.parentId = parentId;
    return this;
  }

  /**
   * Get parentId
   * @return parentId
   */
  @javax.annotation.Nullable

  public Long getParentId() {
    return parentId;
  }


  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  public GroupGeneralData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public GroupGeneralData selectedRole(GroupRoleData selectedRole) {
    
    this.selectedRole = selectedRole;
    return this;
  }

  /**
   * Get selectedRole
   * @return selectedRole
   */
  @javax.annotation.Nullable

  public GroupRoleData getSelectedRole() {
    return selectedRole;
  }


  public void setSelectedRole(GroupRoleData selectedRole) {
    this.selectedRole = selectedRole;
  }

  public GroupGeneralData staffId(Long staffId) {
    
    this.staffId = staffId;
    return this;
  }

  /**
   * Get staffId
   * @return staffId
   */
  @javax.annotation.Nullable

  public Long getStaffId() {
    return staffId;
  }


  public void setStaffId(Long staffId) {
    this.staffId = staffId;
  }

  public GroupGeneralData staffName(String staffName) {
    
    this.staffName = staffName;
    return this;
  }

  /**
   * Get staffName
   * @return staffName
   */
  @javax.annotation.Nullable

  public String getStaffName() {
    return staffName;
  }


  public void setStaffName(String staffName) {
    this.staffName = staffName;
  }

  public GroupGeneralData staffOptions(List<StaffData> staffOptions) {
    
    this.staffOptions = staffOptions;
    return this;
  }

  public GroupGeneralData addStaffOptionsItem(StaffData staffOptionsItem) {
    if (this.staffOptions == null) {
      this.staffOptions = new ArrayList<>();
    }
    this.staffOptions.add(staffOptionsItem);
    return this;
  }

  /**
   * Get staffOptions
   * @return staffOptions
   */
  @javax.annotation.Nullable

  public List<StaffData> getStaffOptions() {
    return staffOptions;
  }


  public void setStaffOptions(List<StaffData> staffOptions) {
    this.staffOptions = staffOptions;
  }

  public GroupGeneralData status(EnumOptionData status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public EnumOptionData getStatus() {
    return status;
  }


  public void setStatus(EnumOptionData status) {
    this.status = status;
  }

  public GroupGeneralData submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public GroupGeneralData timeline(Object timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public Object getTimeline() {
    return timeline;
  }


  public void setTimeline(Object timeline) {
    this.timeline = timeline;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupGeneralData groupGeneralData = (GroupGeneralData) o;
    return Objects.equals(this.accountNo, groupGeneralData.accountNo) &&
        Objects.equals(this.activationDate, groupGeneralData.activationDate) &&
        Objects.equals(this.active, groupGeneralData.active) &&
        Objects.equals(this.activeClientMembers, groupGeneralData.activeClientMembers) &&
        Objects.equals(this.availableRoles, groupGeneralData.availableRoles) &&
        Objects.equals(this.calendarsData, groupGeneralData.calendarsData) &&
        Objects.equals(this.centerId, groupGeneralData.centerId) &&
        Objects.equals(this.centerName, groupGeneralData.centerName) &&
        Objects.equals(this.centerOptions, groupGeneralData.centerOptions) &&
        Objects.equals(this.childGroup, groupGeneralData.childGroup) &&
        Objects.equals(this.clientMembers, groupGeneralData.clientMembers) &&
        Objects.equals(this.clientOptions, groupGeneralData.clientOptions) &&
        Objects.equals(this.closureReasons, groupGeneralData.closureReasons) &&
        Objects.equals(this.collectionMeetingCalendar, groupGeneralData.collectionMeetingCalendar) &&
        Objects.equals(this.datatables, groupGeneralData.datatables) &&
        Objects.equals(this.dateFormat, groupGeneralData.dateFormat) &&
        Objects.equals(this.externalId, groupGeneralData.externalId) &&
        Objects.equals(this.groupLevel, groupGeneralData.groupLevel) &&
        Objects.equals(this.groupRoles, groupGeneralData.groupRoles) &&
        Objects.equals(this.hierarchy, groupGeneralData.hierarchy) &&
        Objects.equals(this.id, groupGeneralData.id) &&
        Objects.equals(this.locale, groupGeneralData.locale) &&
        Objects.equals(this.name, groupGeneralData.name) &&
        Objects.equals(this.officeId, groupGeneralData.officeId) &&
        Objects.equals(this.officeName, groupGeneralData.officeName) &&
        Objects.equals(this.officeOptions, groupGeneralData.officeOptions) &&
        Objects.equals(this.parentId, groupGeneralData.parentId) &&
        Objects.equals(this.rowIndex, groupGeneralData.rowIndex) &&
        Objects.equals(this.selectedRole, groupGeneralData.selectedRole) &&
        Objects.equals(this.staffId, groupGeneralData.staffId) &&
        Objects.equals(this.staffName, groupGeneralData.staffName) &&
        Objects.equals(this.staffOptions, groupGeneralData.staffOptions) &&
        Objects.equals(this.status, groupGeneralData.status) &&
        Objects.equals(this.submittedOnDate, groupGeneralData.submittedOnDate) &&
        Objects.equals(this.timeline, groupGeneralData.timeline);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNo, activationDate, active, activeClientMembers, availableRoles, calendarsData, centerId, centerName, centerOptions, childGroup, clientMembers, clientOptions, closureReasons, collectionMeetingCalendar, datatables, dateFormat, externalId, groupLevel, groupRoles, hierarchy, id, locale, name, officeId, officeName, officeOptions, parentId, rowIndex, selectedRole, staffId, staffName, staffOptions, status, submittedOnDate, timeline);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupGeneralData {\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    activationDate: ").append(toIndentedString(activationDate)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    activeClientMembers: ").append(toIndentedString(activeClientMembers)).append("\n");
    sb.append("    availableRoles: ").append(toIndentedString(availableRoles)).append("\n");
    sb.append("    calendarsData: ").append(toIndentedString(calendarsData)).append("\n");
    sb.append("    centerId: ").append(toIndentedString(centerId)).append("\n");
    sb.append("    centerName: ").append(toIndentedString(centerName)).append("\n");
    sb.append("    centerOptions: ").append(toIndentedString(centerOptions)).append("\n");
    sb.append("    childGroup: ").append(toIndentedString(childGroup)).append("\n");
    sb.append("    clientMembers: ").append(toIndentedString(clientMembers)).append("\n");
    sb.append("    clientOptions: ").append(toIndentedString(clientOptions)).append("\n");
    sb.append("    closureReasons: ").append(toIndentedString(closureReasons)).append("\n");
    sb.append("    collectionMeetingCalendar: ").append(toIndentedString(collectionMeetingCalendar)).append("\n");
    sb.append("    datatables: ").append(toIndentedString(datatables)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    groupLevel: ").append(toIndentedString(groupLevel)).append("\n");
    sb.append("    groupRoles: ").append(toIndentedString(groupRoles)).append("\n");
    sb.append("    hierarchy: ").append(toIndentedString(hierarchy)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    officeOptions: ").append(toIndentedString(officeOptions)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    selectedRole: ").append(toIndentedString(selectedRole)).append("\n");
    sb.append("    staffId: ").append(toIndentedString(staffId)).append("\n");
    sb.append("    staffName: ").append(toIndentedString(staffName)).append("\n");
    sb.append("    staffOptions: ").append(toIndentedString(staffOptions)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

