/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.AdvancedPaymentData;
import org.apache.fineract.client.models.ChargeData;
import org.apache.fineract.client.models.ChargeOffReasonToGLAccountMapper;
import org.apache.fineract.client.models.ChargeToGLAccountMapper;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.CreditAllocationData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.DelinquencyBucketData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.FloatingRateData;
import org.apache.fineract.client.models.FundData;
import org.apache.fineract.client.models.GLAccountData;
import org.apache.fineract.client.models.LoanProductBorrowerCycleVariationData;
import org.apache.fineract.client.models.LoanProductConfigurableAttributes;
import org.apache.fineract.client.models.LoanProductGuaranteeData;
import org.apache.fineract.client.models.LoanProductInterestRecalculationData;
import org.apache.fineract.client.models.PaymentTypeData;
import org.apache.fineract.client.models.PaymentTypeToGLAccountMapper;
import org.apache.fineract.client.models.RateData;
import org.apache.fineract.client.models.StringEnumOptionData;
import org.apache.fineract.client.models.TransactionProcessingStrategyData;

/**
 * LoanProductData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductData {
  public static final String SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION = "accountMovesOutOfNPAOnlyOnArrearsCompletion";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION)
  private Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion;

  public static final String SERIALIZED_NAME_ACCOUNTING_MAPPING_OPTIONS = "accountingMappingOptions";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_MAPPING_OPTIONS)
  private Map<String, List<GLAccountData>> accountingMappingOptions;

  public static final String SERIALIZED_NAME_ACCOUNTING_MAPPINGS = "accountingMappings";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_MAPPINGS)
  private Map<String, Object> accountingMappings;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private EnumOptionData accountingRule;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE_OPTIONS = "accountingRuleOptions";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE_OPTIONS)
  private List<EnumOptionData> accountingRuleOptions;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_FUTURE_INSTALLMENT_ALLOCATION_RULES = "advancedPaymentAllocationFutureInstallmentAllocationRules";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_FUTURE_INSTALLMENT_ALLOCATION_RULES)
  private List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TRANSACTION_TYPES = "advancedPaymentAllocationTransactionTypes";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TRANSACTION_TYPES)
  private List<EnumOptionData> advancedPaymentAllocationTransactionTypes;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TYPES = "advancedPaymentAllocationTypes";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TYPES)
  private List<EnumOptionData> advancedPaymentAllocationTypes;

  public static final String SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED = "allowApprovedDisbursedAmountsOverApplied";
  @SerializedName(SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED)
  private Boolean allowApprovedDisbursedAmountsOverApplied;

  public static final String SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES = "allowAttributeOverrides";
  @SerializedName(SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES)
  private LoanProductConfigurableAttributes allowAttributeOverrides;

  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION = "allowPartialPeriodInterestCalculation";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION)
  private Boolean allowPartialPeriodInterestCalculation;

  public static final String SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS = "allowVariableInstallments";
  @SerializedName(SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS)
  private Boolean allowVariableInstallments;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private EnumOptionData amortizationType;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE_OPTIONS = "amortizationTypeOptions";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE_OPTIONS)
  private List<EnumOptionData> amortizationTypeOptions;

  public static final String SERIALIZED_NAME_ANNUAL_INTEREST_RATE = "annualInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INTEREST_RATE)
  private BigDecimal annualInterestRate;

  public static final String SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT = "canDefineInstallmentAmount";
  @SerializedName(SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT)
  private Boolean canDefineInstallmentAmount;

  public static final String SERIALIZED_NAME_CAN_USE_FOR_TOPUP = "canUseForTopup";
  @SerializedName(SERIALIZED_NAME_CAN_USE_FOR_TOPUP)
  private Boolean canUseForTopup;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private StringEnumOptionData chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR_OPTIONS = "chargeOffBehaviourOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR_OPTIONS)
  private List<StringEnumOptionData> chargeOffBehaviourOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS = "chargeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS)
  private List<CodeValueData> chargeOffReasonOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS = "chargeOffReasonToExpenseAccountMappings";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS)
  private List<ChargeOffReasonToGLAccountMapper> chargeOffReasonToExpenseAccountMappings;

  public static final String SERIALIZED_NAME_CHARGE_OPTIONS = "chargeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OPTIONS)
  private List<ChargeData> chargeOptions;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<ChargeData> charges;

  public static final String SERIALIZED_NAME_CLOSE_DATE = "closeDate";
  @SerializedName(SERIALIZED_NAME_CLOSE_DATE)
  private LocalDate closeDate;

  public static final String SERIALIZED_NAME_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION = "compoundingToBePostedAsTransaction";
  @SerializedName(SERIALIZED_NAME_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION)
  private Boolean compoundingToBePostedAsTransaction;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION = "creditAllocation";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION)
  private List<CreditAllocationData> creditAllocation;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION_ALLOCATION_TYPES = "creditAllocationAllocationTypes";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION_ALLOCATION_TYPES)
  private List<EnumOptionData> creditAllocationAllocationTypes;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION_TRANSACTION_TYPES = "creditAllocationTransactionTypes";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION_TRANSACTION_TYPES)
  private List<EnumOptionData> creditAllocationTransactionTypes;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_CURRENCY_OPTIONS = "currencyOptions";
  @SerializedName(SERIALIZED_NAME_CURRENCY_OPTIONS)
  private List<CurrencyData> currencyOptions;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private EnumOptionData daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE_OPTIONS = "daysInMonthTypeOptions";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE_OPTIONS)
  private List<EnumOptionData> daysInMonthTypeOptions;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private EnumOptionData daysInYearType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_OPTIONS = "daysInYearTypeOptions";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_OPTIONS)
  private List<EnumOptionData> daysInYearTypeOptions;

  public static final String SERIALIZED_NAME_DEFAULT_DIFFERENTIAL_LENDING_RATE = "defaultDifferentialLendingRate";
  @SerializedName(SERIALIZED_NAME_DEFAULT_DIFFERENTIAL_LENDING_RATE)
  private BigDecimal defaultDifferentialLendingRate;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET = "delinquencyBucket";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET)
  private DelinquencyBucketData delinquencyBucket;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET_OPTIONS = "delinquencyBucketOptions";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET_OPTIONS)
  private List<DelinquencyBucketData> delinquencyBucketOptions;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT = "dueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer dueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
  @SerializedName(SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING)
  private Boolean enableAccrualActivityPosting;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EQUAL_AMORTIZATION = "equalAmortization";
  @SerializedName(SERIALIZED_NAME_EQUAL_AMORTIZATION)
  private Boolean equalAmortization;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS = "feeToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<ChargeToGLAccountMapper> feeToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED = "floatingInterestRateCalculationAllowed";
  @SerializedName(SERIALIZED_NAME_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED)
  private Boolean floatingInterestRateCalculationAllowed;

  public static final String SERIALIZED_NAME_FLOATING_RATE_ID = "floatingRateId";
  @SerializedName(SERIALIZED_NAME_FLOATING_RATE_ID)
  private Integer floatingRateId;

  public static final String SERIALIZED_NAME_FLOATING_RATE_NAME = "floatingRateName";
  @SerializedName(SERIALIZED_NAME_FLOATING_RATE_NAME)
  private String floatingRateName;

  public static final String SERIALIZED_NAME_FLOATING_RATE_OPTIONS = "floatingRateOptions";
  @SerializedName(SERIALIZED_NAME_FLOATING_RATE_OPTIONS)
  private List<FloatingRateData> floatingRateOptions;

  public static final String SERIALIZED_NAME_FUND_ID = "fundId";
  @SerializedName(SERIALIZED_NAME_FUND_ID)
  private Long fundId;

  public static final String SERIALIZED_NAME_FUND_NAME = "fundName";
  @SerializedName(SERIALIZED_NAME_FUND_NAME)
  private String fundName;

  public static final String SERIALIZED_NAME_FUND_OPTIONS = "fundOptions";
  @SerializedName(SERIALIZED_NAME_FUND_OPTIONS)
  private List<FundData> fundOptions;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED = "graceOnInterestCharged";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED)
  private Integer graceOnInterestCharged;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  public static final String SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS = "holdGuaranteeFunds";
  @SerializedName(SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS)
  private Boolean holdGuaranteeFunds;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private BigDecimal inArrearsTolerance;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF = "installmentAmountInMultiplesOf";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF)
  private Integer installmentAmountInMultiplesOf;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private EnumOptionData interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE_OPTIONS = "interestCalculationPeriodTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE_OPTIONS)
  private List<EnumOptionData> interestCalculationPeriodTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RATE_DIFFERENTIAL = "interestRateDifferential";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_DIFFERENTIAL)
  private BigDecimal interestRateDifferential;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private EnumOptionData interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE_OPTIONS = "interestRateFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> interestRateFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private BigDecimal interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<LoanProductBorrowerCycleVariationData> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_TYPE_OPTIONS = "interestRecalculationCompoundingTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_TYPE_OPTIONS)
  private List<EnumOptionData> interestRecalculationCompoundingTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_DATA = "interestRecalculationData";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_DATA)
  private LoanProductInterestRecalculationData interestRecalculationData;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_DAY_OF_WEEK_TYPE_OPTIONS = "interestRecalculationDayOfWeekTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_DAY_OF_WEEK_TYPE_OPTIONS)
  private List<EnumOptionData> interestRecalculationDayOfWeekTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED = "interestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED)
  private Boolean interestRecalculationEnabled;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_FREQUENCY_TYPE_OPTIONS = "interestRecalculationFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> interestRecalculationFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_NTH_DAY_TYPE_OPTIONS = "interestRecalculationNthDayTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_NTH_DAY_TYPE_OPTIONS)
  private List<EnumOptionData> interestRecalculationNthDayTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private EnumOptionData interestType;

  public static final String SERIALIZED_NAME_INTEREST_TYPE_OPTIONS = "interestTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE_OPTIONS)
  private List<EnumOptionData> interestTypeOptions;

  public static final String SERIALIZED_NAME_IS_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION = "isAllowPartialPeriodInterestCalculation";
  @SerializedName(SERIALIZED_NAME_IS_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION)
  private Boolean isAllowPartialPeriodInterestCalculation;

  public static final String SERIALIZED_NAME_IS_EQUAL_AMORTIZATION = "isEqualAmortization";
  @SerializedName(SERIALIZED_NAME_IS_EQUAL_AMORTIZATION)
  private Boolean isEqualAmortization;

  public static final String SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED = "isFloatingInterestRateCalculationAllowed";
  @SerializedName(SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED)
  private Boolean isFloatingInterestRateCalculationAllowed;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES = "isLinkedToFloatingInterestRates";
  @SerializedName(SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES)
  private Boolean isLinkedToFloatingInterestRates;

  public static final String SERIALIZED_NAME_IS_RATES_ENABLED = "isRatesEnabled";
  @SerializedName(SERIALIZED_NAME_IS_RATES_ENABLED)
  private Boolean isRatesEnabled;

  public static final String SERIALIZED_NAME_LINKED_TO_FLOATING_INTEREST_RATES = "linkedToFloatingInterestRates";
  @SerializedName(SERIALIZED_NAME_LINKED_TO_FLOATING_INTEREST_RATES)
  private Boolean linkedToFloatingInterestRates;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_CONFIGURABLE_ATTRIBUTES = "loanProductConfigurableAttributes";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_CONFIGURABLE_ATTRIBUTES)
  private LoanProductConfigurableAttributes loanProductConfigurableAttributes;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private EnumOptionData loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE_OPTIONS = "loanScheduleProcessingTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE_OPTIONS)
  private List<EnumOptionData> loanScheduleProcessingTypeOptions;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private EnumOptionData loanScheduleType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE_OPTIONS = "loanScheduleTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE_OPTIONS)
  private List<EnumOptionData> loanScheduleTypeOptions;

  public static final String SERIALIZED_NAME_MAX_DIFFERENTIAL_LENDING_RATE = "maxDifferentialLendingRate";
  @SerializedName(SERIALIZED_NAME_MAX_DIFFERENTIAL_LENDING_RATE)
  private BigDecimal maxDifferentialLendingRate;

  public static final String SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD = "maxInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD)
  private BigDecimal maxInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL = "maxPrincipal";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL)
  private BigDecimal maxPrincipal;

  public static final String SERIALIZED_NAME_MAX_TRANCHE_COUNT = "maxTrancheCount";
  @SerializedName(SERIALIZED_NAME_MAX_TRANCHE_COUNT)
  private Integer maxTrancheCount;

  public static final String SERIALIZED_NAME_MAXIMUM_GAP = "maximumGap";
  @SerializedName(SERIALIZED_NAME_MAXIMUM_GAP)
  private Integer maximumGap;

  public static final String SERIALIZED_NAME_MIN_DIFFERENTIAL_LENDING_RATE = "minDifferentialLendingRate";
  @SerializedName(SERIALIZED_NAME_MIN_DIFFERENTIAL_LENDING_RATE)
  private BigDecimal minDifferentialLendingRate;

  public static final String SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD = "minInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD)
  private BigDecimal minInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL = "minPrincipal";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL)
  private BigDecimal minPrincipal;

  public static final String SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT = "minimumDaysBetweenDisbursalAndFirstRepayment";
  @SerializedName(SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT)
  private Integer minimumDaysBetweenDisbursalAndFirstRepayment;

  public static final String SERIALIZED_NAME_MINIMUM_GAP = "minimumGap";
  @SerializedName(SERIALIZED_NAME_MINIMUM_GAP)
  private Integer minimumGap;

  public static final String SERIALIZED_NAME_MULTI_DISBURSE_LOAN = "multiDisburseLoan";
  @SerializedName(SERIALIZED_NAME_MULTI_DISBURSE_LOAN)
  private Boolean multiDisburseLoan;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<LoanProductBorrowerCycleVariationData> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private BigDecimal outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE)
  private String overAppliedCalculationType;

  public static final String SERIALIZED_NAME_OVER_APPLIED_NUMBER = "overAppliedNumber";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_NUMBER)
  private Integer overAppliedNumber;

  public static final String SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT = "overDueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer overDueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A = "overdueDaysForNPA";
  @SerializedName(SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A)
  private Integer overdueDaysForNPA;

  public static final String SERIALIZED_NAME_PAYMENT_ALLOCATION = "paymentAllocation";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ALLOCATION)
  private List<AdvancedPaymentData> paymentAllocation;

  public static final String SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS = "paymentChannelToFundSourceMappings";
  @SerializedName(SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS)
  private List<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS = "paymentTypeOptions";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS)
  private List<PaymentTypeData> paymentTypeOptions;

  public static final String SERIALIZED_NAME_PENALTY_OPTIONS = "penaltyOptions";
  @SerializedName(SERIALIZED_NAME_PENALTY_OPTIONS)
  private List<ChargeData> penaltyOptions;

  public static final String SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS = "penaltyToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<ChargeToGLAccountMapper> penaltyToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY_OPTIONS = "preClosureInterestCalculationStrategyOptions";
  @SerializedName(SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY_OPTIONS)
  private List<EnumOptionData> preClosureInterestCalculationStrategyOptions;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private BigDecimal principal;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT = "principalThresholdForLastInstallment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT)
  private BigDecimal principalThresholdForLastInstallment;

  public static final String SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "principalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<LoanProductBorrowerCycleVariationData> principalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_PRODUCT_GUARANTEE_DATA = "productGuaranteeData";
  @SerializedName(SERIALIZED_NAME_PRODUCT_GUARANTEE_DATA)
  private LoanProductGuaranteeData productGuaranteeData;

  public static final String SERIALIZED_NAME_RATE_OPTIONS = "rateOptions";
  @SerializedName(SERIALIZED_NAME_RATE_OPTIONS)
  private List<RateData> rateOptions;

  public static final String SERIALIZED_NAME_RATES = "rates";
  @SerializedName(SERIALIZED_NAME_RATES)
  private List<RateData> rates;

  public static final String SERIALIZED_NAME_RATES_ENABLED = "ratesEnabled";
  @SerializedName(SERIALIZED_NAME_RATES_ENABLED)
  private Boolean ratesEnabled;

  public static final String SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS = "recurringMoratoriumOnPrincipalPeriods";
  @SerializedName(SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS)
  private Integer recurringMoratoriumOnPrincipalPeriods;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private EnumOptionData repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE_OPTIONS = "repaymentFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> repaymentFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private EnumOptionData repaymentStartDateType;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE_OPTIONS = "repaymentStartDateTypeOptions";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE_OPTIONS)
  private List<EnumOptionData> repaymentStartDateTypeOptions;

  public static final String SERIALIZED_NAME_RESCHEDULE_STRATEGY_TYPE_OPTIONS = "rescheduleStrategyTypeOptions";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_STRATEGY_TYPE_OPTIONS)
  private List<EnumOptionData> rescheduleStrategyTypeOptions;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private LocalDate startDate;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private String status;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<StringEnumOptionData> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES_OPTIONS = "supportedInterestRefundTypesOptions";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES_OPTIONS)
  private List<StringEnumOptionData> supportedInterestRefundTypesOptions;

  public static final String SERIALIZED_NAME_SYNC_EXPECTED_WITH_DISBURSEMENT_DATE = "syncExpectedWithDisbursementDate";
  @SerializedName(SERIALIZED_NAME_SYNC_EXPECTED_WITH_DISBURSEMENT_DATE)
  private Boolean syncExpectedWithDisbursementDate;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME = "transactionProcessingStrategyName";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME)
  private String transactionProcessingStrategyName;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_OPTIONS = "transactionProcessingStrategyOptions";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_OPTIONS)
  private List<TransactionProcessingStrategyData> transactionProcessingStrategyOptions;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_VALUE_CONDITION_TYPE_OPTIONS = "valueConditionTypeOptions";
  @SerializedName(SERIALIZED_NAME_VALUE_CONDITION_TYPE_OPTIONS)
  private List<EnumOptionData> valueConditionTypeOptions;

  public LoanProductData() {
  }

  public LoanProductData accountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
    return this;
  }

  /**
   * Get accountMovesOutOfNPAOnlyOnArrearsCompletion
   * @return accountMovesOutOfNPAOnlyOnArrearsCompletion
   */
  @javax.annotation.Nullable

  public Boolean getAccountMovesOutOfNPAOnlyOnArrearsCompletion() {
    return accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }


  public void setAccountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }

  public LoanProductData accountingMappingOptions(Map<String, List<GLAccountData>> accountingMappingOptions) {
    
    this.accountingMappingOptions = accountingMappingOptions;
    return this;
  }

  public LoanProductData putAccountingMappingOptionsItem(String key, List<GLAccountData> accountingMappingOptionsItem) {
    if (this.accountingMappingOptions == null) {
      this.accountingMappingOptions = new HashMap<>();
    }
    this.accountingMappingOptions.put(key, accountingMappingOptionsItem);
    return this;
  }

  /**
   * Get accountingMappingOptions
   * @return accountingMappingOptions
   */
  @javax.annotation.Nullable

  public Map<String, List<GLAccountData>> getAccountingMappingOptions() {
    return accountingMappingOptions;
  }


  public void setAccountingMappingOptions(Map<String, List<GLAccountData>> accountingMappingOptions) {
    this.accountingMappingOptions = accountingMappingOptions;
  }

  public LoanProductData accountingMappings(Map<String, Object> accountingMappings) {
    
    this.accountingMappings = accountingMappings;
    return this;
  }

  public LoanProductData putAccountingMappingsItem(String key, Object accountingMappingsItem) {
    if (this.accountingMappings == null) {
      this.accountingMappings = new HashMap<>();
    }
    this.accountingMappings.put(key, accountingMappingsItem);
    return this;
  }

  /**
   * Get accountingMappings
   * @return accountingMappings
   */
  @javax.annotation.Nullable

  public Map<String, Object> getAccountingMappings() {
    return accountingMappings;
  }


  public void setAccountingMappings(Map<String, Object> accountingMappings) {
    this.accountingMappings = accountingMappings;
  }

  public LoanProductData accountingRule(EnumOptionData accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public EnumOptionData getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(EnumOptionData accountingRule) {
    this.accountingRule = accountingRule;
  }

  public LoanProductData accountingRuleOptions(List<EnumOptionData> accountingRuleOptions) {
    
    this.accountingRuleOptions = accountingRuleOptions;
    return this;
  }

  public LoanProductData addAccountingRuleOptionsItem(EnumOptionData accountingRuleOptionsItem) {
    if (this.accountingRuleOptions == null) {
      this.accountingRuleOptions = new ArrayList<>();
    }
    this.accountingRuleOptions.add(accountingRuleOptionsItem);
    return this;
  }

  /**
   * Get accountingRuleOptions
   * @return accountingRuleOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAccountingRuleOptions() {
    return accountingRuleOptions;
  }


  public void setAccountingRuleOptions(List<EnumOptionData> accountingRuleOptions) {
    this.accountingRuleOptions = accountingRuleOptions;
  }

  public LoanProductData advancedPaymentAllocationFutureInstallmentAllocationRules(List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules) {
    
    this.advancedPaymentAllocationFutureInstallmentAllocationRules = advancedPaymentAllocationFutureInstallmentAllocationRules;
    return this;
  }

  public LoanProductData addAdvancedPaymentAllocationFutureInstallmentAllocationRulesItem(EnumOptionData advancedPaymentAllocationFutureInstallmentAllocationRulesItem) {
    if (this.advancedPaymentAllocationFutureInstallmentAllocationRules == null) {
      this.advancedPaymentAllocationFutureInstallmentAllocationRules = new ArrayList<>();
    }
    this.advancedPaymentAllocationFutureInstallmentAllocationRules.add(advancedPaymentAllocationFutureInstallmentAllocationRulesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationFutureInstallmentAllocationRules
   * @return advancedPaymentAllocationFutureInstallmentAllocationRules
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationFutureInstallmentAllocationRules() {
    return advancedPaymentAllocationFutureInstallmentAllocationRules;
  }


  public void setAdvancedPaymentAllocationFutureInstallmentAllocationRules(List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules) {
    this.advancedPaymentAllocationFutureInstallmentAllocationRules = advancedPaymentAllocationFutureInstallmentAllocationRules;
  }

  public LoanProductData advancedPaymentAllocationTransactionTypes(List<EnumOptionData> advancedPaymentAllocationTransactionTypes) {
    
    this.advancedPaymentAllocationTransactionTypes = advancedPaymentAllocationTransactionTypes;
    return this;
  }

  public LoanProductData addAdvancedPaymentAllocationTransactionTypesItem(EnumOptionData advancedPaymentAllocationTransactionTypesItem) {
    if (this.advancedPaymentAllocationTransactionTypes == null) {
      this.advancedPaymentAllocationTransactionTypes = new ArrayList<>();
    }
    this.advancedPaymentAllocationTransactionTypes.add(advancedPaymentAllocationTransactionTypesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationTransactionTypes
   * @return advancedPaymentAllocationTransactionTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationTransactionTypes() {
    return advancedPaymentAllocationTransactionTypes;
  }


  public void setAdvancedPaymentAllocationTransactionTypes(List<EnumOptionData> advancedPaymentAllocationTransactionTypes) {
    this.advancedPaymentAllocationTransactionTypes = advancedPaymentAllocationTransactionTypes;
  }

  public LoanProductData advancedPaymentAllocationTypes(List<EnumOptionData> advancedPaymentAllocationTypes) {
    
    this.advancedPaymentAllocationTypes = advancedPaymentAllocationTypes;
    return this;
  }

  public LoanProductData addAdvancedPaymentAllocationTypesItem(EnumOptionData advancedPaymentAllocationTypesItem) {
    if (this.advancedPaymentAllocationTypes == null) {
      this.advancedPaymentAllocationTypes = new ArrayList<>();
    }
    this.advancedPaymentAllocationTypes.add(advancedPaymentAllocationTypesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationTypes
   * @return advancedPaymentAllocationTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationTypes() {
    return advancedPaymentAllocationTypes;
  }


  public void setAdvancedPaymentAllocationTypes(List<EnumOptionData> advancedPaymentAllocationTypes) {
    this.advancedPaymentAllocationTypes = advancedPaymentAllocationTypes;
  }

  public LoanProductData allowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
    return this;
  }

  /**
   * Get allowApprovedDisbursedAmountsOverApplied
   * @return allowApprovedDisbursedAmountsOverApplied
   */
  @javax.annotation.Nullable

  public Boolean getAllowApprovedDisbursedAmountsOverApplied() {
    return allowApprovedDisbursedAmountsOverApplied;
  }


  public void setAllowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
  }

  public LoanProductData allowAttributeOverrides(LoanProductConfigurableAttributes allowAttributeOverrides) {
    
    this.allowAttributeOverrides = allowAttributeOverrides;
    return this;
  }

  /**
   * Get allowAttributeOverrides
   * @return allowAttributeOverrides
   */
  @javax.annotation.Nullable

  public LoanProductConfigurableAttributes getAllowAttributeOverrides() {
    return allowAttributeOverrides;
  }


  public void setAllowAttributeOverrides(LoanProductConfigurableAttributes allowAttributeOverrides) {
    this.allowAttributeOverrides = allowAttributeOverrides;
  }

  public LoanProductData allowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalculation
   * @return allowPartialPeriodInterestCalculation
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalculation() {
    return allowPartialPeriodInterestCalculation;
  }


  public void setAllowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
  }

  public LoanProductData allowVariableInstallments(Boolean allowVariableInstallments) {
    
    this.allowVariableInstallments = allowVariableInstallments;
    return this;
  }

  /**
   * Get allowVariableInstallments
   * @return allowVariableInstallments
   */
  @javax.annotation.Nullable

  public Boolean getAllowVariableInstallments() {
    return allowVariableInstallments;
  }


  public void setAllowVariableInstallments(Boolean allowVariableInstallments) {
    this.allowVariableInstallments = allowVariableInstallments;
  }

  public LoanProductData amortizationType(EnumOptionData amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public EnumOptionData getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(EnumOptionData amortizationType) {
    this.amortizationType = amortizationType;
  }

  public LoanProductData amortizationTypeOptions(List<EnumOptionData> amortizationTypeOptions) {
    
    this.amortizationTypeOptions = amortizationTypeOptions;
    return this;
  }

  public LoanProductData addAmortizationTypeOptionsItem(EnumOptionData amortizationTypeOptionsItem) {
    if (this.amortizationTypeOptions == null) {
      this.amortizationTypeOptions = new ArrayList<>();
    }
    this.amortizationTypeOptions.add(amortizationTypeOptionsItem);
    return this;
  }

  /**
   * Get amortizationTypeOptions
   * @return amortizationTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAmortizationTypeOptions() {
    return amortizationTypeOptions;
  }


  public void setAmortizationTypeOptions(List<EnumOptionData> amortizationTypeOptions) {
    this.amortizationTypeOptions = amortizationTypeOptions;
  }

  public LoanProductData annualInterestRate(BigDecimal annualInterestRate) {
    
    this.annualInterestRate = annualInterestRate;
    return this;
  }

  /**
   * Get annualInterestRate
   * @return annualInterestRate
   */
  @javax.annotation.Nullable

  public BigDecimal getAnnualInterestRate() {
    return annualInterestRate;
  }


  public void setAnnualInterestRate(BigDecimal annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  public LoanProductData canDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
    return this;
  }

  /**
   * Get canDefineInstallmentAmount
   * @return canDefineInstallmentAmount
   */
  @javax.annotation.Nullable

  public Boolean getCanDefineInstallmentAmount() {
    return canDefineInstallmentAmount;
  }


  public void setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
  }

  public LoanProductData canUseForTopup(Boolean canUseForTopup) {
    
    this.canUseForTopup = canUseForTopup;
    return this;
  }

  /**
   * Get canUseForTopup
   * @return canUseForTopup
   */
  @javax.annotation.Nullable

  public Boolean getCanUseForTopup() {
    return canUseForTopup;
  }


  public void setCanUseForTopup(Boolean canUseForTopup) {
    this.canUseForTopup = canUseForTopup;
  }

  public LoanProductData chargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public LoanProductData chargeOffBehaviourOptions(List<StringEnumOptionData> chargeOffBehaviourOptions) {
    
    this.chargeOffBehaviourOptions = chargeOffBehaviourOptions;
    return this;
  }

  public LoanProductData addChargeOffBehaviourOptionsItem(StringEnumOptionData chargeOffBehaviourOptionsItem) {
    if (this.chargeOffBehaviourOptions == null) {
      this.chargeOffBehaviourOptions = new ArrayList<>();
    }
    this.chargeOffBehaviourOptions.add(chargeOffBehaviourOptionsItem);
    return this;
  }

  /**
   * Get chargeOffBehaviourOptions
   * @return chargeOffBehaviourOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getChargeOffBehaviourOptions() {
    return chargeOffBehaviourOptions;
  }


  public void setChargeOffBehaviourOptions(List<StringEnumOptionData> chargeOffBehaviourOptions) {
    this.chargeOffBehaviourOptions = chargeOffBehaviourOptions;
  }

  public LoanProductData chargeOffReasonOptions(List<CodeValueData> chargeOffReasonOptions) {
    
    this.chargeOffReasonOptions = chargeOffReasonOptions;
    return this;
  }

  public LoanProductData addChargeOffReasonOptionsItem(CodeValueData chargeOffReasonOptionsItem) {
    if (this.chargeOffReasonOptions == null) {
      this.chargeOffReasonOptions = new ArrayList<>();
    }
    this.chargeOffReasonOptions.add(chargeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get chargeOffReasonOptions
   * @return chargeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getChargeOffReasonOptions() {
    return chargeOffReasonOptions;
  }


  public void setChargeOffReasonOptions(List<CodeValueData> chargeOffReasonOptions) {
    this.chargeOffReasonOptions = chargeOffReasonOptions;
  }

  public LoanProductData chargeOffReasonToExpenseAccountMappings(List<ChargeOffReasonToGLAccountMapper> chargeOffReasonToExpenseAccountMappings) {
    
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
    return this;
  }

  public LoanProductData addChargeOffReasonToExpenseAccountMappingsItem(ChargeOffReasonToGLAccountMapper chargeOffReasonToExpenseAccountMappingsItem) {
    if (this.chargeOffReasonToExpenseAccountMappings == null) {
      this.chargeOffReasonToExpenseAccountMappings = new ArrayList<>();
    }
    this.chargeOffReasonToExpenseAccountMappings.add(chargeOffReasonToExpenseAccountMappingsItem);
    return this;
  }

  /**
   * Get chargeOffReasonToExpenseAccountMappings
   * @return chargeOffReasonToExpenseAccountMappings
   */
  @javax.annotation.Nullable

  public List<ChargeOffReasonToGLAccountMapper> getChargeOffReasonToExpenseAccountMappings() {
    return chargeOffReasonToExpenseAccountMappings;
  }


  public void setChargeOffReasonToExpenseAccountMappings(List<ChargeOffReasonToGLAccountMapper> chargeOffReasonToExpenseAccountMappings) {
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
  }

  public LoanProductData chargeOptions(List<ChargeData> chargeOptions) {
    
    this.chargeOptions = chargeOptions;
    return this;
  }

  public LoanProductData addChargeOptionsItem(ChargeData chargeOptionsItem) {
    if (this.chargeOptions == null) {
      this.chargeOptions = new ArrayList<>();
    }
    this.chargeOptions.add(chargeOptionsItem);
    return this;
  }

  /**
   * Get chargeOptions
   * @return chargeOptions
   */
  @javax.annotation.Nullable

  public List<ChargeData> getChargeOptions() {
    return chargeOptions;
  }


  public void setChargeOptions(List<ChargeData> chargeOptions) {
    this.chargeOptions = chargeOptions;
  }

  public LoanProductData charges(List<ChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public LoanProductData addChargesItem(ChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<ChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<ChargeData> charges) {
    this.charges = charges;
  }

  public LoanProductData closeDate(LocalDate closeDate) {
    
    this.closeDate = closeDate;
    return this;
  }

  /**
   * Get closeDate
   * @return closeDate
   */
  @javax.annotation.Nullable

  public LocalDate getCloseDate() {
    return closeDate;
  }


  public void setCloseDate(LocalDate closeDate) {
    this.closeDate = closeDate;
  }

  public LoanProductData compoundingToBePostedAsTransaction(Boolean compoundingToBePostedAsTransaction) {
    
    this.compoundingToBePostedAsTransaction = compoundingToBePostedAsTransaction;
    return this;
  }

  /**
   * Get compoundingToBePostedAsTransaction
   * @return compoundingToBePostedAsTransaction
   */
  @javax.annotation.Nullable

  public Boolean getCompoundingToBePostedAsTransaction() {
    return compoundingToBePostedAsTransaction;
  }


  public void setCompoundingToBePostedAsTransaction(Boolean compoundingToBePostedAsTransaction) {
    this.compoundingToBePostedAsTransaction = compoundingToBePostedAsTransaction;
  }

  public LoanProductData creditAllocation(List<CreditAllocationData> creditAllocation) {
    
    this.creditAllocation = creditAllocation;
    return this;
  }

  public LoanProductData addCreditAllocationItem(CreditAllocationData creditAllocationItem) {
    if (this.creditAllocation == null) {
      this.creditAllocation = new ArrayList<>();
    }
    this.creditAllocation.add(creditAllocationItem);
    return this;
  }

  /**
   * Get creditAllocation
   * @return creditAllocation
   */
  @javax.annotation.Nullable

  public List<CreditAllocationData> getCreditAllocation() {
    return creditAllocation;
  }


  public void setCreditAllocation(List<CreditAllocationData> creditAllocation) {
    this.creditAllocation = creditAllocation;
  }

  public LoanProductData creditAllocationAllocationTypes(List<EnumOptionData> creditAllocationAllocationTypes) {
    
    this.creditAllocationAllocationTypes = creditAllocationAllocationTypes;
    return this;
  }

  public LoanProductData addCreditAllocationAllocationTypesItem(EnumOptionData creditAllocationAllocationTypesItem) {
    if (this.creditAllocationAllocationTypes == null) {
      this.creditAllocationAllocationTypes = new ArrayList<>();
    }
    this.creditAllocationAllocationTypes.add(creditAllocationAllocationTypesItem);
    return this;
  }

  /**
   * Get creditAllocationAllocationTypes
   * @return creditAllocationAllocationTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getCreditAllocationAllocationTypes() {
    return creditAllocationAllocationTypes;
  }


  public void setCreditAllocationAllocationTypes(List<EnumOptionData> creditAllocationAllocationTypes) {
    this.creditAllocationAllocationTypes = creditAllocationAllocationTypes;
  }

  public LoanProductData creditAllocationTransactionTypes(List<EnumOptionData> creditAllocationTransactionTypes) {
    
    this.creditAllocationTransactionTypes = creditAllocationTransactionTypes;
    return this;
  }

  public LoanProductData addCreditAllocationTransactionTypesItem(EnumOptionData creditAllocationTransactionTypesItem) {
    if (this.creditAllocationTransactionTypes == null) {
      this.creditAllocationTransactionTypes = new ArrayList<>();
    }
    this.creditAllocationTransactionTypes.add(creditAllocationTransactionTypesItem);
    return this;
  }

  /**
   * Get creditAllocationTransactionTypes
   * @return creditAllocationTransactionTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getCreditAllocationTransactionTypes() {
    return creditAllocationTransactionTypes;
  }


  public void setCreditAllocationTransactionTypes(List<EnumOptionData> creditAllocationTransactionTypes) {
    this.creditAllocationTransactionTypes = creditAllocationTransactionTypes;
  }

  public LoanProductData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public LoanProductData currencyOptions(List<CurrencyData> currencyOptions) {
    
    this.currencyOptions = currencyOptions;
    return this;
  }

  public LoanProductData addCurrencyOptionsItem(CurrencyData currencyOptionsItem) {
    if (this.currencyOptions == null) {
      this.currencyOptions = new ArrayList<>();
    }
    this.currencyOptions.add(currencyOptionsItem);
    return this;
  }

  /**
   * Get currencyOptions
   * @return currencyOptions
   */
  @javax.annotation.Nullable

  public List<CurrencyData> getCurrencyOptions() {
    return currencyOptions;
  }


  public void setCurrencyOptions(List<CurrencyData> currencyOptions) {
    this.currencyOptions = currencyOptions;
  }

  public LoanProductData daysInMonthType(EnumOptionData daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public EnumOptionData getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(EnumOptionData daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public LoanProductData daysInMonthTypeOptions(List<EnumOptionData> daysInMonthTypeOptions) {
    
    this.daysInMonthTypeOptions = daysInMonthTypeOptions;
    return this;
  }

  public LoanProductData addDaysInMonthTypeOptionsItem(EnumOptionData daysInMonthTypeOptionsItem) {
    if (this.daysInMonthTypeOptions == null) {
      this.daysInMonthTypeOptions = new ArrayList<>();
    }
    this.daysInMonthTypeOptions.add(daysInMonthTypeOptionsItem);
    return this;
  }

  /**
   * Get daysInMonthTypeOptions
   * @return daysInMonthTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getDaysInMonthTypeOptions() {
    return daysInMonthTypeOptions;
  }


  public void setDaysInMonthTypeOptions(List<EnumOptionData> daysInMonthTypeOptions) {
    this.daysInMonthTypeOptions = daysInMonthTypeOptions;
  }

  public LoanProductData daysInYearType(EnumOptionData daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public EnumOptionData getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(EnumOptionData daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public LoanProductData daysInYearTypeOptions(List<EnumOptionData> daysInYearTypeOptions) {
    
    this.daysInYearTypeOptions = daysInYearTypeOptions;
    return this;
  }

  public LoanProductData addDaysInYearTypeOptionsItem(EnumOptionData daysInYearTypeOptionsItem) {
    if (this.daysInYearTypeOptions == null) {
      this.daysInYearTypeOptions = new ArrayList<>();
    }
    this.daysInYearTypeOptions.add(daysInYearTypeOptionsItem);
    return this;
  }

  /**
   * Get daysInYearTypeOptions
   * @return daysInYearTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getDaysInYearTypeOptions() {
    return daysInYearTypeOptions;
  }


  public void setDaysInYearTypeOptions(List<EnumOptionData> daysInYearTypeOptions) {
    this.daysInYearTypeOptions = daysInYearTypeOptions;
  }

  public LoanProductData defaultDifferentialLendingRate(BigDecimal defaultDifferentialLendingRate) {
    
    this.defaultDifferentialLendingRate = defaultDifferentialLendingRate;
    return this;
  }

  /**
   * Get defaultDifferentialLendingRate
   * @return defaultDifferentialLendingRate
   */
  @javax.annotation.Nullable

  public BigDecimal getDefaultDifferentialLendingRate() {
    return defaultDifferentialLendingRate;
  }


  public void setDefaultDifferentialLendingRate(BigDecimal defaultDifferentialLendingRate) {
    this.defaultDifferentialLendingRate = defaultDifferentialLendingRate;
  }

  public LoanProductData delinquencyBucket(DelinquencyBucketData delinquencyBucket) {
    
    this.delinquencyBucket = delinquencyBucket;
    return this;
  }

  /**
   * Get delinquencyBucket
   * @return delinquencyBucket
   */
  @javax.annotation.Nullable

  public DelinquencyBucketData getDelinquencyBucket() {
    return delinquencyBucket;
  }


  public void setDelinquencyBucket(DelinquencyBucketData delinquencyBucket) {
    this.delinquencyBucket = delinquencyBucket;
  }

  public LoanProductData delinquencyBucketOptions(List<DelinquencyBucketData> delinquencyBucketOptions) {
    
    this.delinquencyBucketOptions = delinquencyBucketOptions;
    return this;
  }

  public LoanProductData addDelinquencyBucketOptionsItem(DelinquencyBucketData delinquencyBucketOptionsItem) {
    if (this.delinquencyBucketOptions == null) {
      this.delinquencyBucketOptions = new ArrayList<>();
    }
    this.delinquencyBucketOptions.add(delinquencyBucketOptionsItem);
    return this;
  }

  /**
   * Get delinquencyBucketOptions
   * @return delinquencyBucketOptions
   */
  @javax.annotation.Nullable

  public List<DelinquencyBucketData> getDelinquencyBucketOptions() {
    return delinquencyBucketOptions;
  }


  public void setDelinquencyBucketOptions(List<DelinquencyBucketData> delinquencyBucketOptions) {
    this.delinquencyBucketOptions = delinquencyBucketOptions;
  }

  public LoanProductData description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public LoanProductData disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public LoanProductData disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public LoanProductData dueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get dueDaysForRepaymentEvent
   * @return dueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getDueDaysForRepaymentEvent() {
    return dueDaysForRepaymentEvent;
  }


  public void setDueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
  }

  public LoanProductData enableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
    return this;
  }

  /**
   * Get enableAccrualActivityPosting
   * @return enableAccrualActivityPosting
   */
  @javax.annotation.Nullable

  public Boolean getEnableAccrualActivityPosting() {
    return enableAccrualActivityPosting;
  }


  public void setEnableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
  }

  public LoanProductData enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public LoanProductData enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public LoanProductData enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public LoanProductData equalAmortization(Boolean equalAmortization) {
    
    this.equalAmortization = equalAmortization;
    return this;
  }

  /**
   * Get equalAmortization
   * @return equalAmortization
   */
  @javax.annotation.Nullable

  public Boolean getEqualAmortization() {
    return equalAmortization;
  }


  public void setEqualAmortization(Boolean equalAmortization) {
    this.equalAmortization = equalAmortization;
  }

  public LoanProductData externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public LoanProductData feeToIncomeAccountMappings(List<ChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
    return this;
  }

  public LoanProductData addFeeToIncomeAccountMappingsItem(ChargeToGLAccountMapper feeToIncomeAccountMappingsItem) {
    if (this.feeToIncomeAccountMappings == null) {
      this.feeToIncomeAccountMappings = new ArrayList<>();
    }
    this.feeToIncomeAccountMappings.add(feeToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get feeToIncomeAccountMappings
   * @return feeToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<ChargeToGLAccountMapper> getFeeToIncomeAccountMappings() {
    return feeToIncomeAccountMappings;
  }


  public void setFeeToIncomeAccountMappings(List<ChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
  }

  public LoanProductData fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public LoanProductData fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public LoanProductData floatingInterestRateCalculationAllowed(Boolean floatingInterestRateCalculationAllowed) {
    
    this.floatingInterestRateCalculationAllowed = floatingInterestRateCalculationAllowed;
    return this;
  }

  /**
   * Get floatingInterestRateCalculationAllowed
   * @return floatingInterestRateCalculationAllowed
   */
  @javax.annotation.Nullable

  public Boolean getFloatingInterestRateCalculationAllowed() {
    return floatingInterestRateCalculationAllowed;
  }


  public void setFloatingInterestRateCalculationAllowed(Boolean floatingInterestRateCalculationAllowed) {
    this.floatingInterestRateCalculationAllowed = floatingInterestRateCalculationAllowed;
  }

  public LoanProductData floatingRateId(Integer floatingRateId) {
    
    this.floatingRateId = floatingRateId;
    return this;
  }

  /**
   * Get floatingRateId
   * @return floatingRateId
   */
  @javax.annotation.Nullable

  public Integer getFloatingRateId() {
    return floatingRateId;
  }


  public void setFloatingRateId(Integer floatingRateId) {
    this.floatingRateId = floatingRateId;
  }

  public LoanProductData floatingRateName(String floatingRateName) {
    
    this.floatingRateName = floatingRateName;
    return this;
  }

  /**
   * Get floatingRateName
   * @return floatingRateName
   */
  @javax.annotation.Nullable

  public String getFloatingRateName() {
    return floatingRateName;
  }


  public void setFloatingRateName(String floatingRateName) {
    this.floatingRateName = floatingRateName;
  }

  public LoanProductData floatingRateOptions(List<FloatingRateData> floatingRateOptions) {
    
    this.floatingRateOptions = floatingRateOptions;
    return this;
  }

  public LoanProductData addFloatingRateOptionsItem(FloatingRateData floatingRateOptionsItem) {
    if (this.floatingRateOptions == null) {
      this.floatingRateOptions = new ArrayList<>();
    }
    this.floatingRateOptions.add(floatingRateOptionsItem);
    return this;
  }

  /**
   * Get floatingRateOptions
   * @return floatingRateOptions
   */
  @javax.annotation.Nullable

  public List<FloatingRateData> getFloatingRateOptions() {
    return floatingRateOptions;
  }


  public void setFloatingRateOptions(List<FloatingRateData> floatingRateOptions) {
    this.floatingRateOptions = floatingRateOptions;
  }

  public LoanProductData fundId(Long fundId) {
    
    this.fundId = fundId;
    return this;
  }

  /**
   * Get fundId
   * @return fundId
   */
  @javax.annotation.Nullable

  public Long getFundId() {
    return fundId;
  }


  public void setFundId(Long fundId) {
    this.fundId = fundId;
  }

  public LoanProductData fundName(String fundName) {
    
    this.fundName = fundName;
    return this;
  }

  /**
   * Get fundName
   * @return fundName
   */
  @javax.annotation.Nullable

  public String getFundName() {
    return fundName;
  }


  public void setFundName(String fundName) {
    this.fundName = fundName;
  }

  public LoanProductData fundOptions(List<FundData> fundOptions) {
    
    this.fundOptions = fundOptions;
    return this;
  }

  public LoanProductData addFundOptionsItem(FundData fundOptionsItem) {
    if (this.fundOptions == null) {
      this.fundOptions = new ArrayList<>();
    }
    this.fundOptions.add(fundOptionsItem);
    return this;
  }

  /**
   * Get fundOptions
   * @return fundOptions
   */
  @javax.annotation.Nullable

  public List<FundData> getFundOptions() {
    return fundOptions;
  }


  public void setFundOptions(List<FundData> fundOptions) {
    this.fundOptions = fundOptions;
  }

  public LoanProductData graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public LoanProductData graceOnInterestCharged(Integer graceOnInterestCharged) {
    
    this.graceOnInterestCharged = graceOnInterestCharged;
    return this;
  }

  /**
   * Get graceOnInterestCharged
   * @return graceOnInterestCharged
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestCharged() {
    return graceOnInterestCharged;
  }


  public void setGraceOnInterestCharged(Integer graceOnInterestCharged) {
    this.graceOnInterestCharged = graceOnInterestCharged;
  }

  public LoanProductData graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public LoanProductData graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public LoanProductData holdGuaranteeFunds(Boolean holdGuaranteeFunds) {
    
    this.holdGuaranteeFunds = holdGuaranteeFunds;
    return this;
  }

  /**
   * Get holdGuaranteeFunds
   * @return holdGuaranteeFunds
   */
  @javax.annotation.Nullable

  public Boolean getHoldGuaranteeFunds() {
    return holdGuaranteeFunds;
  }


  public void setHoldGuaranteeFunds(Boolean holdGuaranteeFunds) {
    this.holdGuaranteeFunds = holdGuaranteeFunds;
  }

  public LoanProductData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProductData inArrearsTolerance(BigDecimal inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public BigDecimal getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(BigDecimal inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public LoanProductData includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public LoanProductData installmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
    return this;
  }

  /**
   * Get installmentAmountInMultiplesOf
   * @return installmentAmountInMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInstallmentAmountInMultiplesOf() {
    return installmentAmountInMultiplesOf;
  }


  public void setInstallmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
  }

  public LoanProductData interestCalculationPeriodType(EnumOptionData interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(EnumOptionData interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public LoanProductData interestCalculationPeriodTypeOptions(List<EnumOptionData> interestCalculationPeriodTypeOptions) {
    
    this.interestCalculationPeriodTypeOptions = interestCalculationPeriodTypeOptions;
    return this;
  }

  public LoanProductData addInterestCalculationPeriodTypeOptionsItem(EnumOptionData interestCalculationPeriodTypeOptionsItem) {
    if (this.interestCalculationPeriodTypeOptions == null) {
      this.interestCalculationPeriodTypeOptions = new ArrayList<>();
    }
    this.interestCalculationPeriodTypeOptions.add(interestCalculationPeriodTypeOptionsItem);
    return this;
  }

  /**
   * Get interestCalculationPeriodTypeOptions
   * @return interestCalculationPeriodTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestCalculationPeriodTypeOptions() {
    return interestCalculationPeriodTypeOptions;
  }


  public void setInterestCalculationPeriodTypeOptions(List<EnumOptionData> interestCalculationPeriodTypeOptions) {
    this.interestCalculationPeriodTypeOptions = interestCalculationPeriodTypeOptions;
  }

  public LoanProductData interestRateDifferential(BigDecimal interestRateDifferential) {
    
    this.interestRateDifferential = interestRateDifferential;
    return this;
  }

  /**
   * Get interestRateDifferential
   * @return interestRateDifferential
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestRateDifferential() {
    return interestRateDifferential;
  }


  public void setInterestRateDifferential(BigDecimal interestRateDifferential) {
    this.interestRateDifferential = interestRateDifferential;
  }

  public LoanProductData interestRateFrequencyType(EnumOptionData interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(EnumOptionData interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public LoanProductData interestRateFrequencyTypeOptions(List<EnumOptionData> interestRateFrequencyTypeOptions) {
    
    this.interestRateFrequencyTypeOptions = interestRateFrequencyTypeOptions;
    return this;
  }

  public LoanProductData addInterestRateFrequencyTypeOptionsItem(EnumOptionData interestRateFrequencyTypeOptionsItem) {
    if (this.interestRateFrequencyTypeOptions == null) {
      this.interestRateFrequencyTypeOptions = new ArrayList<>();
    }
    this.interestRateFrequencyTypeOptions.add(interestRateFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRateFrequencyTypeOptions
   * @return interestRateFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestRateFrequencyTypeOptions() {
    return interestRateFrequencyTypeOptions;
  }


  public void setInterestRateFrequencyTypeOptions(List<EnumOptionData> interestRateFrequencyTypeOptions) {
    this.interestRateFrequencyTypeOptions = interestRateFrequencyTypeOptions;
  }

  public LoanProductData interestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public LoanProductData interestRateVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public LoanProductData addInterestRateVariationsForBorrowerCycleItem(LoanProductBorrowerCycleVariationData interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<LoanProductBorrowerCycleVariationData> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public LoanProductData interestRecalculationCompoundingTypeOptions(List<EnumOptionData> interestRecalculationCompoundingTypeOptions) {
    
    this.interestRecalculationCompoundingTypeOptions = interestRecalculationCompoundingTypeOptions;
    return this;
  }

  public LoanProductData addInterestRecalculationCompoundingTypeOptionsItem(EnumOptionData interestRecalculationCompoundingTypeOptionsItem) {
    if (this.interestRecalculationCompoundingTypeOptions == null) {
      this.interestRecalculationCompoundingTypeOptions = new ArrayList<>();
    }
    this.interestRecalculationCompoundingTypeOptions.add(interestRecalculationCompoundingTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationCompoundingTypeOptions
   * @return interestRecalculationCompoundingTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestRecalculationCompoundingTypeOptions() {
    return interestRecalculationCompoundingTypeOptions;
  }


  public void setInterestRecalculationCompoundingTypeOptions(List<EnumOptionData> interestRecalculationCompoundingTypeOptions) {
    this.interestRecalculationCompoundingTypeOptions = interestRecalculationCompoundingTypeOptions;
  }

  public LoanProductData interestRecalculationData(LoanProductInterestRecalculationData interestRecalculationData) {
    
    this.interestRecalculationData = interestRecalculationData;
    return this;
  }

  /**
   * Get interestRecalculationData
   * @return interestRecalculationData
   */
  @javax.annotation.Nullable

  public LoanProductInterestRecalculationData getInterestRecalculationData() {
    return interestRecalculationData;
  }


  public void setInterestRecalculationData(LoanProductInterestRecalculationData interestRecalculationData) {
    this.interestRecalculationData = interestRecalculationData;
  }

  public LoanProductData interestRecalculationDayOfWeekTypeOptions(List<EnumOptionData> interestRecalculationDayOfWeekTypeOptions) {
    
    this.interestRecalculationDayOfWeekTypeOptions = interestRecalculationDayOfWeekTypeOptions;
    return this;
  }

  public LoanProductData addInterestRecalculationDayOfWeekTypeOptionsItem(EnumOptionData interestRecalculationDayOfWeekTypeOptionsItem) {
    if (this.interestRecalculationDayOfWeekTypeOptions == null) {
      this.interestRecalculationDayOfWeekTypeOptions = new ArrayList<>();
    }
    this.interestRecalculationDayOfWeekTypeOptions.add(interestRecalculationDayOfWeekTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationDayOfWeekTypeOptions
   * @return interestRecalculationDayOfWeekTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestRecalculationDayOfWeekTypeOptions() {
    return interestRecalculationDayOfWeekTypeOptions;
  }


  public void setInterestRecalculationDayOfWeekTypeOptions(List<EnumOptionData> interestRecalculationDayOfWeekTypeOptions) {
    this.interestRecalculationDayOfWeekTypeOptions = interestRecalculationDayOfWeekTypeOptions;
  }

  public LoanProductData interestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    
    this.interestRecalculationEnabled = interestRecalculationEnabled;
    return this;
  }

  /**
   * Get interestRecalculationEnabled
   * @return interestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecalculationEnabled() {
    return interestRecalculationEnabled;
  }


  public void setInterestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    this.interestRecalculationEnabled = interestRecalculationEnabled;
  }

  public LoanProductData interestRecalculationFrequencyTypeOptions(List<EnumOptionData> interestRecalculationFrequencyTypeOptions) {
    
    this.interestRecalculationFrequencyTypeOptions = interestRecalculationFrequencyTypeOptions;
    return this;
  }

  public LoanProductData addInterestRecalculationFrequencyTypeOptionsItem(EnumOptionData interestRecalculationFrequencyTypeOptionsItem) {
    if (this.interestRecalculationFrequencyTypeOptions == null) {
      this.interestRecalculationFrequencyTypeOptions = new ArrayList<>();
    }
    this.interestRecalculationFrequencyTypeOptions.add(interestRecalculationFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationFrequencyTypeOptions
   * @return interestRecalculationFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestRecalculationFrequencyTypeOptions() {
    return interestRecalculationFrequencyTypeOptions;
  }


  public void setInterestRecalculationFrequencyTypeOptions(List<EnumOptionData> interestRecalculationFrequencyTypeOptions) {
    this.interestRecalculationFrequencyTypeOptions = interestRecalculationFrequencyTypeOptions;
  }

  public LoanProductData interestRecalculationNthDayTypeOptions(List<EnumOptionData> interestRecalculationNthDayTypeOptions) {
    
    this.interestRecalculationNthDayTypeOptions = interestRecalculationNthDayTypeOptions;
    return this;
  }

  public LoanProductData addInterestRecalculationNthDayTypeOptionsItem(EnumOptionData interestRecalculationNthDayTypeOptionsItem) {
    if (this.interestRecalculationNthDayTypeOptions == null) {
      this.interestRecalculationNthDayTypeOptions = new ArrayList<>();
    }
    this.interestRecalculationNthDayTypeOptions.add(interestRecalculationNthDayTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationNthDayTypeOptions
   * @return interestRecalculationNthDayTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestRecalculationNthDayTypeOptions() {
    return interestRecalculationNthDayTypeOptions;
  }


  public void setInterestRecalculationNthDayTypeOptions(List<EnumOptionData> interestRecalculationNthDayTypeOptions) {
    this.interestRecalculationNthDayTypeOptions = interestRecalculationNthDayTypeOptions;
  }

  public LoanProductData interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public LoanProductData interestType(EnumOptionData interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public EnumOptionData getInterestType() {
    return interestType;
  }


  public void setInterestType(EnumOptionData interestType) {
    this.interestType = interestType;
  }

  public LoanProductData interestTypeOptions(List<EnumOptionData> interestTypeOptions) {
    
    this.interestTypeOptions = interestTypeOptions;
    return this;
  }

  public LoanProductData addInterestTypeOptionsItem(EnumOptionData interestTypeOptionsItem) {
    if (this.interestTypeOptions == null) {
      this.interestTypeOptions = new ArrayList<>();
    }
    this.interestTypeOptions.add(interestTypeOptionsItem);
    return this;
  }

  /**
   * Get interestTypeOptions
   * @return interestTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getInterestTypeOptions() {
    return interestTypeOptions;
  }


  public void setInterestTypeOptions(List<EnumOptionData> interestTypeOptions) {
    this.interestTypeOptions = interestTypeOptions;
  }

  public LoanProductData isAllowPartialPeriodInterestCalculation(Boolean isAllowPartialPeriodInterestCalculation) {
    
    this.isAllowPartialPeriodInterestCalculation = isAllowPartialPeriodInterestCalculation;
    return this;
  }

  /**
   * Get isAllowPartialPeriodInterestCalculation
   * @return isAllowPartialPeriodInterestCalculation
   */
  @javax.annotation.Nullable

  public Boolean getIsAllowPartialPeriodInterestCalculation() {
    return isAllowPartialPeriodInterestCalculation;
  }


  public void setIsAllowPartialPeriodInterestCalculation(Boolean isAllowPartialPeriodInterestCalculation) {
    this.isAllowPartialPeriodInterestCalculation = isAllowPartialPeriodInterestCalculation;
  }

  public LoanProductData isEqualAmortization(Boolean isEqualAmortization) {
    
    this.isEqualAmortization = isEqualAmortization;
    return this;
  }

  /**
   * Get isEqualAmortization
   * @return isEqualAmortization
   */
  @javax.annotation.Nullable

  public Boolean getIsEqualAmortization() {
    return isEqualAmortization;
  }


  public void setIsEqualAmortization(Boolean isEqualAmortization) {
    this.isEqualAmortization = isEqualAmortization;
  }

  public LoanProductData isFloatingInterestRateCalculationAllowed(Boolean isFloatingInterestRateCalculationAllowed) {
    
    this.isFloatingInterestRateCalculationAllowed = isFloatingInterestRateCalculationAllowed;
    return this;
  }

  /**
   * Get isFloatingInterestRateCalculationAllowed
   * @return isFloatingInterestRateCalculationAllowed
   */
  @javax.annotation.Nullable

  public Boolean getIsFloatingInterestRateCalculationAllowed() {
    return isFloatingInterestRateCalculationAllowed;
  }


  public void setIsFloatingInterestRateCalculationAllowed(Boolean isFloatingInterestRateCalculationAllowed) {
    this.isFloatingInterestRateCalculationAllowed = isFloatingInterestRateCalculationAllowed;
  }

  public LoanProductData isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public LoanProductData isLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
    return this;
  }

  /**
   * Get isLinkedToFloatingInterestRates
   * @return isLinkedToFloatingInterestRates
   */
  @javax.annotation.Nullable

  public Boolean getIsLinkedToFloatingInterestRates() {
    return isLinkedToFloatingInterestRates;
  }


  public void setIsLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
  }

  public LoanProductData isRatesEnabled(Boolean isRatesEnabled) {
    
    this.isRatesEnabled = isRatesEnabled;
    return this;
  }

  /**
   * Get isRatesEnabled
   * @return isRatesEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsRatesEnabled() {
    return isRatesEnabled;
  }


  public void setIsRatesEnabled(Boolean isRatesEnabled) {
    this.isRatesEnabled = isRatesEnabled;
  }

  public LoanProductData linkedToFloatingInterestRates(Boolean linkedToFloatingInterestRates) {
    
    this.linkedToFloatingInterestRates = linkedToFloatingInterestRates;
    return this;
  }

  /**
   * Get linkedToFloatingInterestRates
   * @return linkedToFloatingInterestRates
   */
  @javax.annotation.Nullable

  public Boolean getLinkedToFloatingInterestRates() {
    return linkedToFloatingInterestRates;
  }


  public void setLinkedToFloatingInterestRates(Boolean linkedToFloatingInterestRates) {
    this.linkedToFloatingInterestRates = linkedToFloatingInterestRates;
  }

  public LoanProductData loanProductConfigurableAttributes(LoanProductConfigurableAttributes loanProductConfigurableAttributes) {
    
    this.loanProductConfigurableAttributes = loanProductConfigurableAttributes;
    return this;
  }

  /**
   * Get loanProductConfigurableAttributes
   * @return loanProductConfigurableAttributes
   */
  @javax.annotation.Nullable

  public LoanProductConfigurableAttributes getLoanProductConfigurableAttributes() {
    return loanProductConfigurableAttributes;
  }


  public void setLoanProductConfigurableAttributes(LoanProductConfigurableAttributes loanProductConfigurableAttributes) {
    this.loanProductConfigurableAttributes = loanProductConfigurableAttributes;
  }

  public LoanProductData loanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public LoanProductData loanScheduleProcessingTypeOptions(List<EnumOptionData> loanScheduleProcessingTypeOptions) {
    
    this.loanScheduleProcessingTypeOptions = loanScheduleProcessingTypeOptions;
    return this;
  }

  public LoanProductData addLoanScheduleProcessingTypeOptionsItem(EnumOptionData loanScheduleProcessingTypeOptionsItem) {
    if (this.loanScheduleProcessingTypeOptions == null) {
      this.loanScheduleProcessingTypeOptions = new ArrayList<>();
    }
    this.loanScheduleProcessingTypeOptions.add(loanScheduleProcessingTypeOptionsItem);
    return this;
  }

  /**
   * Get loanScheduleProcessingTypeOptions
   * @return loanScheduleProcessingTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanScheduleProcessingTypeOptions() {
    return loanScheduleProcessingTypeOptions;
  }


  public void setLoanScheduleProcessingTypeOptions(List<EnumOptionData> loanScheduleProcessingTypeOptions) {
    this.loanScheduleProcessingTypeOptions = loanScheduleProcessingTypeOptions;
  }

  public LoanProductData loanScheduleType(EnumOptionData loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(EnumOptionData loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public LoanProductData loanScheduleTypeOptions(List<EnumOptionData> loanScheduleTypeOptions) {
    
    this.loanScheduleTypeOptions = loanScheduleTypeOptions;
    return this;
  }

  public LoanProductData addLoanScheduleTypeOptionsItem(EnumOptionData loanScheduleTypeOptionsItem) {
    if (this.loanScheduleTypeOptions == null) {
      this.loanScheduleTypeOptions = new ArrayList<>();
    }
    this.loanScheduleTypeOptions.add(loanScheduleTypeOptionsItem);
    return this;
  }

  /**
   * Get loanScheduleTypeOptions
   * @return loanScheduleTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanScheduleTypeOptions() {
    return loanScheduleTypeOptions;
  }


  public void setLoanScheduleTypeOptions(List<EnumOptionData> loanScheduleTypeOptions) {
    this.loanScheduleTypeOptions = loanScheduleTypeOptions;
  }

  public LoanProductData maxDifferentialLendingRate(BigDecimal maxDifferentialLendingRate) {
    
    this.maxDifferentialLendingRate = maxDifferentialLendingRate;
    return this;
  }

  /**
   * Get maxDifferentialLendingRate
   * @return maxDifferentialLendingRate
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxDifferentialLendingRate() {
    return maxDifferentialLendingRate;
  }


  public void setMaxDifferentialLendingRate(BigDecimal maxDifferentialLendingRate) {
    this.maxDifferentialLendingRate = maxDifferentialLendingRate;
  }

  public LoanProductData maxInterestRatePerPeriod(BigDecimal maxInterestRatePerPeriod) {
    
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
    return this;
  }

  /**
   * Get maxInterestRatePerPeriod
   * @return maxInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxInterestRatePerPeriod() {
    return maxInterestRatePerPeriod;
  }


  public void setMaxInterestRatePerPeriod(BigDecimal maxInterestRatePerPeriod) {
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
  }

  public LoanProductData maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public LoanProductData maxPrincipal(BigDecimal maxPrincipal) {
    
    this.maxPrincipal = maxPrincipal;
    return this;
  }

  /**
   * Get maxPrincipal
   * @return maxPrincipal
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxPrincipal() {
    return maxPrincipal;
  }


  public void setMaxPrincipal(BigDecimal maxPrincipal) {
    this.maxPrincipal = maxPrincipal;
  }

  public LoanProductData maxTrancheCount(Integer maxTrancheCount) {
    
    this.maxTrancheCount = maxTrancheCount;
    return this;
  }

  /**
   * Get maxTrancheCount
   * @return maxTrancheCount
   */
  @javax.annotation.Nullable

  public Integer getMaxTrancheCount() {
    return maxTrancheCount;
  }


  public void setMaxTrancheCount(Integer maxTrancheCount) {
    this.maxTrancheCount = maxTrancheCount;
  }

  public LoanProductData maximumGap(Integer maximumGap) {
    
    this.maximumGap = maximumGap;
    return this;
  }

  /**
   * Get maximumGap
   * @return maximumGap
   */
  @javax.annotation.Nullable

  public Integer getMaximumGap() {
    return maximumGap;
  }


  public void setMaximumGap(Integer maximumGap) {
    this.maximumGap = maximumGap;
  }

  public LoanProductData minDifferentialLendingRate(BigDecimal minDifferentialLendingRate) {
    
    this.minDifferentialLendingRate = minDifferentialLendingRate;
    return this;
  }

  /**
   * Get minDifferentialLendingRate
   * @return minDifferentialLendingRate
   */
  @javax.annotation.Nullable

  public BigDecimal getMinDifferentialLendingRate() {
    return minDifferentialLendingRate;
  }


  public void setMinDifferentialLendingRate(BigDecimal minDifferentialLendingRate) {
    this.minDifferentialLendingRate = minDifferentialLendingRate;
  }

  public LoanProductData minInterestRatePerPeriod(BigDecimal minInterestRatePerPeriod) {
    
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
    return this;
  }

  /**
   * Get minInterestRatePerPeriod
   * @return minInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getMinInterestRatePerPeriod() {
    return minInterestRatePerPeriod;
  }


  public void setMinInterestRatePerPeriod(BigDecimal minInterestRatePerPeriod) {
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
  }

  public LoanProductData minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public LoanProductData minPrincipal(BigDecimal minPrincipal) {
    
    this.minPrincipal = minPrincipal;
    return this;
  }

  /**
   * Get minPrincipal
   * @return minPrincipal
   */
  @javax.annotation.Nullable

  public BigDecimal getMinPrincipal() {
    return minPrincipal;
  }


  public void setMinPrincipal(BigDecimal minPrincipal) {
    this.minPrincipal = minPrincipal;
  }

  public LoanProductData minimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
    return this;
  }

  /**
   * Get minimumDaysBetweenDisbursalAndFirstRepayment
   * @return minimumDaysBetweenDisbursalAndFirstRepayment
   */
  @javax.annotation.Nullable

  public Integer getMinimumDaysBetweenDisbursalAndFirstRepayment() {
    return minimumDaysBetweenDisbursalAndFirstRepayment;
  }


  public void setMinimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
  }

  public LoanProductData minimumGap(Integer minimumGap) {
    
    this.minimumGap = minimumGap;
    return this;
  }

  /**
   * Get minimumGap
   * @return minimumGap
   */
  @javax.annotation.Nullable

  public Integer getMinimumGap() {
    return minimumGap;
  }


  public void setMinimumGap(Integer minimumGap) {
    this.minimumGap = minimumGap;
  }

  public LoanProductData multiDisburseLoan(Boolean multiDisburseLoan) {
    
    this.multiDisburseLoan = multiDisburseLoan;
    return this;
  }

  /**
   * Get multiDisburseLoan
   * @return multiDisburseLoan
   */
  @javax.annotation.Nullable

  public Boolean getMultiDisburseLoan() {
    return multiDisburseLoan;
  }


  public void setMultiDisburseLoan(Boolean multiDisburseLoan) {
    this.multiDisburseLoan = multiDisburseLoan;
  }

  public LoanProductData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public LoanProductData numberOfRepaymentVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public LoanProductData addNumberOfRepaymentVariationsForBorrowerCycleItem(LoanProductBorrowerCycleVariationData numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<LoanProductBorrowerCycleVariationData> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public LoanProductData numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public LoanProductData outstandingLoanBalance(BigDecimal outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(BigDecimal outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public LoanProductData overAppliedCalculationType(String overAppliedCalculationType) {
    
    this.overAppliedCalculationType = overAppliedCalculationType;
    return this;
  }

  /**
   * Get overAppliedCalculationType
   * @return overAppliedCalculationType
   */
  @javax.annotation.Nullable

  public String getOverAppliedCalculationType() {
    return overAppliedCalculationType;
  }


  public void setOverAppliedCalculationType(String overAppliedCalculationType) {
    this.overAppliedCalculationType = overAppliedCalculationType;
  }

  public LoanProductData overAppliedNumber(Integer overAppliedNumber) {
    
    this.overAppliedNumber = overAppliedNumber;
    return this;
  }

  /**
   * Get overAppliedNumber
   * @return overAppliedNumber
   */
  @javax.annotation.Nullable

  public Integer getOverAppliedNumber() {
    return overAppliedNumber;
  }


  public void setOverAppliedNumber(Integer overAppliedNumber) {
    this.overAppliedNumber = overAppliedNumber;
  }

  public LoanProductData overDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get overDueDaysForRepaymentEvent
   * @return overDueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getOverDueDaysForRepaymentEvent() {
    return overDueDaysForRepaymentEvent;
  }


  public void setOverDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
  }

  public LoanProductData overdueDaysForNPA(Integer overdueDaysForNPA) {
    
    this.overdueDaysForNPA = overdueDaysForNPA;
    return this;
  }

  /**
   * Get overdueDaysForNPA
   * @return overdueDaysForNPA
   */
  @javax.annotation.Nullable

  public Integer getOverdueDaysForNPA() {
    return overdueDaysForNPA;
  }


  public void setOverdueDaysForNPA(Integer overdueDaysForNPA) {
    this.overdueDaysForNPA = overdueDaysForNPA;
  }

  public LoanProductData paymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    
    this.paymentAllocation = paymentAllocation;
    return this;
  }

  public LoanProductData addPaymentAllocationItem(AdvancedPaymentData paymentAllocationItem) {
    if (this.paymentAllocation == null) {
      this.paymentAllocation = new ArrayList<>();
    }
    this.paymentAllocation.add(paymentAllocationItem);
    return this;
  }

  /**
   * Get paymentAllocation
   * @return paymentAllocation
   */
  @javax.annotation.Nullable

  public List<AdvancedPaymentData> getPaymentAllocation() {
    return paymentAllocation;
  }


  public void setPaymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    this.paymentAllocation = paymentAllocation;
  }

  public LoanProductData paymentChannelToFundSourceMappings(List<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings) {
    
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
    return this;
  }

  public LoanProductData addPaymentChannelToFundSourceMappingsItem(PaymentTypeToGLAccountMapper paymentChannelToFundSourceMappingsItem) {
    if (this.paymentChannelToFundSourceMappings == null) {
      this.paymentChannelToFundSourceMappings = new ArrayList<>();
    }
    this.paymentChannelToFundSourceMappings.add(paymentChannelToFundSourceMappingsItem);
    return this;
  }

  /**
   * Get paymentChannelToFundSourceMappings
   * @return paymentChannelToFundSourceMappings
   */
  @javax.annotation.Nullable

  public List<PaymentTypeToGLAccountMapper> getPaymentChannelToFundSourceMappings() {
    return paymentChannelToFundSourceMappings;
  }


  public void setPaymentChannelToFundSourceMappings(List<PaymentTypeToGLAccountMapper> paymentChannelToFundSourceMappings) {
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
  }

  public LoanProductData paymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    
    this.paymentTypeOptions = paymentTypeOptions;
    return this;
  }

  public LoanProductData addPaymentTypeOptionsItem(PaymentTypeData paymentTypeOptionsItem) {
    if (this.paymentTypeOptions == null) {
      this.paymentTypeOptions = new ArrayList<>();
    }
    this.paymentTypeOptions.add(paymentTypeOptionsItem);
    return this;
  }

  /**
   * Get paymentTypeOptions
   * @return paymentTypeOptions
   */
  @javax.annotation.Nullable

  public List<PaymentTypeData> getPaymentTypeOptions() {
    return paymentTypeOptions;
  }


  public void setPaymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    this.paymentTypeOptions = paymentTypeOptions;
  }

  public LoanProductData penaltyOptions(List<ChargeData> penaltyOptions) {
    
    this.penaltyOptions = penaltyOptions;
    return this;
  }

  public LoanProductData addPenaltyOptionsItem(ChargeData penaltyOptionsItem) {
    if (this.penaltyOptions == null) {
      this.penaltyOptions = new ArrayList<>();
    }
    this.penaltyOptions.add(penaltyOptionsItem);
    return this;
  }

  /**
   * Get penaltyOptions
   * @return penaltyOptions
   */
  @javax.annotation.Nullable

  public List<ChargeData> getPenaltyOptions() {
    return penaltyOptions;
  }


  public void setPenaltyOptions(List<ChargeData> penaltyOptions) {
    this.penaltyOptions = penaltyOptions;
  }

  public LoanProductData penaltyToIncomeAccountMappings(List<ChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
    return this;
  }

  public LoanProductData addPenaltyToIncomeAccountMappingsItem(ChargeToGLAccountMapper penaltyToIncomeAccountMappingsItem) {
    if (this.penaltyToIncomeAccountMappings == null) {
      this.penaltyToIncomeAccountMappings = new ArrayList<>();
    }
    this.penaltyToIncomeAccountMappings.add(penaltyToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get penaltyToIncomeAccountMappings
   * @return penaltyToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<ChargeToGLAccountMapper> getPenaltyToIncomeAccountMappings() {
    return penaltyToIncomeAccountMappings;
  }


  public void setPenaltyToIncomeAccountMappings(List<ChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
  }

  public LoanProductData preClosureInterestCalculationStrategyOptions(List<EnumOptionData> preClosureInterestCalculationStrategyOptions) {
    
    this.preClosureInterestCalculationStrategyOptions = preClosureInterestCalculationStrategyOptions;
    return this;
  }

  public LoanProductData addPreClosureInterestCalculationStrategyOptionsItem(EnumOptionData preClosureInterestCalculationStrategyOptionsItem) {
    if (this.preClosureInterestCalculationStrategyOptions == null) {
      this.preClosureInterestCalculationStrategyOptions = new ArrayList<>();
    }
    this.preClosureInterestCalculationStrategyOptions.add(preClosureInterestCalculationStrategyOptionsItem);
    return this;
  }

  /**
   * Get preClosureInterestCalculationStrategyOptions
   * @return preClosureInterestCalculationStrategyOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getPreClosureInterestCalculationStrategyOptions() {
    return preClosureInterestCalculationStrategyOptions;
  }


  public void setPreClosureInterestCalculationStrategyOptions(List<EnumOptionData> preClosureInterestCalculationStrategyOptions) {
    this.preClosureInterestCalculationStrategyOptions = preClosureInterestCalculationStrategyOptions;
  }

  public LoanProductData principal(BigDecimal principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipal() {
    return principal;
  }


  public void setPrincipal(BigDecimal principal) {
    this.principal = principal;
  }

  public LoanProductData principalThresholdForLastInstallment(BigDecimal principalThresholdForLastInstallment) {
    
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstallment
   * @return principalThresholdForLastInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalThresholdForLastInstallment() {
    return principalThresholdForLastInstallment;
  }


  public void setPrincipalThresholdForLastInstallment(BigDecimal principalThresholdForLastInstallment) {
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
  }

  public LoanProductData principalVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> principalVariationsForBorrowerCycle) {
    
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
    return this;
  }

  public LoanProductData addPrincipalVariationsForBorrowerCycleItem(LoanProductBorrowerCycleVariationData principalVariationsForBorrowerCycleItem) {
    if (this.principalVariationsForBorrowerCycle == null) {
      this.principalVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.principalVariationsForBorrowerCycle.add(principalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get principalVariationsForBorrowerCycle
   * @return principalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<LoanProductBorrowerCycleVariationData> getPrincipalVariationsForBorrowerCycle() {
    return principalVariationsForBorrowerCycle;
  }


  public void setPrincipalVariationsForBorrowerCycle(List<LoanProductBorrowerCycleVariationData> principalVariationsForBorrowerCycle) {
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
  }

  public LoanProductData productGuaranteeData(LoanProductGuaranteeData productGuaranteeData) {
    
    this.productGuaranteeData = productGuaranteeData;
    return this;
  }

  /**
   * Get productGuaranteeData
   * @return productGuaranteeData
   */
  @javax.annotation.Nullable

  public LoanProductGuaranteeData getProductGuaranteeData() {
    return productGuaranteeData;
  }


  public void setProductGuaranteeData(LoanProductGuaranteeData productGuaranteeData) {
    this.productGuaranteeData = productGuaranteeData;
  }

  public LoanProductData rateOptions(List<RateData> rateOptions) {
    
    this.rateOptions = rateOptions;
    return this;
  }

  public LoanProductData addRateOptionsItem(RateData rateOptionsItem) {
    if (this.rateOptions == null) {
      this.rateOptions = new ArrayList<>();
    }
    this.rateOptions.add(rateOptionsItem);
    return this;
  }

  /**
   * Get rateOptions
   * @return rateOptions
   */
  @javax.annotation.Nullable

  public List<RateData> getRateOptions() {
    return rateOptions;
  }


  public void setRateOptions(List<RateData> rateOptions) {
    this.rateOptions = rateOptions;
  }

  public LoanProductData rates(List<RateData> rates) {
    
    this.rates = rates;
    return this;
  }

  public LoanProductData addRatesItem(RateData ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

  /**
   * Get rates
   * @return rates
   */
  @javax.annotation.Nullable

  public List<RateData> getRates() {
    return rates;
  }


  public void setRates(List<RateData> rates) {
    this.rates = rates;
  }

  public LoanProductData ratesEnabled(Boolean ratesEnabled) {
    
    this.ratesEnabled = ratesEnabled;
    return this;
  }

  /**
   * Get ratesEnabled
   * @return ratesEnabled
   */
  @javax.annotation.Nullable

  public Boolean getRatesEnabled() {
    return ratesEnabled;
  }


  public void setRatesEnabled(Boolean ratesEnabled) {
    this.ratesEnabled = ratesEnabled;
  }

  public LoanProductData recurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
    return this;
  }

  /**
   * Get recurringMoratoriumOnPrincipalPeriods
   * @return recurringMoratoriumOnPrincipalPeriods
   */
  @javax.annotation.Nullable

  public Integer getRecurringMoratoriumOnPrincipalPeriods() {
    return recurringMoratoriumOnPrincipalPeriods;
  }


  public void setRecurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
  }

  public LoanProductData repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public LoanProductData repaymentFrequencyType(EnumOptionData repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public EnumOptionData getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(EnumOptionData repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public LoanProductData repaymentFrequencyTypeOptions(List<EnumOptionData> repaymentFrequencyTypeOptions) {
    
    this.repaymentFrequencyTypeOptions = repaymentFrequencyTypeOptions;
    return this;
  }

  public LoanProductData addRepaymentFrequencyTypeOptionsItem(EnumOptionData repaymentFrequencyTypeOptionsItem) {
    if (this.repaymentFrequencyTypeOptions == null) {
      this.repaymentFrequencyTypeOptions = new ArrayList<>();
    }
    this.repaymentFrequencyTypeOptions.add(repaymentFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get repaymentFrequencyTypeOptions
   * @return repaymentFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getRepaymentFrequencyTypeOptions() {
    return repaymentFrequencyTypeOptions;
  }


  public void setRepaymentFrequencyTypeOptions(List<EnumOptionData> repaymentFrequencyTypeOptions) {
    this.repaymentFrequencyTypeOptions = repaymentFrequencyTypeOptions;
  }

  public LoanProductData repaymentStartDateType(EnumOptionData repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public EnumOptionData getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(EnumOptionData repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public LoanProductData repaymentStartDateTypeOptions(List<EnumOptionData> repaymentStartDateTypeOptions) {
    
    this.repaymentStartDateTypeOptions = repaymentStartDateTypeOptions;
    return this;
  }

  public LoanProductData addRepaymentStartDateTypeOptionsItem(EnumOptionData repaymentStartDateTypeOptionsItem) {
    if (this.repaymentStartDateTypeOptions == null) {
      this.repaymentStartDateTypeOptions = new ArrayList<>();
    }
    this.repaymentStartDateTypeOptions.add(repaymentStartDateTypeOptionsItem);
    return this;
  }

  /**
   * Get repaymentStartDateTypeOptions
   * @return repaymentStartDateTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getRepaymentStartDateTypeOptions() {
    return repaymentStartDateTypeOptions;
  }


  public void setRepaymentStartDateTypeOptions(List<EnumOptionData> repaymentStartDateTypeOptions) {
    this.repaymentStartDateTypeOptions = repaymentStartDateTypeOptions;
  }

  public LoanProductData rescheduleStrategyTypeOptions(List<EnumOptionData> rescheduleStrategyTypeOptions) {
    
    this.rescheduleStrategyTypeOptions = rescheduleStrategyTypeOptions;
    return this;
  }

  public LoanProductData addRescheduleStrategyTypeOptionsItem(EnumOptionData rescheduleStrategyTypeOptionsItem) {
    if (this.rescheduleStrategyTypeOptions == null) {
      this.rescheduleStrategyTypeOptions = new ArrayList<>();
    }
    this.rescheduleStrategyTypeOptions.add(rescheduleStrategyTypeOptionsItem);
    return this;
  }

  /**
   * Get rescheduleStrategyTypeOptions
   * @return rescheduleStrategyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getRescheduleStrategyTypeOptions() {
    return rescheduleStrategyTypeOptions;
  }


  public void setRescheduleStrategyTypeOptions(List<EnumOptionData> rescheduleStrategyTypeOptions) {
    this.rescheduleStrategyTypeOptions = rescheduleStrategyTypeOptions;
  }

  public LoanProductData shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public LoanProductData startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartDate() {
    return startDate;
  }


  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  public LoanProductData status(String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public String getStatus() {
    return status;
  }


  public void setStatus(String status) {
    this.status = status;
  }

  public LoanProductData supportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public LoanProductData addSupportedInterestRefundTypesItem(StringEnumOptionData supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public LoanProductData supportedInterestRefundTypesOptions(List<StringEnumOptionData> supportedInterestRefundTypesOptions) {
    
    this.supportedInterestRefundTypesOptions = supportedInterestRefundTypesOptions;
    return this;
  }

  public LoanProductData addSupportedInterestRefundTypesOptionsItem(StringEnumOptionData supportedInterestRefundTypesOptionsItem) {
    if (this.supportedInterestRefundTypesOptions == null) {
      this.supportedInterestRefundTypesOptions = new ArrayList<>();
    }
    this.supportedInterestRefundTypesOptions.add(supportedInterestRefundTypesOptionsItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypesOptions
   * @return supportedInterestRefundTypesOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypesOptions() {
    return supportedInterestRefundTypesOptions;
  }


  public void setSupportedInterestRefundTypesOptions(List<StringEnumOptionData> supportedInterestRefundTypesOptions) {
    this.supportedInterestRefundTypesOptions = supportedInterestRefundTypesOptions;
  }

  public LoanProductData syncExpectedWithDisbursementDate(Boolean syncExpectedWithDisbursementDate) {
    
    this.syncExpectedWithDisbursementDate = syncExpectedWithDisbursementDate;
    return this;
  }

  /**
   * Get syncExpectedWithDisbursementDate
   * @return syncExpectedWithDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getSyncExpectedWithDisbursementDate() {
    return syncExpectedWithDisbursementDate;
  }


  public void setSyncExpectedWithDisbursementDate(Boolean syncExpectedWithDisbursementDate) {
    this.syncExpectedWithDisbursementDate = syncExpectedWithDisbursementDate;
  }

  public LoanProductData transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public LoanProductData transactionProcessingStrategyName(String transactionProcessingStrategyName) {
    
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
    return this;
  }

  /**
   * Get transactionProcessingStrategyName
   * @return transactionProcessingStrategyName
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyName() {
    return transactionProcessingStrategyName;
  }


  public void setTransactionProcessingStrategyName(String transactionProcessingStrategyName) {
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
  }

  public LoanProductData transactionProcessingStrategyOptions(List<TransactionProcessingStrategyData> transactionProcessingStrategyOptions) {
    
    this.transactionProcessingStrategyOptions = transactionProcessingStrategyOptions;
    return this;
  }

  public LoanProductData addTransactionProcessingStrategyOptionsItem(TransactionProcessingStrategyData transactionProcessingStrategyOptionsItem) {
    if (this.transactionProcessingStrategyOptions == null) {
      this.transactionProcessingStrategyOptions = new ArrayList<>();
    }
    this.transactionProcessingStrategyOptions.add(transactionProcessingStrategyOptionsItem);
    return this;
  }

  /**
   * Get transactionProcessingStrategyOptions
   * @return transactionProcessingStrategyOptions
   */
  @javax.annotation.Nullable

  public List<TransactionProcessingStrategyData> getTransactionProcessingStrategyOptions() {
    return transactionProcessingStrategyOptions;
  }


  public void setTransactionProcessingStrategyOptions(List<TransactionProcessingStrategyData> transactionProcessingStrategyOptions) {
    this.transactionProcessingStrategyOptions = transactionProcessingStrategyOptions;
  }

  public LoanProductData useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public LoanProductData valueConditionTypeOptions(List<EnumOptionData> valueConditionTypeOptions) {
    
    this.valueConditionTypeOptions = valueConditionTypeOptions;
    return this;
  }

  public LoanProductData addValueConditionTypeOptionsItem(EnumOptionData valueConditionTypeOptionsItem) {
    if (this.valueConditionTypeOptions == null) {
      this.valueConditionTypeOptions = new ArrayList<>();
    }
    this.valueConditionTypeOptions.add(valueConditionTypeOptionsItem);
    return this;
  }

  /**
   * Get valueConditionTypeOptions
   * @return valueConditionTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getValueConditionTypeOptions() {
    return valueConditionTypeOptions;
  }


  public void setValueConditionTypeOptions(List<EnumOptionData> valueConditionTypeOptions) {
    this.valueConditionTypeOptions = valueConditionTypeOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductData loanProductData = (LoanProductData) o;
    return Objects.equals(this.accountMovesOutOfNPAOnlyOnArrearsCompletion, loanProductData.accountMovesOutOfNPAOnlyOnArrearsCompletion) &&
        Objects.equals(this.accountingMappingOptions, loanProductData.accountingMappingOptions) &&
        Objects.equals(this.accountingMappings, loanProductData.accountingMappings) &&
        Objects.equals(this.accountingRule, loanProductData.accountingRule) &&
        Objects.equals(this.accountingRuleOptions, loanProductData.accountingRuleOptions) &&
        Objects.equals(this.advancedPaymentAllocationFutureInstallmentAllocationRules, loanProductData.advancedPaymentAllocationFutureInstallmentAllocationRules) &&
        Objects.equals(this.advancedPaymentAllocationTransactionTypes, loanProductData.advancedPaymentAllocationTransactionTypes) &&
        Objects.equals(this.advancedPaymentAllocationTypes, loanProductData.advancedPaymentAllocationTypes) &&
        Objects.equals(this.allowApprovedDisbursedAmountsOverApplied, loanProductData.allowApprovedDisbursedAmountsOverApplied) &&
        Objects.equals(this.allowAttributeOverrides, loanProductData.allowAttributeOverrides) &&
        Objects.equals(this.allowPartialPeriodInterestCalculation, loanProductData.allowPartialPeriodInterestCalculation) &&
        Objects.equals(this.allowVariableInstallments, loanProductData.allowVariableInstallments) &&
        Objects.equals(this.amortizationType, loanProductData.amortizationType) &&
        Objects.equals(this.amortizationTypeOptions, loanProductData.amortizationTypeOptions) &&
        Objects.equals(this.annualInterestRate, loanProductData.annualInterestRate) &&
        Objects.equals(this.canDefineInstallmentAmount, loanProductData.canDefineInstallmentAmount) &&
        Objects.equals(this.canUseForTopup, loanProductData.canUseForTopup) &&
        Objects.equals(this.chargeOffBehaviour, loanProductData.chargeOffBehaviour) &&
        Objects.equals(this.chargeOffBehaviourOptions, loanProductData.chargeOffBehaviourOptions) &&
        Objects.equals(this.chargeOffReasonOptions, loanProductData.chargeOffReasonOptions) &&
        Objects.equals(this.chargeOffReasonToExpenseAccountMappings, loanProductData.chargeOffReasonToExpenseAccountMappings) &&
        Objects.equals(this.chargeOptions, loanProductData.chargeOptions) &&
        Objects.equals(this.charges, loanProductData.charges) &&
        Objects.equals(this.closeDate, loanProductData.closeDate) &&
        Objects.equals(this.compoundingToBePostedAsTransaction, loanProductData.compoundingToBePostedAsTransaction) &&
        Objects.equals(this.creditAllocation, loanProductData.creditAllocation) &&
        Objects.equals(this.creditAllocationAllocationTypes, loanProductData.creditAllocationAllocationTypes) &&
        Objects.equals(this.creditAllocationTransactionTypes, loanProductData.creditAllocationTransactionTypes) &&
        Objects.equals(this.currency, loanProductData.currency) &&
        Objects.equals(this.currencyOptions, loanProductData.currencyOptions) &&
        Objects.equals(this.daysInMonthType, loanProductData.daysInMonthType) &&
        Objects.equals(this.daysInMonthTypeOptions, loanProductData.daysInMonthTypeOptions) &&
        Objects.equals(this.daysInYearType, loanProductData.daysInYearType) &&
        Objects.equals(this.daysInYearTypeOptions, loanProductData.daysInYearTypeOptions) &&
        Objects.equals(this.defaultDifferentialLendingRate, loanProductData.defaultDifferentialLendingRate) &&
        Objects.equals(this.delinquencyBucket, loanProductData.delinquencyBucket) &&
        Objects.equals(this.delinquencyBucketOptions, loanProductData.delinquencyBucketOptions) &&
        Objects.equals(this.description, loanProductData.description) &&
        Objects.equals(this.disallowExpectedDisbursements, loanProductData.disallowExpectedDisbursements) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, loanProductData.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.dueDaysForRepaymentEvent, loanProductData.dueDaysForRepaymentEvent) &&
        Objects.equals(this.enableAccrualActivityPosting, loanProductData.enableAccrualActivityPosting) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, loanProductData.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableDownPayment, loanProductData.enableDownPayment) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, loanProductData.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.equalAmortization, loanProductData.equalAmortization) &&
        Objects.equals(this.externalId, loanProductData.externalId) &&
        Objects.equals(this.feeToIncomeAccountMappings, loanProductData.feeToIncomeAccountMappings) &&
        Objects.equals(this.fixedLength, loanProductData.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, loanProductData.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.floatingInterestRateCalculationAllowed, loanProductData.floatingInterestRateCalculationAllowed) &&
        Objects.equals(this.floatingRateId, loanProductData.floatingRateId) &&
        Objects.equals(this.floatingRateName, loanProductData.floatingRateName) &&
        Objects.equals(this.floatingRateOptions, loanProductData.floatingRateOptions) &&
        Objects.equals(this.fundId, loanProductData.fundId) &&
        Objects.equals(this.fundName, loanProductData.fundName) &&
        Objects.equals(this.fundOptions, loanProductData.fundOptions) &&
        Objects.equals(this.graceOnArrearsAgeing, loanProductData.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestCharged, loanProductData.graceOnInterestCharged) &&
        Objects.equals(this.graceOnInterestPayment, loanProductData.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, loanProductData.graceOnPrincipalPayment) &&
        Objects.equals(this.holdGuaranteeFunds, loanProductData.holdGuaranteeFunds) &&
        Objects.equals(this.id, loanProductData.id) &&
        Objects.equals(this.inArrearsTolerance, loanProductData.inArrearsTolerance) &&
        Objects.equals(this.includeInBorrowerCycle, loanProductData.includeInBorrowerCycle) &&
        Objects.equals(this.installmentAmountInMultiplesOf, loanProductData.installmentAmountInMultiplesOf) &&
        Objects.equals(this.interestCalculationPeriodType, loanProductData.interestCalculationPeriodType) &&
        Objects.equals(this.interestCalculationPeriodTypeOptions, loanProductData.interestCalculationPeriodTypeOptions) &&
        Objects.equals(this.interestRateDifferential, loanProductData.interestRateDifferential) &&
        Objects.equals(this.interestRateFrequencyType, loanProductData.interestRateFrequencyType) &&
        Objects.equals(this.interestRateFrequencyTypeOptions, loanProductData.interestRateFrequencyTypeOptions) &&
        Objects.equals(this.interestRatePerPeriod, loanProductData.interestRatePerPeriod) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, loanProductData.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationCompoundingTypeOptions, loanProductData.interestRecalculationCompoundingTypeOptions) &&
        Objects.equals(this.interestRecalculationData, loanProductData.interestRecalculationData) &&
        Objects.equals(this.interestRecalculationDayOfWeekTypeOptions, loanProductData.interestRecalculationDayOfWeekTypeOptions) &&
        Objects.equals(this.interestRecalculationEnabled, loanProductData.interestRecalculationEnabled) &&
        Objects.equals(this.interestRecalculationFrequencyTypeOptions, loanProductData.interestRecalculationFrequencyTypeOptions) &&
        Objects.equals(this.interestRecalculationNthDayTypeOptions, loanProductData.interestRecalculationNthDayTypeOptions) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, loanProductData.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, loanProductData.interestType) &&
        Objects.equals(this.interestTypeOptions, loanProductData.interestTypeOptions) &&
        Objects.equals(this.isAllowPartialPeriodInterestCalculation, loanProductData.isAllowPartialPeriodInterestCalculation) &&
        Objects.equals(this.isEqualAmortization, loanProductData.isEqualAmortization) &&
        Objects.equals(this.isFloatingInterestRateCalculationAllowed, loanProductData.isFloatingInterestRateCalculationAllowed) &&
        Objects.equals(this.isInterestRecalculationEnabled, loanProductData.isInterestRecalculationEnabled) &&
        Objects.equals(this.isLinkedToFloatingInterestRates, loanProductData.isLinkedToFloatingInterestRates) &&
        Objects.equals(this.isRatesEnabled, loanProductData.isRatesEnabled) &&
        Objects.equals(this.linkedToFloatingInterestRates, loanProductData.linkedToFloatingInterestRates) &&
        Objects.equals(this.loanProductConfigurableAttributes, loanProductData.loanProductConfigurableAttributes) &&
        Objects.equals(this.loanScheduleProcessingType, loanProductData.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleProcessingTypeOptions, loanProductData.loanScheduleProcessingTypeOptions) &&
        Objects.equals(this.loanScheduleType, loanProductData.loanScheduleType) &&
        Objects.equals(this.loanScheduleTypeOptions, loanProductData.loanScheduleTypeOptions) &&
        Objects.equals(this.maxDifferentialLendingRate, loanProductData.maxDifferentialLendingRate) &&
        Objects.equals(this.maxInterestRatePerPeriod, loanProductData.maxInterestRatePerPeriod) &&
        Objects.equals(this.maxNumberOfRepayments, loanProductData.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipal, loanProductData.maxPrincipal) &&
        Objects.equals(this.maxTrancheCount, loanProductData.maxTrancheCount) &&
        Objects.equals(this.maximumGap, loanProductData.maximumGap) &&
        Objects.equals(this.minDifferentialLendingRate, loanProductData.minDifferentialLendingRate) &&
        Objects.equals(this.minInterestRatePerPeriod, loanProductData.minInterestRatePerPeriod) &&
        Objects.equals(this.minNumberOfRepayments, loanProductData.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipal, loanProductData.minPrincipal) &&
        Objects.equals(this.minimumDaysBetweenDisbursalAndFirstRepayment, loanProductData.minimumDaysBetweenDisbursalAndFirstRepayment) &&
        Objects.equals(this.minimumGap, loanProductData.minimumGap) &&
        Objects.equals(this.multiDisburseLoan, loanProductData.multiDisburseLoan) &&
        Objects.equals(this.name, loanProductData.name) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, loanProductData.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.numberOfRepayments, loanProductData.numberOfRepayments) &&
        Objects.equals(this.outstandingLoanBalance, loanProductData.outstandingLoanBalance) &&
        Objects.equals(this.overAppliedCalculationType, loanProductData.overAppliedCalculationType) &&
        Objects.equals(this.overAppliedNumber, loanProductData.overAppliedNumber) &&
        Objects.equals(this.overDueDaysForRepaymentEvent, loanProductData.overDueDaysForRepaymentEvent) &&
        Objects.equals(this.overdueDaysForNPA, loanProductData.overdueDaysForNPA) &&
        Objects.equals(this.paymentAllocation, loanProductData.paymentAllocation) &&
        Objects.equals(this.paymentChannelToFundSourceMappings, loanProductData.paymentChannelToFundSourceMappings) &&
        Objects.equals(this.paymentTypeOptions, loanProductData.paymentTypeOptions) &&
        Objects.equals(this.penaltyOptions, loanProductData.penaltyOptions) &&
        Objects.equals(this.penaltyToIncomeAccountMappings, loanProductData.penaltyToIncomeAccountMappings) &&
        Objects.equals(this.preClosureInterestCalculationStrategyOptions, loanProductData.preClosureInterestCalculationStrategyOptions) &&
        Objects.equals(this.principal, loanProductData.principal) &&
        Objects.equals(this.principalThresholdForLastInstallment, loanProductData.principalThresholdForLastInstallment) &&
        Objects.equals(this.principalVariationsForBorrowerCycle, loanProductData.principalVariationsForBorrowerCycle) &&
        Objects.equals(this.productGuaranteeData, loanProductData.productGuaranteeData) &&
        Objects.equals(this.rateOptions, loanProductData.rateOptions) &&
        Objects.equals(this.rates, loanProductData.rates) &&
        Objects.equals(this.ratesEnabled, loanProductData.ratesEnabled) &&
        Objects.equals(this.recurringMoratoriumOnPrincipalPeriods, loanProductData.recurringMoratoriumOnPrincipalPeriods) &&
        Objects.equals(this.repaymentEvery, loanProductData.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, loanProductData.repaymentFrequencyType) &&
        Objects.equals(this.repaymentFrequencyTypeOptions, loanProductData.repaymentFrequencyTypeOptions) &&
        Objects.equals(this.repaymentStartDateType, loanProductData.repaymentStartDateType) &&
        Objects.equals(this.repaymentStartDateTypeOptions, loanProductData.repaymentStartDateTypeOptions) &&
        Objects.equals(this.rescheduleStrategyTypeOptions, loanProductData.rescheduleStrategyTypeOptions) &&
        Objects.equals(this.shortName, loanProductData.shortName) &&
        Objects.equals(this.startDate, loanProductData.startDate) &&
        Objects.equals(this.status, loanProductData.status) &&
        Objects.equals(this.supportedInterestRefundTypes, loanProductData.supportedInterestRefundTypes) &&
        Objects.equals(this.supportedInterestRefundTypesOptions, loanProductData.supportedInterestRefundTypesOptions) &&
        Objects.equals(this.syncExpectedWithDisbursementDate, loanProductData.syncExpectedWithDisbursementDate) &&
        Objects.equals(this.transactionProcessingStrategyCode, loanProductData.transactionProcessingStrategyCode) &&
        Objects.equals(this.transactionProcessingStrategyName, loanProductData.transactionProcessingStrategyName) &&
        Objects.equals(this.transactionProcessingStrategyOptions, loanProductData.transactionProcessingStrategyOptions) &&
        Objects.equals(this.useBorrowerCycle, loanProductData.useBorrowerCycle) &&
        Objects.equals(this.valueConditionTypeOptions, loanProductData.valueConditionTypeOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountMovesOutOfNPAOnlyOnArrearsCompletion, accountingMappingOptions, accountingMappings, accountingRule, accountingRuleOptions, advancedPaymentAllocationFutureInstallmentAllocationRules, advancedPaymentAllocationTransactionTypes, advancedPaymentAllocationTypes, allowApprovedDisbursedAmountsOverApplied, allowAttributeOverrides, allowPartialPeriodInterestCalculation, allowVariableInstallments, amortizationType, amortizationTypeOptions, annualInterestRate, canDefineInstallmentAmount, canUseForTopup, chargeOffBehaviour, chargeOffBehaviourOptions, chargeOffReasonOptions, chargeOffReasonToExpenseAccountMappings, chargeOptions, charges, closeDate, compoundingToBePostedAsTransaction, creditAllocation, creditAllocationAllocationTypes, creditAllocationTransactionTypes, currency, currencyOptions, daysInMonthType, daysInMonthTypeOptions, daysInYearType, daysInYearTypeOptions, defaultDifferentialLendingRate, delinquencyBucket, delinquencyBucketOptions, description, disallowExpectedDisbursements, disbursedAmountPercentageForDownPayment, dueDaysForRepaymentEvent, enableAccrualActivityPosting, enableAutoRepaymentForDownPayment, enableDownPayment, enableInstallmentLevelDelinquency, equalAmortization, externalId, feeToIncomeAccountMappings, fixedLength, fixedPrincipalPercentagePerInstallment, floatingInterestRateCalculationAllowed, floatingRateId, floatingRateName, floatingRateOptions, fundId, fundName, fundOptions, graceOnArrearsAgeing, graceOnInterestCharged, graceOnInterestPayment, graceOnPrincipalPayment, holdGuaranteeFunds, id, inArrearsTolerance, includeInBorrowerCycle, installmentAmountInMultiplesOf, interestCalculationPeriodType, interestCalculationPeriodTypeOptions, interestRateDifferential, interestRateFrequencyType, interestRateFrequencyTypeOptions, interestRatePerPeriod, interestRateVariationsForBorrowerCycle, interestRecalculationCompoundingTypeOptions, interestRecalculationData, interestRecalculationDayOfWeekTypeOptions, interestRecalculationEnabled, interestRecalculationFrequencyTypeOptions, interestRecalculationNthDayTypeOptions, interestRecognitionOnDisbursementDate, interestType, interestTypeOptions, isAllowPartialPeriodInterestCalculation, isEqualAmortization, isFloatingInterestRateCalculationAllowed, isInterestRecalculationEnabled, isLinkedToFloatingInterestRates, isRatesEnabled, linkedToFloatingInterestRates, loanProductConfigurableAttributes, loanScheduleProcessingType, loanScheduleProcessingTypeOptions, loanScheduleType, loanScheduleTypeOptions, maxDifferentialLendingRate, maxInterestRatePerPeriod, maxNumberOfRepayments, maxPrincipal, maxTrancheCount, maximumGap, minDifferentialLendingRate, minInterestRatePerPeriod, minNumberOfRepayments, minPrincipal, minimumDaysBetweenDisbursalAndFirstRepayment, minimumGap, multiDisburseLoan, name, numberOfRepaymentVariationsForBorrowerCycle, numberOfRepayments, outstandingLoanBalance, overAppliedCalculationType, overAppliedNumber, overDueDaysForRepaymentEvent, overdueDaysForNPA, paymentAllocation, paymentChannelToFundSourceMappings, paymentTypeOptions, penaltyOptions, penaltyToIncomeAccountMappings, preClosureInterestCalculationStrategyOptions, principal, principalThresholdForLastInstallment, principalVariationsForBorrowerCycle, productGuaranteeData, rateOptions, rates, ratesEnabled, recurringMoratoriumOnPrincipalPeriods, repaymentEvery, repaymentFrequencyType, repaymentFrequencyTypeOptions, repaymentStartDateType, repaymentStartDateTypeOptions, rescheduleStrategyTypeOptions, shortName, startDate, status, supportedInterestRefundTypes, supportedInterestRefundTypesOptions, syncExpectedWithDisbursementDate, transactionProcessingStrategyCode, transactionProcessingStrategyName, transactionProcessingStrategyOptions, useBorrowerCycle, valueConditionTypeOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductData {\n");
    sb.append("    accountMovesOutOfNPAOnlyOnArrearsCompletion: ").append(toIndentedString(accountMovesOutOfNPAOnlyOnArrearsCompletion)).append("\n");
    sb.append("    accountingMappingOptions: ").append(toIndentedString(accountingMappingOptions)).append("\n");
    sb.append("    accountingMappings: ").append(toIndentedString(accountingMappings)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    accountingRuleOptions: ").append(toIndentedString(accountingRuleOptions)).append("\n");
    sb.append("    advancedPaymentAllocationFutureInstallmentAllocationRules: ").append(toIndentedString(advancedPaymentAllocationFutureInstallmentAllocationRules)).append("\n");
    sb.append("    advancedPaymentAllocationTransactionTypes: ").append(toIndentedString(advancedPaymentAllocationTransactionTypes)).append("\n");
    sb.append("    advancedPaymentAllocationTypes: ").append(toIndentedString(advancedPaymentAllocationTypes)).append("\n");
    sb.append("    allowApprovedDisbursedAmountsOverApplied: ").append(toIndentedString(allowApprovedDisbursedAmountsOverApplied)).append("\n");
    sb.append("    allowAttributeOverrides: ").append(toIndentedString(allowAttributeOverrides)).append("\n");
    sb.append("    allowPartialPeriodInterestCalculation: ").append(toIndentedString(allowPartialPeriodInterestCalculation)).append("\n");
    sb.append("    allowVariableInstallments: ").append(toIndentedString(allowVariableInstallments)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    amortizationTypeOptions: ").append(toIndentedString(amortizationTypeOptions)).append("\n");
    sb.append("    annualInterestRate: ").append(toIndentedString(annualInterestRate)).append("\n");
    sb.append("    canDefineInstallmentAmount: ").append(toIndentedString(canDefineInstallmentAmount)).append("\n");
    sb.append("    canUseForTopup: ").append(toIndentedString(canUseForTopup)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargeOffBehaviourOptions: ").append(toIndentedString(chargeOffBehaviourOptions)).append("\n");
    sb.append("    chargeOffReasonOptions: ").append(toIndentedString(chargeOffReasonOptions)).append("\n");
    sb.append("    chargeOffReasonToExpenseAccountMappings: ").append(toIndentedString(chargeOffReasonToExpenseAccountMappings)).append("\n");
    sb.append("    chargeOptions: ").append(toIndentedString(chargeOptions)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    closeDate: ").append(toIndentedString(closeDate)).append("\n");
    sb.append("    compoundingToBePostedAsTransaction: ").append(toIndentedString(compoundingToBePostedAsTransaction)).append("\n");
    sb.append("    creditAllocation: ").append(toIndentedString(creditAllocation)).append("\n");
    sb.append("    creditAllocationAllocationTypes: ").append(toIndentedString(creditAllocationAllocationTypes)).append("\n");
    sb.append("    creditAllocationTransactionTypes: ").append(toIndentedString(creditAllocationTransactionTypes)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currencyOptions: ").append(toIndentedString(currencyOptions)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInMonthTypeOptions: ").append(toIndentedString(daysInMonthTypeOptions)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    daysInYearTypeOptions: ").append(toIndentedString(daysInYearTypeOptions)).append("\n");
    sb.append("    defaultDifferentialLendingRate: ").append(toIndentedString(defaultDifferentialLendingRate)).append("\n");
    sb.append("    delinquencyBucket: ").append(toIndentedString(delinquencyBucket)).append("\n");
    sb.append("    delinquencyBucketOptions: ").append(toIndentedString(delinquencyBucketOptions)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    dueDaysForRepaymentEvent: ").append(toIndentedString(dueDaysForRepaymentEvent)).append("\n");
    sb.append("    enableAccrualActivityPosting: ").append(toIndentedString(enableAccrualActivityPosting)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    equalAmortization: ").append(toIndentedString(equalAmortization)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    feeToIncomeAccountMappings: ").append(toIndentedString(feeToIncomeAccountMappings)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    floatingInterestRateCalculationAllowed: ").append(toIndentedString(floatingInterestRateCalculationAllowed)).append("\n");
    sb.append("    floatingRateId: ").append(toIndentedString(floatingRateId)).append("\n");
    sb.append("    floatingRateName: ").append(toIndentedString(floatingRateName)).append("\n");
    sb.append("    floatingRateOptions: ").append(toIndentedString(floatingRateOptions)).append("\n");
    sb.append("    fundId: ").append(toIndentedString(fundId)).append("\n");
    sb.append("    fundName: ").append(toIndentedString(fundName)).append("\n");
    sb.append("    fundOptions: ").append(toIndentedString(fundOptions)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestCharged: ").append(toIndentedString(graceOnInterestCharged)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    holdGuaranteeFunds: ").append(toIndentedString(holdGuaranteeFunds)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    installmentAmountInMultiplesOf: ").append(toIndentedString(installmentAmountInMultiplesOf)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestCalculationPeriodTypeOptions: ").append(toIndentedString(interestCalculationPeriodTypeOptions)).append("\n");
    sb.append("    interestRateDifferential: ").append(toIndentedString(interestRateDifferential)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRateFrequencyTypeOptions: ").append(toIndentedString(interestRateFrequencyTypeOptions)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationCompoundingTypeOptions: ").append(toIndentedString(interestRecalculationCompoundingTypeOptions)).append("\n");
    sb.append("    interestRecalculationData: ").append(toIndentedString(interestRecalculationData)).append("\n");
    sb.append("    interestRecalculationDayOfWeekTypeOptions: ").append(toIndentedString(interestRecalculationDayOfWeekTypeOptions)).append("\n");
    sb.append("    interestRecalculationEnabled: ").append(toIndentedString(interestRecalculationEnabled)).append("\n");
    sb.append("    interestRecalculationFrequencyTypeOptions: ").append(toIndentedString(interestRecalculationFrequencyTypeOptions)).append("\n");
    sb.append("    interestRecalculationNthDayTypeOptions: ").append(toIndentedString(interestRecalculationNthDayTypeOptions)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    interestTypeOptions: ").append(toIndentedString(interestTypeOptions)).append("\n");
    sb.append("    isAllowPartialPeriodInterestCalculation: ").append(toIndentedString(isAllowPartialPeriodInterestCalculation)).append("\n");
    sb.append("    isEqualAmortization: ").append(toIndentedString(isEqualAmortization)).append("\n");
    sb.append("    isFloatingInterestRateCalculationAllowed: ").append(toIndentedString(isFloatingInterestRateCalculationAllowed)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    isLinkedToFloatingInterestRates: ").append(toIndentedString(isLinkedToFloatingInterestRates)).append("\n");
    sb.append("    isRatesEnabled: ").append(toIndentedString(isRatesEnabled)).append("\n");
    sb.append("    linkedToFloatingInterestRates: ").append(toIndentedString(linkedToFloatingInterestRates)).append("\n");
    sb.append("    loanProductConfigurableAttributes: ").append(toIndentedString(loanProductConfigurableAttributes)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleProcessingTypeOptions: ").append(toIndentedString(loanScheduleProcessingTypeOptions)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    loanScheduleTypeOptions: ").append(toIndentedString(loanScheduleTypeOptions)).append("\n");
    sb.append("    maxDifferentialLendingRate: ").append(toIndentedString(maxDifferentialLendingRate)).append("\n");
    sb.append("    maxInterestRatePerPeriod: ").append(toIndentedString(maxInterestRatePerPeriod)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipal: ").append(toIndentedString(maxPrincipal)).append("\n");
    sb.append("    maxTrancheCount: ").append(toIndentedString(maxTrancheCount)).append("\n");
    sb.append("    maximumGap: ").append(toIndentedString(maximumGap)).append("\n");
    sb.append("    minDifferentialLendingRate: ").append(toIndentedString(minDifferentialLendingRate)).append("\n");
    sb.append("    minInterestRatePerPeriod: ").append(toIndentedString(minInterestRatePerPeriod)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipal: ").append(toIndentedString(minPrincipal)).append("\n");
    sb.append("    minimumDaysBetweenDisbursalAndFirstRepayment: ").append(toIndentedString(minimumDaysBetweenDisbursalAndFirstRepayment)).append("\n");
    sb.append("    minimumGap: ").append(toIndentedString(minimumGap)).append("\n");
    sb.append("    multiDisburseLoan: ").append(toIndentedString(multiDisburseLoan)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    overAppliedCalculationType: ").append(toIndentedString(overAppliedCalculationType)).append("\n");
    sb.append("    overAppliedNumber: ").append(toIndentedString(overAppliedNumber)).append("\n");
    sb.append("    overDueDaysForRepaymentEvent: ").append(toIndentedString(overDueDaysForRepaymentEvent)).append("\n");
    sb.append("    overdueDaysForNPA: ").append(toIndentedString(overdueDaysForNPA)).append("\n");
    sb.append("    paymentAllocation: ").append(toIndentedString(paymentAllocation)).append("\n");
    sb.append("    paymentChannelToFundSourceMappings: ").append(toIndentedString(paymentChannelToFundSourceMappings)).append("\n");
    sb.append("    paymentTypeOptions: ").append(toIndentedString(paymentTypeOptions)).append("\n");
    sb.append("    penaltyOptions: ").append(toIndentedString(penaltyOptions)).append("\n");
    sb.append("    penaltyToIncomeAccountMappings: ").append(toIndentedString(penaltyToIncomeAccountMappings)).append("\n");
    sb.append("    preClosureInterestCalculationStrategyOptions: ").append(toIndentedString(preClosureInterestCalculationStrategyOptions)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    principalThresholdForLastInstallment: ").append(toIndentedString(principalThresholdForLastInstallment)).append("\n");
    sb.append("    principalVariationsForBorrowerCycle: ").append(toIndentedString(principalVariationsForBorrowerCycle)).append("\n");
    sb.append("    productGuaranteeData: ").append(toIndentedString(productGuaranteeData)).append("\n");
    sb.append("    rateOptions: ").append(toIndentedString(rateOptions)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("    ratesEnabled: ").append(toIndentedString(ratesEnabled)).append("\n");
    sb.append("    recurringMoratoriumOnPrincipalPeriods: ").append(toIndentedString(recurringMoratoriumOnPrincipalPeriods)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentFrequencyTypeOptions: ").append(toIndentedString(repaymentFrequencyTypeOptions)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    repaymentStartDateTypeOptions: ").append(toIndentedString(repaymentStartDateTypeOptions)).append("\n");
    sb.append("    rescheduleStrategyTypeOptions: ").append(toIndentedString(rescheduleStrategyTypeOptions)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    supportedInterestRefundTypesOptions: ").append(toIndentedString(supportedInterestRefundTypesOptions)).append("\n");
    sb.append("    syncExpectedWithDisbursementDate: ").append(toIndentedString(syncExpectedWithDisbursementDate)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transactionProcessingStrategyName: ").append(toIndentedString(transactionProcessingStrategyName)).append("\n");
    sb.append("    transactionProcessingStrategyOptions: ").append(toIndentedString(transactionProcessingStrategyOptions)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    valueConditionTypeOptions: ").append(toIndentedString(valueConditionTypeOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

