/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.PostLoansDisbursementData;
import org.apache.fineract.client.models.PostLoansRequestChargeData;

/**
 * PostLoansRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class PostLoansRequest {
  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private Integer amortizationType;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<PostLoansRequestChargeData> charges;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  /**
   * Gets or Sets daysInYearType
   */
  @JsonAdapter(DaysInYearTypeEnum.Adapter.class)
  public enum DaysInYearTypeEnum {
    NUMBER_null(null);

    private Integer value;

    DaysInYearTypeEnum(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DaysInYearTypeEnum fromValue(Integer value) {
      for (DaysInYearTypeEnum b : DaysInYearTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DaysInYearTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DaysInYearTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DaysInYearTypeEnum read(final JsonReader jsonReader) throws IOException {
        Integer value =  jsonReader.nextInt();
        return DaysInYearTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private DaysInYearTypeEnum daysInYearType;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DISBURSEMENT_DATA = "disbursementData";
  @SerializedName(SERIALIZED_NAME_DISBURSEMENT_DATA)
  private List<PostLoansDisbursementData> disbursementData;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EXPECTED_DISBURSEMENT_DATE = "expectedDisbursementDate";
  @SerializedName(SERIALIZED_NAME_EXPECTED_DISBURSEMENT_DATE)
  private String expectedDisbursementDate;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FIXED_EMI_AMOUNT = "fixedEmiAmount";
  @SerializedName(SERIALIZED_NAME_FIXED_EMI_AMOUNT)
  private BigDecimal fixedEmiAmount;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED = "graceOnInterestCharged";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED)
  private Integer graceOnInterestCharged;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private Integer interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private Integer interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private BigDecimal interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private Integer interestType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private String loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_TERM_FREQUENCY = "loanTermFrequency";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_FREQUENCY)
  private Integer loanTermFrequency;

  public static final String SERIALIZED_NAME_LOAN_TERM_FREQUENCY_TYPE = "loanTermFrequencyType";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_FREQUENCY_TYPE)
  private Integer loanTermFrequencyType;

  public static final String SERIALIZED_NAME_LOAN_TYPE = "loanType";
  @SerializedName(SERIALIZED_NAME_LOAN_TYPE)
  private String loanType;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE = "maxOutstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE)
  private BigDecimal maxOutstandingLoanBalance;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private BigDecimal principal;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private Integer repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENTS_STARTING_FROM_DATE = "repaymentsStartingFromDate";
  @SerializedName(SERIALIZED_NAME_REPAYMENTS_STARTING_FROM_DATE)
  private LocalDate repaymentsStartingFromDate;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private String submittedOnDate;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public PostLoansRequest() {
  }

  public PostLoansRequest amortizationType(Integer amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public Integer getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(Integer amortizationType) {
    this.amortizationType = amortizationType;
  }

  public PostLoansRequest charges(List<PostLoansRequestChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public PostLoansRequest addChargesItem(PostLoansRequestChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<PostLoansRequestChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<PostLoansRequestChargeData> charges) {
    this.charges = charges;
  }

  public PostLoansRequest clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public PostLoansRequest dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public PostLoansRequest daysInYearType(DaysInYearTypeEnum daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public DaysInYearTypeEnum getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(DaysInYearTypeEnum daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public PostLoansRequest disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public PostLoansRequest disbursementData(List<PostLoansDisbursementData> disbursementData) {
    
    this.disbursementData = disbursementData;
    return this;
  }

  public PostLoansRequest addDisbursementDataItem(PostLoansDisbursementData disbursementDataItem) {
    if (this.disbursementData == null) {
      this.disbursementData = new ArrayList<>();
    }
    this.disbursementData.add(disbursementDataItem);
    return this;
  }

  /**
   * List of PostLoansDisbursementData
   * @return disbursementData
   */
  @javax.annotation.Nullable

  public List<PostLoansDisbursementData> getDisbursementData() {
    return disbursementData;
  }


  public void setDisbursementData(List<PostLoansDisbursementData> disbursementData) {
    this.disbursementData = disbursementData;
  }

  public PostLoansRequest enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public PostLoansRequest enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public PostLoansRequest enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public PostLoansRequest expectedDisbursementDate(String expectedDisbursementDate) {
    
    this.expectedDisbursementDate = expectedDisbursementDate;
    return this;
  }

  /**
   * Get expectedDisbursementDate
   * @return expectedDisbursementDate
   */
  @javax.annotation.Nullable

  public String getExpectedDisbursementDate() {
    return expectedDisbursementDate;
  }


  public void setExpectedDisbursementDate(String expectedDisbursementDate) {
    this.expectedDisbursementDate = expectedDisbursementDate;
  }

  public PostLoansRequest externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public PostLoansRequest fixedEmiAmount(BigDecimal fixedEmiAmount) {
    
    this.fixedEmiAmount = fixedEmiAmount;
    return this;
  }

  /**
   * Get fixedEmiAmount
   * @return fixedEmiAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedEmiAmount() {
    return fixedEmiAmount;
  }


  public void setFixedEmiAmount(BigDecimal fixedEmiAmount) {
    this.fixedEmiAmount = fixedEmiAmount;
  }

  public PostLoansRequest fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public PostLoansRequest fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public PostLoansRequest graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public PostLoansRequest graceOnInterestCharged(Integer graceOnInterestCharged) {
    
    this.graceOnInterestCharged = graceOnInterestCharged;
    return this;
  }

  /**
   * Get graceOnInterestCharged
   * @return graceOnInterestCharged
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestCharged() {
    return graceOnInterestCharged;
  }


  public void setGraceOnInterestCharged(Integer graceOnInterestCharged) {
    this.graceOnInterestCharged = graceOnInterestCharged;
  }

  public PostLoansRequest graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public PostLoansRequest graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public PostLoansRequest interestCalculationPeriodType(Integer interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(Integer interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public PostLoansRequest interestRateFrequencyType(Integer interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(Integer interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public PostLoansRequest interestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public PostLoansRequest interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public PostLoansRequest interestType(Integer interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public Integer getInterestType() {
    return interestType;
  }


  public void setInterestType(Integer interestType) {
    this.interestType = interestType;
  }

  public PostLoansRequest loanScheduleProcessingType(String loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(String loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public PostLoansRequest loanTermFrequency(Integer loanTermFrequency) {
    
    this.loanTermFrequency = loanTermFrequency;
    return this;
  }

  /**
   * Get loanTermFrequency
   * @return loanTermFrequency
   */
  @javax.annotation.Nullable

  public Integer getLoanTermFrequency() {
    return loanTermFrequency;
  }


  public void setLoanTermFrequency(Integer loanTermFrequency) {
    this.loanTermFrequency = loanTermFrequency;
  }

  public PostLoansRequest loanTermFrequencyType(Integer loanTermFrequencyType) {
    
    this.loanTermFrequencyType = loanTermFrequencyType;
    return this;
  }

  /**
   * Get loanTermFrequencyType
   * @return loanTermFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getLoanTermFrequencyType() {
    return loanTermFrequencyType;
  }


  public void setLoanTermFrequencyType(Integer loanTermFrequencyType) {
    this.loanTermFrequencyType = loanTermFrequencyType;
  }

  public PostLoansRequest loanType(String loanType) {
    
    this.loanType = loanType;
    return this;
  }

  /**
   * Get loanType
   * @return loanType
   */
  @javax.annotation.Nullable

  public String getLoanType() {
    return loanType;
  }


  public void setLoanType(String loanType) {
    this.loanType = loanType;
  }

  public PostLoansRequest locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public PostLoansRequest maxOutstandingLoanBalance(BigDecimal maxOutstandingLoanBalance) {
    
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
    return this;
  }

  /**
   * Maximum allowed outstanding balance
   * @return maxOutstandingLoanBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxOutstandingLoanBalance() {
    return maxOutstandingLoanBalance;
  }


  public void setMaxOutstandingLoanBalance(BigDecimal maxOutstandingLoanBalance) {
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
  }

  public PostLoansRequest numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public PostLoansRequest principal(BigDecimal principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipal() {
    return principal;
  }


  public void setPrincipal(BigDecimal principal) {
    this.principal = principal;
  }

  public PostLoansRequest productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public PostLoansRequest repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public PostLoansRequest repaymentFrequencyType(Integer repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(Integer repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public PostLoansRequest repaymentsStartingFromDate(LocalDate repaymentsStartingFromDate) {
    
    this.repaymentsStartingFromDate = repaymentsStartingFromDate;
    return this;
  }

  /**
   * Get repaymentsStartingFromDate
   * @return repaymentsStartingFromDate
   */
  @javax.annotation.Nullable

  public LocalDate getRepaymentsStartingFromDate() {
    return repaymentsStartingFromDate;
  }


  public void setRepaymentsStartingFromDate(LocalDate repaymentsStartingFromDate) {
    this.repaymentsStartingFromDate = repaymentsStartingFromDate;
  }

  public PostLoansRequest submittedOnDate(String submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public String getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(String submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public PostLoansRequest transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PostLoansRequest postLoansRequest = (PostLoansRequest) o;
    return Objects.equals(this.amortizationType, postLoansRequest.amortizationType) &&
        Objects.equals(this.charges, postLoansRequest.charges) &&
        Objects.equals(this.clientId, postLoansRequest.clientId) &&
        Objects.equals(this.dateFormat, postLoansRequest.dateFormat) &&
        Objects.equals(this.daysInYearType, postLoansRequest.daysInYearType) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, postLoansRequest.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.disbursementData, postLoansRequest.disbursementData) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, postLoansRequest.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableDownPayment, postLoansRequest.enableDownPayment) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, postLoansRequest.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.expectedDisbursementDate, postLoansRequest.expectedDisbursementDate) &&
        Objects.equals(this.externalId, postLoansRequest.externalId) &&
        Objects.equals(this.fixedEmiAmount, postLoansRequest.fixedEmiAmount) &&
        Objects.equals(this.fixedLength, postLoansRequest.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, postLoansRequest.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.graceOnArrearsAgeing, postLoansRequest.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestCharged, postLoansRequest.graceOnInterestCharged) &&
        Objects.equals(this.graceOnInterestPayment, postLoansRequest.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, postLoansRequest.graceOnPrincipalPayment) &&
        Objects.equals(this.interestCalculationPeriodType, postLoansRequest.interestCalculationPeriodType) &&
        Objects.equals(this.interestRateFrequencyType, postLoansRequest.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, postLoansRequest.interestRatePerPeriod) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, postLoansRequest.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, postLoansRequest.interestType) &&
        Objects.equals(this.loanScheduleProcessingType, postLoansRequest.loanScheduleProcessingType) &&
        Objects.equals(this.loanTermFrequency, postLoansRequest.loanTermFrequency) &&
        Objects.equals(this.loanTermFrequencyType, postLoansRequest.loanTermFrequencyType) &&
        Objects.equals(this.loanType, postLoansRequest.loanType) &&
        Objects.equals(this.locale, postLoansRequest.locale) &&
        Objects.equals(this.maxOutstandingLoanBalance, postLoansRequest.maxOutstandingLoanBalance) &&
        Objects.equals(this.numberOfRepayments, postLoansRequest.numberOfRepayments) &&
        Objects.equals(this.principal, postLoansRequest.principal) &&
        Objects.equals(this.productId, postLoansRequest.productId) &&
        Objects.equals(this.repaymentEvery, postLoansRequest.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, postLoansRequest.repaymentFrequencyType) &&
        Objects.equals(this.repaymentsStartingFromDate, postLoansRequest.repaymentsStartingFromDate) &&
        Objects.equals(this.submittedOnDate, postLoansRequest.submittedOnDate) &&
        Objects.equals(this.transactionProcessingStrategyCode, postLoansRequest.transactionProcessingStrategyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amortizationType, charges, clientId, dateFormat, daysInYearType, disbursedAmountPercentageForDownPayment, disbursementData, enableAutoRepaymentForDownPayment, enableDownPayment, enableInstallmentLevelDelinquency, expectedDisbursementDate, externalId, fixedEmiAmount, fixedLength, fixedPrincipalPercentagePerInstallment, graceOnArrearsAgeing, graceOnInterestCharged, graceOnInterestPayment, graceOnPrincipalPayment, interestCalculationPeriodType, interestRateFrequencyType, interestRatePerPeriod, interestRecognitionOnDisbursementDate, interestType, loanScheduleProcessingType, loanTermFrequency, loanTermFrequencyType, loanType, locale, maxOutstandingLoanBalance, numberOfRepayments, principal, productId, repaymentEvery, repaymentFrequencyType, repaymentsStartingFromDate, submittedOnDate, transactionProcessingStrategyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PostLoansRequest {\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    disbursementData: ").append(toIndentedString(disbursementData)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    expectedDisbursementDate: ").append(toIndentedString(expectedDisbursementDate)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    fixedEmiAmount: ").append(toIndentedString(fixedEmiAmount)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestCharged: ").append(toIndentedString(graceOnInterestCharged)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanTermFrequency: ").append(toIndentedString(loanTermFrequency)).append("\n");
    sb.append("    loanTermFrequencyType: ").append(toIndentedString(loanTermFrequencyType)).append("\n");
    sb.append("    loanType: ").append(toIndentedString(loanType)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    maxOutstandingLoanBalance: ").append(toIndentedString(maxOutstandingLoanBalance)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentsStartingFromDate: ").append(toIndentedString(repaymentsStartingFromDate)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

