package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.AdvancedPaymentData;
import org.apache.fineract.client.models.CampaignPreviewData;
import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.CommandWrapper;
import java.io.File;
import org.apache.fineract.client.models.SmsCampaignData;
import org.apache.fineract.client.models.SmsCampaignPreviewDto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DefaultApi {
    /**
    * 
    * 
        * @param resourceId  (required)
        * @param command  (optional)
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/email/campaign/{resourceId}")
    Call<String> activate(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Query("command") String command, @retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param creditBureauId creditBureauId (optional)
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @POST("v1/creditBureauIntegration/addCreditReport")
    Call<String> addCreditReport(@retrofit2.http.Query("creditBureauId") Long creditBureauId, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * 
    * 
        * @param entity  (required)
        * @param entityId  (required)
        * @param contentLength  (optional)
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @POST("v1/{entity}/{entityId}/images")
    Call<String> addNewClientImage1(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Header("Content-Length") Long contentLength, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/email")
    Call<String> create1(@retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/email/campaign")
    Call<String> createCampaign(@retrofit2.http.Body String body);

    /**
    * Create a SMS Campaign
    * Mandatory Fields campaignName, campaignType, triggerType, providerId, runReportId, message  Mandatory Fields for Cash based on selected report id paramValue in json format
        * @param commandWrapper  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/smscampaigns")
    Call<CommandProcessingResult> createCampaign1(@retrofit2.http.Body CommandWrapper commandWrapper);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;String&gt;
    */
    @DELETE("v1/email/{resourceId}")
    Call<String> delete1(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;String&gt;
    */
    @DELETE("v1/email/campaign/{resourceId}")
    Call<String> delete2(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * Delete a SMS Campaign
    * Note: Only closed SMS Campaigns can be deleted
        * @param campaignId  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @DELETE("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> delete3(@retrofit2.http.Path("campaignId") Long campaignId);

    /**
    * 
    * 
        * @param transactionId  (required)
    * @return Call&lt;String&gt;
    */
    @DELETE("v1/officetransactions/{transactionId}")
    Call<String> delete8(@retrofit2.http.Path("transactionId") Long transactionId);

    /**
    * 
    * 
    * @return Call&lt;Void&gt;
    */
    @DELETE("v1/internal/externalevents")
    Call<Void> deleteAllExternalEvents();

    /**
    * 
    * 
        * @param entity  (required)
        * @param entityId  (required)
    * @return Call&lt;String&gt;
    */
    @DELETE("v1/{entity}/{entityId}/images")
    Call<String> deleteClientImage(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId);

    /**
    * 
    * 
        * @param creditBureauId creditBureauId (required)
    * @return Call&lt;String&gt;
    */
    @DELETE("v1/creditBureauIntegration/deleteCreditReport/{creditBureauId}")
    Call<String> deleteCreditReport(@retrofit2.http.Path("creditBureauId") Long creditBureauId);

    /**
    * 
    * 
        * @param body Fetch credit report (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/creditBureauIntegration/creditReport")
    Call<String> fetchCreditReport(@retrofit2.http.Body Object body);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/echo")
    Call<String> get();

    /**
    * 
    * 
        * @param loanId  (required)
    * @return Call&lt;List&lt;AdvancedPaymentData&gt;&gt;
    */
    @GET("v1/internal/loan/{loanId}/advanced-payment-allocation-rules")
    Call<List<AdvancedPaymentData>> getAdvancedPaymentAllocationRulesOfLoan(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * 
    * 
        * @param idempotencyKey  (optional)
        * @param type  (optional)
        * @param category  (optional)
        * @param aggregateRootId  (optional)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/externalevents")
    Call<String> getAllExternalEvents(@retrofit2.http.Query("idempotencyKey") String idempotencyKey, @retrofit2.http.Query("type") String type, @retrofit2.http.Query("category") String category, @retrofit2.http.Query("aggregateRootId") Long aggregateRootId);

    /**
    * 
    * 
        * @param clientId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/client/{clientId}/audit")
    Call<String> getClientAuditFields(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * 
    * 
        * @param partitionSize  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/cob/partitions/{partitionSize}")
    Call<String> getCobPartitions(@retrofit2.http.Path("partitionSize") Integer partitionSize);

    /**
    * 
    * 
        * @param path  (required)
    * @return Call&lt;Void&gt;
    */
    @GET("application.wadl/{path}")
    Call<Void> getExternalGrammar(@retrofit2.http.Path("path") String path);

    /**
    * 
    * 
        * @param loanId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/loan/{loanId}/audit")
    Call<String> getLoanAuditFields(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * 
    * 
        * @param loanId  (required)
        * @param transactionId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/loan/{loanId}/transaction/{transactionId}/audit")
    Call<String> getLoanTransactionAuditFields(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId);

    /**
    * 
    * 
        * @param statusId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/loan/status/{statusId}")
    Call<String> getLoansByStatus(@retrofit2.http.Path("statusId") Integer statusId);

    /**
    * 
    * 
        * @param creditBureauId creditBureauId (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/creditBureauIntegration/creditReport/{creditBureauId}")
    Call<String> getSavedCreditReport(@retrofit2.http.Path("creditBureauId") Long creditBureauId);

    /**
    * 
    * 
    * @return Call&lt;Void&gt;
    */
    @GET("application.wadl")
    Call<Void> getWadl();

    /**
    * SMS Campaign
    * Activates | Deactivates | Reactivates
        * @param campaignId  (required)
        * @param command  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @POST("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> handleCommands(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Query("command") String command);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/officetransactions/template")
    Call<String> newOfficeTransactionDetails();

    /**
    * 
    * 
        * @param loanId  (required)
        * @param lockOwner  (required)
        * @param body  (optional)
    * @return Call&lt;Void&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/internal/loans/{loanId}/place-lock/{lockOwner}")
    Call<Void> placeLockOnLoanAccount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("lockOwner") String lockOwner, @retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/email/campaign/preview")
    Call<String> preview(@retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param smsCampaignPreviewDto  (optional)
    * @return Call&lt;CampaignPreviewData&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/smscampaigns/preview")
    Call<CampaignPreviewData> preview1(@retrofit2.http.Body SmsCampaignPreviewDto smsCampaignPreviewDto);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/configuration")
    Call<String> retrieveAll5();

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/twofactor/configure")
    Call<String> retrieveAll9();

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/campaign")
    Call<String> retrieveAllCampaign();

    /**
    * 
    * 
        * @param sqlSearch  (optional)
        * @param offset  (optional)
        * @param limit  (optional)
        * @param status  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
        * @param fromDate  (optional)
        * @param toDate  (optional)
        * @param locale  (optional)
        * @param dateFormat  (optional)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/messageByStatus")
    Call<String> retrieveAllEmailByStatus(@retrofit2.http.Query("sqlSearch") String sqlSearch, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("status") Integer status, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("fromDate") Object fromDate, @retrofit2.http.Query("toDate") Object toDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/email")
    Call<String> retrieveAllEmails();

    /**
    * List SMS Campaigns
    * Example Requests:  smscampaigns
        * @param offset  (optional)
        * @param limit  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
    * @return Call&lt;SmsCampaignData&gt;
    */
    @GET("v1/smscampaigns")
    Call<SmsCampaignData> retrieveAllEmails1(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder);

    /**
    * Retrieve a SMS Campaign
    * Example Requests:  smscampaigns/1 
        * @param resourceId  (required)
    * @return Call&lt;SmsCampaignData&gt;
    */
    @GET("v1/smscampaigns/{resourceId}")
    Call<SmsCampaignData> retrieveCampaign(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param sqlSearch  (optional)
        * @param offset  (optional)
        * @param limit  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/failedEmail")
    Call<String> retrieveFailedEmail(@retrofit2.http.Query("sqlSearch") String sqlSearch, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder);

    /**
    * 
    * 
        * @param entity  (required)
        * @param entityId  (required)
        * @param maxWidth  (optional)
        * @param maxHeight  (optional)
        * @param output  (optional)
        * @param accept  (optional)
    * @return Call&lt;Void&gt;
    */
    @GET("v1/{entity}/{entityId}/images")
    Call<Void> retrieveImage(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Query("maxWidth") Integer maxWidth, @retrofit2.http.Query("maxHeight") Integer maxHeight, @retrofit2.http.Query("output") String output, @retrofit2.http.Header("Accept") String accept);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/officetransactions")
    Call<String> retrieveOfficeTransactions();

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/{resourceId}")
    Call<String> retrieveOne1(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/campaign/{resourceId}")
    Call<String> retrieveOneCampaign(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param resourceId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/campaign/template/{resourceId}")
    Call<String> retrieveOneTemplate(@retrofit2.http.Path("resourceId") Long resourceId);

    /**
    * 
    * 
        * @param offset  (optional)
        * @param limit  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/pendingEmail")
    Call<String> retrievePendingEmail(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder);

    /**
    * 
    * 
        * @param offset  (optional)
        * @param limit  (optional)
        * @param orderBy  (optional)
        * @param sortOrder  (optional)
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/sentEmail")
    Call<String> retrieveSentEmail(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder);

    /**
    * 
    * 
        * @param creditBureauId creditBureauId (optional)
        * @param nationalId nationalId (optional)
    * @return Call&lt;String&gt;
    */
    @POST("v1/creditBureauIntegration/saveCreditReport")
    Call<String> saveCreditReport(@retrofit2.http.Query("creditBureauId") Long creditBureauId, @retrofit2.http.Query("nationalId") String nationalId);

    /**
    * 
    * 
    * @return Call&lt;String&gt;
    */
    @GET("v1/email/campaign/template")
    Call<String> template1();

    /**
    * Retrieve a SMS Campaign
    * Example Requests:  smscampaigns/1   smscampaigns/1?template&#x3D;true   smscampaigns/template
    * @return Call&lt;SmsCampaignData&gt;
    */
    @GET("v1/smscampaigns/template")
    Call<SmsCampaignData> template2();

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/officetransactions")
    Call<String> transferMoneyFrom(@retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param resourceId  (required)
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/email/{resourceId}")
    Call<String> update2(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param resourceId  (required)
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/email/campaign/{resourceId}")
    Call<String> updateCampaign(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body String body);

    /**
    * Update a Campaign
    * 
        * @param campaignId  (required)
        * @param commandWrapper  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> updateCampaign1(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Body CommandWrapper commandWrapper);

    /**
    * 
    * 
        * @param entity  (required)
        * @param entityId  (required)
        * @param contentLength  (optional)
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @PUT("v1/{entity}/{entityId}/images")
    Call<String> updateClientImage1(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Header("Content-Length") Long contentLength, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/email/configuration")
    Call<String> updateConfiguration(@retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param body  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/twofactor/configure")
    Call<String> updateConfiguration3(@retrofit2.http.Body String body);

    /**
    * 
    * 
        * @param configName  (required)
        * @param configValue  (required)
    * @return Call&lt;Void&gt;
    */
    @PUT("v1/internal/configurations/name/{configName}/value/{configValue}")
    Call<Void> updateGlobalConfiguration(@retrofit2.http.Path("configName") String configName, @retrofit2.http.Path("configValue") Long configValue);

    /**
    * 
    * 
        * @param loanId  (required)
        * @param body  (optional)
    * @return Call&lt;Void&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body String body);


        /**
        * 
        * 
            * @param resourceId  (required)
            * @param command  (optional)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/{resourceId}")
    Call<String> activate(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Query("command") String command);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email")
    Call<String> create1();
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign")
    Call<String> createCampaign();
        /**
        * 
        * 
            * @param body Fetch credit report (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/creditBureauIntegration/creditReport")
    Call<String> fetchCreditReport();
        /**
        * 
        * 
            * @param loanId  (required)
            * @param lockOwner  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/loans/{loanId}/place-lock/{lockOwner}")
    Call<Void> placeLockOnLoanAccount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("lockOwner") String lockOwner);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/preview")
    Call<String> preview();
        /**
        * 
        * 
            * @param smsCampaignPreviewDto  (optional)
        * @return Call&lt;CampaignPreviewData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/smscampaigns/preview")
    Call<CampaignPreviewData> preview1();
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/officetransactions")
    Call<String> transferMoneyFrom();
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/{resourceId}")
    Call<String> update2(@retrofit2.http.Path("resourceId") Long resourceId);
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/campaign/{resourceId}")
    Call<String> updateCampaign(@retrofit2.http.Path("resourceId") Long resourceId);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/configuration")
    Call<String> updateConfiguration();
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/twofactor/configure")
    Call<String> updateConfiguration3();
        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId);

        /**
        * 
        * 
            * @param resourceId  (required)
            * @param command  (optional)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/{resourceId}")
    Call<String> activate(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Query("command") String command, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param creditBureauId creditBureauId (optional)
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @POST("v1/creditBureauIntegration/addCreditReport")
    Call<String> addCreditReport(@retrofit2.http.Query("creditBureauId") Long creditBureauId, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entity  (required)
            * @param entityId  (required)
            * @param contentLength  (optional)
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @POST("v1/{entity}/{entityId}/images")
    Call<String> addNewClientImage1(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Header("Content-Length") Long contentLength, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email")
    Call<String> create1(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign")
    Call<String> createCampaign(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * Create a SMS Campaign
        * Mandatory Fields campaignName, campaignType, triggerType, providerId, runReportId, message  Mandatory Fields for Cash based on selected report id paramValue in json format
            * @param commandWrapper  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/smscampaigns")
    Call<CommandProcessingResult> createCampaign1(@retrofit2.http.Body CommandWrapper commandWrapper, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;String&gt;
        */
    @DELETE("v1/email/{resourceId}")
    Call<String> delete1(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;String&gt;
        */
    @DELETE("v1/email/campaign/{resourceId}")
    Call<String> delete2(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a SMS Campaign
        * Note: Only closed SMS Campaigns can be deleted
            * @param campaignId  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @DELETE("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> delete3(@retrofit2.http.Path("campaignId") Long campaignId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param transactionId  (required)
        * @return Call&lt;String&gt;
        */
    @DELETE("v1/officetransactions/{transactionId}")
    Call<String> delete8(@retrofit2.http.Path("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;Void&gt;
        */
    @DELETE("v1/internal/externalevents")
    Call<Void> deleteAllExternalEvents(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entity  (required)
            * @param entityId  (required)
        * @return Call&lt;String&gt;
        */
    @DELETE("v1/{entity}/{entityId}/images")
    Call<String> deleteClientImage(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param creditBureauId creditBureauId (required)
        * @return Call&lt;String&gt;
        */
    @DELETE("v1/creditBureauIntegration/deleteCreditReport/{creditBureauId}")
    Call<String> deleteCreditReport(@retrofit2.http.Path("creditBureauId") Long creditBureauId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body Fetch credit report (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/creditBureauIntegration/creditReport")
    Call<String> fetchCreditReport(@retrofit2.http.Body Object body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/echo")
    Call<String> get(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
        * @return Call&lt;List&lt;AdvancedPaymentData&gt;&gt;
        */
    @GET("v1/internal/loan/{loanId}/advanced-payment-allocation-rules")
    Call<List<AdvancedPaymentData>> getAdvancedPaymentAllocationRulesOfLoan(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param idempotencyKey  (optional)
            * @param type  (optional)
            * @param category  (optional)
            * @param aggregateRootId  (optional)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/externalevents")
    Call<String> getAllExternalEvents(@retrofit2.http.Query("idempotencyKey") String idempotencyKey, @retrofit2.http.Query("type") String type, @retrofit2.http.Query("category") String category, @retrofit2.http.Query("aggregateRootId") Long aggregateRootId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param clientId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/client/{clientId}/audit")
    Call<String> getClientAuditFields(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param partitionSize  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/cob/partitions/{partitionSize}")
    Call<String> getCobPartitions(@retrofit2.http.Path("partitionSize") Integer partitionSize, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param path  (required)
        * @return Call&lt;Void&gt;
        */
    @GET("application.wadl/{path}")
    Call<Void> getExternalGrammar(@retrofit2.http.Path("path") String path, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/loan/{loanId}/audit")
    Call<String> getLoanAuditFields(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
            * @param transactionId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/loan/{loanId}/transaction/{transactionId}/audit")
    Call<String> getLoanTransactionAuditFields(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param statusId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/loan/status/{statusId}")
    Call<String> getLoansByStatus(@retrofit2.http.Path("statusId") Integer statusId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param creditBureauId creditBureauId (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/creditBureauIntegration/creditReport/{creditBureauId}")
    Call<String> getSavedCreditReport(@retrofit2.http.Path("creditBureauId") Long creditBureauId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;Void&gt;
        */
    @GET("application.wadl")
    Call<Void> getWadl(@HeaderMap Map<String, String> headers);

        /**
        * SMS Campaign
        * Activates | Deactivates | Reactivates
            * @param campaignId  (required)
            * @param command  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @POST("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> handleCommands(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/officetransactions/template")
    Call<String> newOfficeTransactionDetails(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
            * @param lockOwner  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/loans/{loanId}/place-lock/{lockOwner}")
    Call<Void> placeLockOnLoanAccount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("lockOwner") String lockOwner, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/preview")
    Call<String> preview(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param smsCampaignPreviewDto  (optional)
        * @return Call&lt;CampaignPreviewData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/smscampaigns/preview")
    Call<CampaignPreviewData> preview1(@retrofit2.http.Body SmsCampaignPreviewDto smsCampaignPreviewDto, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/configuration")
    Call<String> retrieveAll5(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/twofactor/configure")
    Call<String> retrieveAll9(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/campaign")
    Call<String> retrieveAllCampaign(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param sqlSearch  (optional)
            * @param offset  (optional)
            * @param limit  (optional)
            * @param status  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
            * @param fromDate  (optional)
            * @param toDate  (optional)
            * @param locale  (optional)
            * @param dateFormat  (optional)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/messageByStatus")
    Call<String> retrieveAllEmailByStatus(@retrofit2.http.Query("sqlSearch") String sqlSearch, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("status") Integer status, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("fromDate") Object fromDate, @retrofit2.http.Query("toDate") Object toDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/email")
    Call<String> retrieveAllEmails(@HeaderMap Map<String, String> headers);

        /**
        * List SMS Campaigns
        * Example Requests:  smscampaigns
            * @param offset  (optional)
            * @param limit  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
        * @return Call&lt;SmsCampaignData&gt;
        */
    @GET("v1/smscampaigns")
    Call<SmsCampaignData> retrieveAllEmails1(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a SMS Campaign
        * Example Requests:  smscampaigns/1 
            * @param resourceId  (required)
        * @return Call&lt;SmsCampaignData&gt;
        */
    @GET("v1/smscampaigns/{resourceId}")
    Call<SmsCampaignData> retrieveCampaign(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param sqlSearch  (optional)
            * @param offset  (optional)
            * @param limit  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/failedEmail")
    Call<String> retrieveFailedEmail(@retrofit2.http.Query("sqlSearch") String sqlSearch, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entity  (required)
            * @param entityId  (required)
            * @param maxWidth  (optional)
            * @param maxHeight  (optional)
            * @param output  (optional)
            * @param accept  (optional)
        * @return Call&lt;Void&gt;
        */
    @GET("v1/{entity}/{entityId}/images")
    Call<Void> retrieveImage(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Query("maxWidth") Integer maxWidth, @retrofit2.http.Query("maxHeight") Integer maxHeight, @retrofit2.http.Query("output") String output, @retrofit2.http.Header("Accept") String accept, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/officetransactions")
    Call<String> retrieveOfficeTransactions(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/{resourceId}")
    Call<String> retrieveOne1(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/campaign/{resourceId}")
    Call<String> retrieveOneCampaign(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/campaign/template/{resourceId}")
    Call<String> retrieveOneTemplate(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param offset  (optional)
            * @param limit  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/pendingEmail")
    Call<String> retrievePendingEmail(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param offset  (optional)
            * @param limit  (optional)
            * @param orderBy  (optional)
            * @param sortOrder  (optional)
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/sentEmail")
    Call<String> retrieveSentEmail(@retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param creditBureauId creditBureauId (optional)
            * @param nationalId nationalId (optional)
        * @return Call&lt;String&gt;
        */
    @POST("v1/creditBureauIntegration/saveCreditReport")
    Call<String> saveCreditReport(@retrofit2.http.Query("creditBureauId") Long creditBureauId, @retrofit2.http.Query("nationalId") String nationalId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;String&gt;
        */
    @GET("v1/email/campaign/template")
    Call<String> template1(@HeaderMap Map<String, String> headers);

        /**
        * Retrieve a SMS Campaign
        * Example Requests:  smscampaigns/1   smscampaigns/1?template&#x3D;true   smscampaigns/template
        * @return Call&lt;SmsCampaignData&gt;
        */
    @GET("v1/smscampaigns/template")
    Call<SmsCampaignData> template2(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/officetransactions")
    Call<String> transferMoneyFrom(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/{resourceId}")
    Call<String> update2(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/campaign/{resourceId}")
    Call<String> updateCampaign(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * Update a Campaign
        * 
            * @param campaignId  (required)
            * @param commandWrapper  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/smscampaigns/{campaignId}")
    Call<CommandProcessingResult> updateCampaign1(@retrofit2.http.Path("campaignId") Long campaignId, @retrofit2.http.Body CommandWrapper commandWrapper, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param entity  (required)
            * @param entityId  (required)
            * @param contentLength  (optional)
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @PUT("v1/{entity}/{entityId}/images")
    Call<String> updateClientImage1(@retrofit2.http.Path("entity") String entity, @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Header("Content-Length") Long contentLength, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/configuration")
    Call<String> updateConfiguration(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/twofactor/configure")
    Call<String> updateConfiguration3(@retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param configName  (required)
            * @param configValue  (required)
        * @return Call&lt;Void&gt;
        */
    @PUT("v1/internal/configurations/name/{configName}/value/{configValue}")
    Call<Void> updateGlobalConfiguration(@retrofit2.http.Path("configName") String configName, @retrofit2.http.Path("configValue") Long configValue, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param resourceId  (required)
            * @param command  (optional)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/{resourceId}")
    Call<String> activate(@retrofit2.http.Path("resourceId") Long resourceId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email")
    Call<String> create1(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign")
    Call<String> createCampaign(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body Fetch credit report (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/creditBureauIntegration/creditReport")
    Call<String> fetchCreditReport(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param loanId  (required)
            * @param lockOwner  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/loans/{loanId}/place-lock/{lockOwner}")
    Call<Void> placeLockOnLoanAccount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("lockOwner") String lockOwner, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/email/campaign/preview")
    Call<String> preview(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param smsCampaignPreviewDto  (optional)
        * @return Call&lt;CampaignPreviewData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/smscampaigns/preview")
    Call<CampaignPreviewData> preview1(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/officetransactions")
    Call<String> transferMoneyFrom(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/{resourceId}")
    Call<String> update2(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param resourceId  (required)
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/campaign/{resourceId}")
    Call<String> updateCampaign(@retrofit2.http.Path("resourceId") Long resourceId, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/email/configuration")
    Call<String> updateConfiguration(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param body  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/twofactor/configure")
    Call<String> updateConfiguration3(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);
}
