/**
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/. OpenMRS is also distributed under
 * the terms of the Healthcare Disclaimer located at http://openmrs.org/license.
 *
 * Copyright (C) OpenMRS Inc. OpenMRS is a registered trademark and the OpenMRS
 * graphic logo is a trademark of OpenMRS Inc.
 */
package org.openmrs.logic.op;

import org.openmrs.logic.LogicCriteria;

/**
 * The Or operator is a disjunction operator to combine two or more {@link LogicCriteria} objects.<br>
 * <br>
 * Example: <br>
 * - <code>logicService.parse("'CD4 COUNT'").or(logicService.parse("'WEIGHT (KG)'"));</code><br>
 * The above will give us a criteria to check if there's "CD4 COUNT" or "WEIGHT (KG)" observations
 */
public class Or implements LogicalOperator {
	
	@Override
	public String toString() {
		return "OR";
	}
	
}
