/**
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/. OpenMRS is also distributed under
 * the terms of the Healthcare Disclaimer located at http://openmrs.org/license.
 *
 * Copyright (C) OpenMRS Inc. OpenMRS is a registered trademark and the OpenMRS
 * graphic logo is a trademark of OpenMRS Inc.
 */
package org.openmrs.web.filter.util;

/**
 * This class contains all constants that describes names of properties, which are used as keys,
 * when showing localized error messages on pages of install and database wizard
 */
public class ErrorMessageConstants {
	
	private ErrorMessageConstants() {
	}
	
	public static final String ERROR_DB_PSDW_REQ = "install.error.dbPasswd";
	
	public static final String ERROR_DB_DRIVER_CLASS_REQ = "install.error.dbDriverClass";
	
	public static final String ERROR_DB_CONN_REQ = "install.error.dbConn";
	
	public static final String ERROR_DB_DRIVER_REQ = "install.error.dbDriver";
	
	public static final String ERROR_DB_CURR_NAME_REQ = "install.error.dbCurrName";
	
	public static final String ERROR_DB_NEW_NAME_REQ = "install.error.dbNewName";
	
	public static final String ERROR_DB_USER_NAME_REQ = "install.error.dbUserName";
	
	public static final String ERROR_DB_USER_PSWD_REQ = "install.error.dbUserPswd";
	
	public static final String ERROR_DB_CUR_USER_NAME_REQ = "install.error.dbCurUserName";
	
	public static final String ERROR_DB_CUR_USER_PSWD_REQ = "install.error.dbCurUserPswd";
	
	public static final String ERROR_DB_ADM_PSWDS_MATCH = "install.error.adminPswdMatch";
	
	public static final String ERROR_DB_ADM_PSDW_EMPTY = "install.error.adminPswdEmpty";
	
	public static final String ERROR_DB_ADM_PSDW_WEAK = "install.error.adminPswdWeak";
	
	public static final String ERROR_DB_IMPL_ID_REQ = "install.error.implID";
	
	public static final String ERROR_DB_CONN_VERIFY = "install.error.connVerify";
	
	public static final String ERROR_DB_EXEC_SQL = "install.error.execSql";
	
	public static final String ERROR_DB_CREATE_NEW = "install.error.unableCreateDb";
	
	public static final String ERROR_DB_CREATE_DB_USER = "install.error.unableCreateDbUser";
	
	public static final String ERROR_DB_GRANT_PRIV = "install.error.unableGranPrivileges";
	
	public static final String ERROR_DB_CONNECTION_FAIL = "install.error.unableConnect";
	
	public static final String ERROR_DB_IMPORT_TEST_DATA = "install.error.unableImportTestData";
	
	public static final String ERROR_DB_CREATE_TABLES_OR_ADD_DEMO_DATA = "install.error.unableCreateTablesOrAddDemoData";
	
	public static final String ERROR_DB_UPDATE_TO_LATEST = "install.error.unableUpdateToLatest";
	
	public static final String ERROR_DB_UPDATE = "install.error.unableUpdate";
	
	public static final String ERROR_INPUT_REQ = "install.error.inputRequired";
	
	public static final String ERROR_MANDATORY_MOD_REQ = "install.error.mandatoryModuleRequired";
	
	public static final String ERROR_CORE_MOD_REQ = "install.error.coreModuleRequired";
	
	public static final String ERROR_SET_INPL_ID = "install.error.unableSetImplId";
	
	public static final String ERROR_COMPLETE_STARTUP = "install.error.unableCompleteStartup";
	
	public static final String ERROR_UNABLE_COPY_DATA = "install.error.unableCopyData";
	
	public static final String ERROR_UNABLE_CREATE_DB = "install.error.unableCreateDb";
	
	public static final String ERROR_UNABLE_CREATE_DUMP = "install.error.unableCreateDump";
	
	public static final String ERROR_UNABLE_CREATE_ENV = "install.error.unableCreateEnvironment";
	
	public static final String UPDATE_ERROR_COMPLETE_STARTUP = "update.error.unableCompleteStartup";
	
	public static final String UPDATE_ERROR_INPUT_NOT_IMPLEMENTED = "update.error.inpuNotImplemented";
	
	public static final String UPDATE_ERROR_UNABLE = "update.error.unableUpdate";
	
	public static final String UPDATE_ERROR_UNABLE_AUTHENTICATE = "update.error.unableAuthenticate";
	
	public static final String ERROR_DB_UNABLE_TO_ADD_MODULES = "install.error.failedToAddModules";
	
	public static final String ERROR_DB_UNABLE_TO_FETCH_MODULES = "install.error.failedToFetchModules";
}
