/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.action;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log
extends AbstractAction {
    private static final long serialVersionUID = 8238761463376338707L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Log.class);

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfGuardException, CsrfGuard csrfGuard) throws CsrfGuardException {
        String logMessage = this.getParameter("Message");
        logMessage = logMessage.replace("%exception%", String.valueOf(csrfGuardException)).replace("%exception_message%", csrfGuardException.getLocalizedMessage());
        logMessage = logMessage.replace("%remote_ip%", StringUtils.defaultString((String)request.getRemoteAddr())).replace("%remote_host%", StringUtils.defaultString((String)request.getRemoteHost())).replace("%remote_port%", String.valueOf(request.getRemotePort()));
        logMessage = logMessage.replace("%local_ip%", StringUtils.defaultString((String)request.getLocalAddr())).replace("%local_host%", StringUtils.defaultString((String)request.getLocalName())).replace("%local_port%", String.valueOf(request.getLocalPort()));
        logMessage = logMessage.replace("%request_method%", StringUtils.defaultString((String)request.getMethod())).replace("%request_uri%", StringUtils.defaultString((String)request.getRequestURI())).replace("%request_url%", request.getRequestURL().toString());
        logMessage = logMessage.replace("%user%", this.getUserName(request));
        LOGGER.error(logMessage);
    }

    private String getUserName(HttpServletRequest request) {
        Principal userPrincipal;
        String user = request.getRemoteUser();
        if (StringUtils.isBlank((CharSequence)user)) {
            user = (String)request.getAttribute("REMOTE_USER");
        }
        if (StringUtils.isBlank((CharSequence)user) && (userPrincipal = request.getUserPrincipal()) != null) {
            user = userPrincipal.getName();
        }
        if (StringUtils.isBlank((CharSequence)user)) {
            user = "<anonymous>";
        }
        return user;
    }
}

