/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.NMQ_N01_CLOCK_AND_STATISTICS;
import ca.uhn.hl7v2.model.v26.group.NMQ_N01_QRY_WITH_DETAIL;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMQ_N01
extends AbstractMessage {
    public NMQ_N01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public NMQ_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(NMQ_N01_QRY_WITH_DETAIL.class, false, false);
            this.add(NMQ_N01_CLOCK_AND_STATISTICS.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public NMQ_N01_QRY_WITH_DETAIL getQRY_WITH_DETAIL() {
        return (NMQ_N01_QRY_WITH_DETAIL)this.getTyped("QRY_WITH_DETAIL", NMQ_N01_QRY_WITH_DETAIL.class);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS() {
        return (NMQ_N01_CLOCK_AND_STATISTICS)this.getTyped("CLOCK_AND_STATISTICS", NMQ_N01_CLOCK_AND_STATISTICS.class);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS(int rep) {
        return (NMQ_N01_CLOCK_AND_STATISTICS)this.getTyped("CLOCK_AND_STATISTICS", rep, NMQ_N01_CLOCK_AND_STATISTICS.class);
    }

    public int getCLOCK_AND_STATISTICSReps() {
        return this.getReps("CLOCK_AND_STATISTICS");
    }

    public List<NMQ_N01_CLOCK_AND_STATISTICS> getCLOCK_AND_STATISTICSAll() throws HL7Exception {
        return this.getAllAsList("CLOCK_AND_STATISTICS", NMQ_N01_CLOCK_AND_STATISTICS.class);
    }

    public void insertCLOCK_AND_STATISTICS(NMQ_N01_CLOCK_AND_STATISTICS structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATISTICS", (Structure)structure, rep);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS insertCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N01_CLOCK_AND_STATISTICS)super.insertRepetition("CLOCK_AND_STATISTICS", rep);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS removeCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N01_CLOCK_AND_STATISTICS)super.removeRepetition("CLOCK_AND_STATISTICS", rep);
    }
}

