/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.impl;

import java.util.function.BiFunction;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.impl.DepthFilter;
import org.hibernate.search.engine.common.tree.impl.PathFilter;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;

public class TreeFilter {
    private static final TreeFilter ROOT = new TreeFilter(null, null, null, TreeFilterDefinition.includeAll(), null, DepthFilter.unconstrained(), PathFilter.unconstrained());
    private final TreeFilter parent;
    private final MappingElement mappingElement;
    private final String relativePrefix;
    private final TreeFilterDefinition definition;
    private final TreeFilterPathTracker pathTracker;
    private final DepthFilter depthFilter;
    private final PathFilter pathFilter;

    public static TreeFilter root() {
        return ROOT;
    }

    private TreeFilter(TreeFilter parent, MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition, TreeFilterPathTracker pathTracker, DepthFilter depthFilter, PathFilter pathFilter) {
        this.parent = parent;
        this.mappingElement = mappingElement;
        this.relativePrefix = relativePrefix;
        this.definition = definition;
        this.pathTracker = pathTracker;
        this.depthFilter = depthFilter;
        this.pathFilter = pathFilter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "depthFilter=" + this.depthFilter + ",pathFilter=" + this.pathFilter + ",parent=" + this.parent + "]";
    }

    public boolean isPathIncluded(String relativePath) {
        return this.isPathIncludedInternal(0, relativePath, true);
    }

    private boolean isPathIncludedInternal(int relativeDepth, String relativePath, boolean markIncludedAsEncountered) {
        boolean included;
        boolean includedByThis = (this.depthFilter.isEveryPathIncludedAtDepth(relativeDepth) || this.pathFilter.isExplicitlyIncluded(relativePath)) && !this.pathFilter.isExplicitlyExcluded(relativePath);
        boolean includedByParent = true;
        if (includedByThis && this.parent != null) {
            includedByParent = this.parent.isPathIncludedInternal(relativeDepth + 1, this.relativePrefix + relativePath, markIncludedAsEncountered);
        }
        boolean bl = included = includedByParent && includedByThis;
        if ((markIncludedAsEncountered || !included) && this.pathTracker != null) {
            this.pathTracker.markAsEncountered(relativePath, includedByThis);
        }
        return included;
    }

    public boolean isEveryPathExcluded() {
        return !this.isEveryPathIncludedAtDepth(0) && !this.isAnyPathExplicitlyIncluded("", this);
    }

    private boolean isAnyPathExplicitlyIncluded(String prefixToRemove, TreeFilter filter) {
        if (this.definition == null) {
            return false;
        }
        int prefixLength = prefixToRemove.length();
        for (String path : this.definition.includePaths()) {
            String pathWithoutPrefix;
            if (!path.startsWith(prefixToRemove) || !filter.isPathIncludedInternal(0, pathWithoutPrefix = path.substring(prefixLength), false)) continue;
            return true;
        }
        return this.parent != null && this.parent.isAnyPathExplicitlyIncluded(this.relativePrefix + prefixToRemove, filter);
    }

    private boolean isEveryPathIncludedAtDepth(int depth) {
        return this.depthFilter.isEveryPathIncludedAtDepth(depth) && (this.parent == null || this.parent.isEveryPathIncludedAtDepth(depth + 1));
    }

    private String getPathFromSameFilterSinceNoCompositionLimits(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition) {
        if (this.hasCompositionLimits()) {
            return null;
        }
        if (this.definition == null) {
            return null;
        }
        return this.findCycle(mappingElement, relativePrefix, definition);
    }

    private String findCycle(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definitionToBeAdded) {
        String closestCyclePathAndPrefix = null;
        String pathAndPrefixFromCurrentCycleFilter = null;
        String pathAndPrefixFromPreviousCycleFilter = relativePrefix;
        TreeFilter currentFilter = this;
        TreeFilter currentCycleFilter = null;
        TreeFilter previousCycleFilter = this;
        StringBuilder path = new StringBuilder();
        while (currentFilter != null && currentFilter.definition != null) {
            path.insert(0, currentFilter.relativePrefix);
            if (currentFilter.isSame(mappingElement, relativePrefix, definitionToBeAdded)) {
                if (currentCycleFilter != null) {
                    previousCycleFilter = currentCycleFilter.parent;
                    pathAndPrefixFromPreviousCycleFilter = pathAndPrefixFromCurrentCycleFilter;
                }
                pathAndPrefixFromCurrentCycleFilter = path.toString();
                currentCycleFilter = currentFilter;
                if (closestCyclePathAndPrefix == null) {
                    closestCyclePathAndPrefix = pathAndPrefixFromCurrentCycleFilter;
                }
            }
            currentFilter = currentFilter.parent;
        }
        if (pathAndPrefixFromCurrentCycleFilter == null) {
            return null;
        }
        if (!closestCyclePathAndPrefix.contains(".")) {
            return closestCyclePathAndPrefix;
        }
        if (previousCycleFilter.isPotentiallyExcludedPathAndPrefix(pathAndPrefixFromPreviousCycleFilter)) {
            return null;
        }
        return closestCyclePathAndPrefix;
    }

    private boolean isPotentiallyExcludedPathAndPrefix(String pathAndPrefix) {
        String pathWithoutTrailingPrefix;
        if (this.parent == null) {
            return false;
        }
        int lastDotIndex = pathAndPrefix.lastIndexOf(46);
        if (lastDotIndex > 0 && this.pathFilter.isPotentiallyExcluded(pathWithoutTrailingPrefix = pathAndPrefix.substring(0, lastDotIndex))) {
            return true;
        }
        return this.parent.isPotentiallyExcludedPathAndPrefix(this.relativePrefix + pathAndPrefix);
    }

    private boolean isSame(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition) {
        return this.mappingElement != null && this.mappingElement.equals(mappingElement) && this.relativePrefix.equals(relativePrefix) && this.definition.equals(definition);
    }

    public TreeFilter compose(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition, TreeFilterPathTracker pathTracker, BiFunction<MappingElement, String, SearchException> cyclicRecursionExceptionFactory) {
        String cyclicRecursionPath = this.getPathFromSameFilterSinceNoCompositionLimits(mappingElement, relativePrefix, definition);
        if (cyclicRecursionPath != null) {
            cyclicRecursionPath = cyclicRecursionPath + relativePrefix;
            throw cyclicRecursionExceptionFactory.apply(mappingElement, cyclicRecursionPath);
        }
        DepthFilter newDepthFilter = DepthFilter.of(definition.includeDepth());
        PathFilter newPathFilter = PathFilter.of(definition.includePaths(), definition.excludePaths());
        return new TreeFilter(this, mappingElement, relativePrefix, definition, pathTracker, newDepthFilter, newPathFilter);
    }

    private boolean hasCompositionLimits() {
        return this.depthFilter.hasDepthLimit() || this.pathFilter.isAnyPathExplicitlyIncluded() || this.parent != null && this.parent.hasCompositionLimits();
    }
}

