/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.data.impl.InsertionOrder;
import org.hibernate.search.util.common.impl.ToStringStyle;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.CommonEventContextMessages;

public final class RootFailureCollector
implements FailureCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final int FAILURE_LIMIT = 100;
    private final String process;
    private final NonRootFailureCollector delegate;
    private final AtomicInteger failureCount = new AtomicInteger();

    public RootFailureCollector(String process) {
        this.process = process;
        this.delegate = new NonRootFailureCollector(this);
    }

    public void checkNoFailure() {
        if (this.failureCount.get() > 0) {
            String renderedFailures = this.renderFailures();
            throw log.collectedFailures(this.process, renderedFailures);
        }
    }

    private String renderFailures() {
        ToStringStyle style = ToStringStyle.multilineIndentStructure((String)EngineEventContextMessages.INSTANCE.failureReportContextFailuresSeparator(), (String)EngineEventContextMessages.INSTANCE.failureReportContextIndent(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresBulletPoint(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresNoBulletPoint());
        ToStringTreeBuilder builder = new ToStringTreeBuilder(style);
        builder.startObject();
        if (this.failureCount.get() > 100) {
            builder.value((Object)log.collectedFailureLimitReached(this.process, 100, this.failureCount.get()));
        }
        if (this.delegate != null) {
            this.delegate.appendChildrenFailuresTo(builder);
        }
        builder.endObject();
        return builder.toString();
    }

    @Override
    public ContextualFailureCollector withContext(EventContext context) {
        return this.delegate.withContext(context);
    }

    @Override
    public ContextualFailureCollector withContext(EventContextElement contextElement) {
        return this.delegate.withContext(contextElement);
    }

    private boolean shouldAddFailure() {
        return this.failureCount.incrementAndGet() <= 100;
    }

    private static class NonRootFailureCollector
    implements FailureCollector {
        protected final RootFailureCollector root;
        private final InsertionOrder<EventContextElement> childrenInsertionOrder = new InsertionOrder();
        private final Map<InsertionOrder.Key<EventContextElement>, ContextualFailureCollectorImpl> children = new ConcurrentSkipListMap<InsertionOrder.Key<EventContextElement>, ContextualFailureCollectorImpl>();

        private NonRootFailureCollector(RootFailureCollector root) {
            this.root = root;
        }

        protected NonRootFailureCollector(NonRootFailureCollector parent) {
            this.root = parent.root;
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContext context) {
            if (context == null) {
                return this.withDefaultContext();
            }
            List elements = context.elements();
            try {
                NonRootFailureCollector failureCollector = this;
                for (EventContextElement contextElement : elements) {
                    failureCollector = failureCollector.withContext(contextElement);
                }
                return (ContextualFailureCollectorImpl)failureCollector;
            }
            catch (RuntimeException e) {
                log.exceptionWhileCollectingFailure(e.getMessage(), e);
                return this.withDefaultContext();
            }
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContextElement contextElement) {
            if (contextElement == null) {
                return this.withDefaultContext();
            }
            return this.children.computeIfAbsent((InsertionOrder.Key<EventContextElement>)this.childrenInsertionOrder.wrapKey((Object)contextElement), key -> new ContextualFailureCollectorImpl(this, (EventContextElement)key.get()));
        }

        ContextualFailureCollectorImpl withDefaultContext() {
            return this.withContext(EventContexts.defaultContext());
        }

        void appendContextTo(StringJoiner joiner) {
        }

        final void appendChildrenFailuresTo(ToStringTreeBuilder builder) {
            for (ContextualFailureCollectorImpl child : this.children.values()) {
                if (!child.hasFailure()) continue;
                child.appendFailuresTo(builder);
            }
        }

        final Collection<ContextualFailureCollectorImpl> children() {
            return this.children.values();
        }
    }

    private static class ContextualFailureCollectorImpl
    extends NonRootFailureCollector
    implements ContextualFailureCollector {
        private final NonRootFailureCollector parent;
        private final EventContextElement context;
        private final Collection<String> failureMessages = new ConcurrentLinkedDeque<String>();

        private ContextualFailureCollectorImpl(NonRootFailureCollector parent, EventContextElement context) {
            super(parent);
            this.parent = parent;
            this.context = context;
        }

        @Override
        public boolean hasFailure() {
            if (!this.failureMessages.isEmpty()) {
                return true;
            }
            for (ContextualFailureCollectorImpl child : this.children()) {
                if (!child.hasFailure()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Throwable t) {
            if (t instanceof SearchException) {
                SearchException e = (SearchException)t;
                ContextualFailureCollectorImpl failureCollector = this;
                EventContext eventContext = e.context();
                if (eventContext != null) {
                    failureCollector = failureCollector.withContext(e.context());
                }
                failureCollector.doAdd((Throwable)e, e.messageWithoutContext());
            } else {
                this.doAdd(t, t.getMessage());
            }
        }

        @Override
        public void add(String failureMessage) {
            this.doAdd(failureMessage);
        }

        @Override
        ContextualFailureCollectorImpl withDefaultContext() {
            return this;
        }

        @Override
        void appendContextTo(StringJoiner joiner) {
            this.parent.appendContextTo(joiner);
            joiner.add(this.context.render());
        }

        void appendFailuresTo(ToStringTreeBuilder builder) {
            builder.startObject(this.context.render());
            if (!this.failureMessages.isEmpty()) {
                builder.attribute(EngineEventContextMessages.INSTANCE.failureReportFailures(), this.failureMessages);
            }
            this.appendChildrenFailuresTo(builder);
            builder.endObject();
        }

        private void doAdd(Throwable failure, String failureMessage) {
            StringJoiner contextJoiner = new StringJoiner(CommonEventContextMessages.INSTANCE.contextSeparator());
            this.appendContextTo(contextJoiner);
            log.newCollectedFailure(this.root.process, contextJoiner.toString(), failure);
            this.doAdd(failureMessage);
        }

        private void doAdd(String failureMessage) {
            if (this.root.shouldAddFailure()) {
                this.failureMessages.add(failureMessage);
            }
        }
    }
}

