/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;

public final class BeanBinder
implements IdentifierBinder,
ValueBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanReference<?> beanReference;

    public BeanBinder(BeanReference<?> beanReference) {
        this.beanReference = beanReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.beanReference + "]";
    }

    @Override
    public void bind(IdentifierBindingContext<?> context) {
        BeanHolder<IdentifierBridge> bridgeHolder = this.doBuild(context.beanResolver(), IdentifierBridge.class);
        try {
            this.doBind(bridgeHolder, context);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(bridgeHolder, BeanHolder::get).push(bridgeHolder);
            throw e;
        }
    }

    @Override
    public void bind(ValueBindingContext<?> context) {
        BeanHolder<ValueBridge> bridgeHolder = this.doBuild(context.beanResolver(), ValueBridge.class);
        try {
            this.doBind(bridgeHolder, context);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(bridgeHolder, BeanHolder::get).push(bridgeHolder);
            throw e;
        }
    }

    private <B extends IdentifierBridge<I>, I> void doBind(BeanHolder<B> bridgeHolder, IdentifierBindingContext<?> context) {
        IdentifierBridge bridge = (IdentifierBridge)bridgeHolder.get();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Type typeArgument = (Type)bridgeTypeContext.resolveTypeArgument(IdentifierBridge.class, 0).orElseThrow(() -> new AssertionFailure("Could not auto-detect the input type for identifier bridge '" + bridge + "'."));
        if (!(typeArgument instanceof Class)) {
            throw log.invalidGenericParameterToInferIdentifierType(bridge, typeArgument);
        }
        context.bridge((Class)typeArgument, bridge);
    }

    private <B extends ValueBridge<V, F>, V, F> void doBind(BeanHolder<B> bridgeHolder, ValueBindingContext<?> context) {
        ValueBridge bridge = (ValueBridge)bridgeHolder.get();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Type typeArgument = (Type)bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 0).orElseThrow(() -> new AssertionFailure("Could not auto-detect the input type for value bridge '" + bridge + "'."));
        if (!(typeArgument instanceof Class)) {
            throw log.invalidGenericParameterToInferValueType(bridge, typeArgument);
        }
        context.bridge((Class)typeArgument, bridge);
    }

    private <T> BeanHolder<? extends T> doBuild(BeanResolver beanResolver, Class<T> expectedType) {
        return this.beanReference.asSubTypeOf(expectedType).resolve(beanResolver);
    }
}

