<?php

namespace Modules\Academic\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSubjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user()->role === 'admin';
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $subject = $this->route('subject');

        return [
            'name' => [
                'required',
                'string',
                'max:255'
            ],
            'code' => [
                'required',
                'string',
                'max:20',
                'unique:subjects,code,' . $subject->id
            ],
            'description' => [
                'nullable',
                'string',
                'max:500'
            ],
            'is_active' => [
                'boolean'
            ],
        ];
    }

    /**
     * Get custom validation messages.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'Please enter the subject name.',
            'code.required' => 'Please enter the subject code.',
            'code.unique' => 'A subject with this code already exists.',
            'classroom_id.required' => 'Please select a classroom.',
            'classroom_id.exists' => 'The selected classroom does not exist.',
            'teacher_id.required' => 'Please select a teacher.',
            'teacher_id.exists' => 'The selected user does not exist.',
            'credits.min' => 'Credits must be at least 1.',
            'credits.max' => 'Credits cannot exceed 10.',
        ];
    }


}
