<?php

namespace Modules\Academic\Policies;

use App\Models\User;
use Modules\Academic\Models\ExamType;
use Illuminate\Auth\Access\HandlesAuthorization;

class ExamTypePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any exam types.
     */
    public function viewAny(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can view the exam type.
     */
    public function view(User $user, ExamType $examType): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can create exam types.
     */
    public function create(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can update the exam type.
     */
    public function update(User $user, ExamType $examType): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can delete the exam type.
     */
    public function delete(User $user, ExamType $examType): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can toggle status.
     */
    public function toggleStatus(User $user, ExamType $examType): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can perform bulk operations.
     */
    public function bulkOperations(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can import exam types.
     */
    public function import(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can export exam types.
     */
    public function export(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can view statistics.
     */
    public function viewStatistics(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }
}
