<?php

use Illuminate\Support\Facades\Route;
use Modules\Academic\Http\Controllers\AcademicController;
use Modules\Academic\Http\Controllers\ClassroomController;
use Modules\Academic\Http\Controllers\AcademicYearController;
use Modules\Academic\Http\Controllers\SubjectController;
use Modules\Academic\Http\Controllers\ExamTypeController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::resource('academics', AcademicController::class)->names('academic');



    // Academic Year routes
    Route::resource('academic-years', AcademicYearController::class);
    Route::post('academic-years/{academicYear}/toggle-status', [AcademicYearController::class, 'toggleStatus'])->name('academic-years.toggle-status');
    Route::post('academic-years/{academicYear}/set-current', [AcademicYearController::class, 'setCurrent'])->name('academic-years.set-current');
    Route::get('api/academic-years/{academicYear}/statistics', [AcademicYearController::class, 'statistics'])->name('academic-years.statistics');

    // Classroom management
    Route::resource('classrooms', ClassroomController::class)->names('classrooms');
    Route::post('classrooms/{classroom}/assign-subjects', [ClassroomController::class, 'assignSubjects'])->name('classrooms.assign-subjects');
    Route::get('classrooms/{classroom}/students', [ClassroomController::class, 'students'])->name('classrooms.students');
    Route::post('classrooms/{classroom}/toggle-status', [ClassroomController::class, 'toggleStatus'])->name('classrooms.toggle-status');
    Route::get('api/classrooms/academic-year/{academicYear}', [ClassroomController::class, 'getClassroomsForAcademicYear'])->name('classrooms.for-academic-year');

    // Subject routes
    Route::resource('subjects', SubjectController::class);
    Route::post('subjects/{subject}/toggle-status', [SubjectController::class, 'toggleStatus'])->name('subjects.toggle-status');
    Route::post('subjects/{subject}/assign-teacher', [SubjectController::class, 'assignTeacher'])->name('subjects.assign-teacher');
    Route::get('api/subjects/classroom/{classroom}', [SubjectController::class, 'getSubjectsForClassroom'])->name('subjects.for-classroom');

    // Exam Type routes
    Route::resource('exam-types', ExamTypeController::class);
    Route::post('exam-types/{examType}/toggle-status', [ExamTypeController::class, 'toggleStatus'])->name('exam-types.toggle-status');
    Route::post('exam-types/bulk-update', [ExamTypeController::class, 'bulkUpdate'])->name('exam-types.bulk-update');
    Route::post('exam-types/import', [ExamTypeController::class, 'import'])->name('exam-types.import');
    Route::get('api/exam-types/active', [ExamTypeController::class, 'getActiveExamTypes'])->name('exam-types.active');
});
