<?php

namespace Modules\Configuration\Policies;

use App\Models\User;
use Modules\Configuration\Models\DivisionRule;
use Illuminate\Auth\Access\HandlesAuthorization;

class DivisionRulePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any division rules.
     */
    public function viewAny(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can view the division rule.
     */
    public function view(User $user, DivisionRule $divisionRule): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can create division rules.
     */
    public function create(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can update the division rule.
     */
    public function update(User $user, DivisionRule $divisionRule): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can delete the division rule.
     */
    public function delete(User $user, DivisionRule $divisionRule): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can copy rules.
     */
    public function copy(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can import rules.
     */
    public function import(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can export rules.
     */
    public function export(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can create default rules.
     */
    public function createDefault(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can view configuration statistics.
     */
    public function viewStatistics(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can manage academic year rules.
     */
    public function manageAcademicYearRules(User $user, $academicYearId): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can bulk operations.
     */
    public function bulkOperations(User $user): bool
    {
        return $user->role === 'admin';
    }
}
