<?php

namespace Modules\Configuration\Policies;

use App\Models\User;
use Modules\Configuration\Models\GradingRule;
use Illuminate\Auth\Access\HandlesAuthorization;

class GradingRulePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any grading rules.
     */
    public function viewAny(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can view the grading rule.
     */
    public function view(User $user, GradingRule $gradingRule): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can create grading rules.
     */
    public function create(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can update the grading rule.
     */
    public function update(User $user, GradingRule $gradingRule): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can delete the grading rule.
     */
    public function delete(User $user, GradingRule $gradingRule): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can copy rules.
     */
    public function copy(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can import rules.
     */
    public function import(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can export rules.
     */
    public function export(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can create default rules.
     */
    public function createDefault(User $user): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can view configuration statistics.
     */
    public function viewStatistics(User $user): bool
    {
        return in_array($user->role, ['admin', 'teacher']);
    }

    /**
     * Determine whether the user can manage academic year rules.
     */
    public function manageAcademicYearRules(User $user, $academicYearId): bool
    {
        return $user->role === 'admin';
    }

    /**
     * Determine whether the user can bulk operations.
     */
    public function bulkOperations(User $user): bool
    {
        return $user->role === 'admin';
    }
}
