<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grading_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('academic_year_id')->constrained('academic_years')->onDelete('cascade');
            $table->string('grade'); // A, B, C, D, F
            $table->integer('min_marks'); // Minimum marks for this grade
            $table->integer('max_marks'); // Maximum marks for this grade
            $table->integer('points'); // Points assigned to this grade
            $table->timestamps();

            $table->unique(['academic_year_id', 'grade']);
            $table->index(['academic_year_id', 'min_marks', 'max_marks']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grading_rules');
    }
};
