<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('division_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('academic_year_id')->constrained('academic_years')->onDelete('cascade');
            $table->string('division'); // Division I, Division II, etc.
            $table->integer('min_points'); // Minimum total points for this division
            $table->integer('max_points'); // Maximum total points for this division
            $table->timestamps();

            $table->unique(['academic_year_id', 'division']);
            $table->index(['academic_year_id', 'min_points', 'max_points']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('division_rules');
    }
};
