<?php

use Illuminate\Support\Facades\Route;
use Modules\Configuration\Http\Controllers\ConfigurationController;

Route::middleware(['auth', 'verified'])->group(function () {
    // Configuration dashboard
    Route::get('configuration', [ConfigurationController::class, 'index'])->name('configuration.index');

    // Grading rules management
    Route::get('configuration/grading-rules', [ConfigurationController::class, 'gradingRules'])->name('configuration.grading-rules');
    Route::post('configuration/grading-rules', [ConfigurationController::class, 'storeGradingRule'])->name('configuration.store-grading-rule');
    Route::put('configuration/grading-rules/{gradingRule}', [ConfigurationController::class, 'updateGradingRule'])->name('configuration.update-grading-rule');
    Route::delete('configuration/grading-rules/{gradingRule}', [ConfigurationController::class, 'destroyGradingRule'])->name('configuration.destroy-grading-rule');

    // Division rules management
    Route::get('configuration/division-rules', [ConfigurationController::class, 'divisionRules'])->name('configuration.division-rules');
    Route::post('configuration/division-rules', [ConfigurationController::class, 'storeDivisionRule'])->name('configuration.store-division-rule');
    Route::put('configuration/division-rules/{divisionRule}', [ConfigurationController::class, 'updateDivisionRule'])->name('configuration.update-division-rule');
    Route::delete('configuration/division-rules/{divisionRule}', [ConfigurationController::class, 'destroyDivisionRule'])->name('configuration.destroy-division-rule');

    // Utility routes
    Route::post('configuration/copy-rules', [ConfigurationController::class, 'copyRules'])->name('configuration.copy-rules');
    Route::post('configuration/create-default-rules', [ConfigurationController::class, 'createDefaultRules'])->name('configuration.create-default-rules');
    Route::post('configuration/import-rules', [ConfigurationController::class, 'importRules'])->name('configuration.import-rules');

    // API routes
    Route::get('api/configuration/rules/{academic_year_id}', [ConfigurationController::class, 'getRulesForAcademicYear'])->name('configuration.rules-for-academic-year');
});
