<?php

use Illuminate\Support\Facades\Route;
use Modules\Enrollment\Http\Controllers\EnrollmentController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::resource('enrollments', EnrollmentController::class)->names('enrollment');

    // Enrollment-specific routes
    Route::post('enrollments/{enrollment}/transfer', [EnrollmentController::class, 'transfer'])->name('enrollment.transfer');
    Route::patch('enrollments/{enrollment}/toggle-status', [EnrollmentController::class, 'toggleStatus'])->name('enrollment.toggle-status');

    // Bulk enrollment routes
    Route::get('enrollments/bulk/enroll', [EnrollmentController::class, 'bulkEnroll'])->name('enrollment.bulk-enroll');
    Route::post('enrollments/bulk/process', [EnrollmentController::class, 'processBulkEnroll'])->name('enrollment.process-bulk-enroll');

    // API routes for dynamic data
    Route::get('api/enrollments/available-students', [EnrollmentController::class, 'availableStudents'])->name('enrollment.available-students');
});
