<?php

use Illuminate\Support\Facades\Route;
use Modules\Guardians\Http\Controllers\GuardiansController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::resource('guardians', GuardiansController::class)->names('guardians');

    // Guardian-specific routes
    Route::get('guardians/{guardian}/students', [GuardiansController::class, 'students'])->name('guardians.students');
    Route::get('guardians/{guardian}/student-results', [GuardiansController::class, 'studentResults'])->name('guardians.student-results');
    Route::post('guardians/{guardian}/assign-student', [GuardiansController::class, 'assignStudent'])->name('guardians.assign-student');
    Route::delete('guardians/{guardian}/students/{student}', [GuardiansController::class, 'removeStudent'])->name('guardians.remove-student');
    Route::get('guardians/{guardian}/dashboard', [GuardiansController::class, 'dashboard'])->name('guardians.dashboard');
});
