<?php

namespace Modules\Results\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateResultRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $resultId = $this->route('result');
        
        return [
            'student_id' => [
                'required',
                'integer',
                'exists:students,id',
            ],
            'subject_id' => [
                'required',
                'integer',
                'exists:subjects,id',
            ],
            'classroom_id' => [
                'required',
                'integer',
                'exists:classrooms,id',
            ],
            'academic_year_id' => [
                'required',
                'integer',
                'exists:academic_years,id',
            ],
            'exam_type_id' => [
                'required',
                'integer',
                'exists:exam_types,id',
            ],
            'marks' => [
                'required',
                'numeric',
                'min:0',
                'max:100',
            ],
            'grade' => [
                'required',
                'string',
                'max:5',
            ],
            'points' => [
                'required',
                'integer',
                'min:0',
                'max:12',
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'student_id.required' => 'Please select a student.',
            'student_id.exists' => 'The selected student does not exist.',
            'subject_id.required' => 'Please select a subject.',
            'subject_id.exists' => 'The selected subject does not exist.',
            'classroom_id.required' => 'Please select a classroom.',
            'classroom_id.exists' => 'The selected classroom does not exist.',
            'academic_year_id.required' => 'Please select an academic year.',
            'academic_year_id.exists' => 'The selected academic year does not exist.',
            'exam_type_id.required' => 'Please select an exam type.',
            'exam_type_id.exists' => 'The selected exam type does not exist.',
            'marks.required' => 'Please enter the marks.',
            'marks.numeric' => 'Marks must be a number.',
            'marks.min' => 'Marks cannot be less than 0.',
            'marks.max' => 'Marks cannot be more than 100.',
            'grade.required' => 'Grade is required.',
            'grade.max' => 'Grade cannot be more than 5 characters.',
            'points.required' => 'Points are required.',
            'points.integer' => 'Points must be an integer.',
            'points.min' => 'Points cannot be less than 0.',
            'points.max' => 'Points cannot be more than 12.',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'student_id' => 'student',
            'subject_id' => 'subject',
            'classroom_id' => 'classroom',
            'academic_year_id' => 'academic year',
            'exam_type_id' => 'exam type',
        ];
    }
}
