<?php

use Illuminate\Support\Facades\Route;
use Modules\Results\Http\Controllers\ResultsController;

Route::middleware(['auth', 'verified'])->group(function () {
    // Multiple results routes (must be before resource routes)
    Route::get('results/create-multiple', [ResultsController::class, 'createMultiple'])->name('results.create-multiple');
    Route::post('results/store-multiple', [ResultsController::class, 'storeMultiple'])->name('results.store-multiple');
    Route::get('results/edit-multiple/{student}/{examType}/{academicYear}', [ResultsController::class, 'editMultiple'])->name('results.edit-multiple');
    Route::put('results/update-multiple', [ResultsController::class, 'updateMultiple'])->name('results.update-multiple');
    Route::delete('results/delete-multiple', [ResultsController::class, 'deleteMultiple'])->name('results.delete-multiple');

    // CSV Import/Export routes (must be before resource routes)
    Route::get('results/import/form', [ResultsController::class, 'importForm'])->name('results.import.form');
    Route::post('results/import', [ResultsController::class, 'import'])->name('results.import');
    Route::get('results/export', [ResultsController::class, 'export'])->name('results.export');
    Route::get('results/template/download', [ResultsController::class, 'downloadTemplate'])->name('results.template.download');

    // Resource routes (must be last)
    Route::resource('results', ResultsController::class)->names('results');
});
