<?php

use Illuminate\Support\Facades\Route;
use Modules\Students\Http\Controllers\StudentsController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::resource('students', StudentsController::class)->names('students');

    // Student-specific routes
    Route::get('students/{student}/results', [StudentsController::class, 'results'])->name('students.results');
    Route::get('students/{student}/guardians', [StudentsController::class, 'guardians'])->name('students.guardians');
    Route::post('students/{student}/assign-guardian', [StudentsController::class, 'assignGuardian'])->name('students.assign-guardian');
    Route::delete('students/{student}/guardians/{guardian}', [StudentsController::class, 'removeGuardian'])->name('students.remove-guardian');
});
