<?php

use Illuminate\Support\Facades\Route;
use Modules\Teachers\Http\Controllers\TeachersController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::resource('teachers', TeachersController::class)->names('teachers');

    // Teacher-specific routes
    Route::get('teachers/{teacher}/subjects', [TeachersController::class, 'subjects'])->name('teachers.subjects');
    Route::post('teachers/{teacher}/assign-subject', [TeachersController::class, 'assignSubject'])->name('teachers.assign-subject');
    Route::delete('teachers/{teacher}/subjects/{subject}', [TeachersController::class, 'removeSubject'])->name('teachers.remove-subject');
    Route::get('teachers/{teacher}/classrooms', [TeachersController::class, 'classrooms'])->name('teachers.classrooms');
    Route::get('teachers/{teacher}/students', [TeachersController::class, 'students'])->name('teachers.students');
});
