<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckUserRoles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check:user-roles';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check user roles in the system';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $users = \App\Models\User::all();

        $this->info('Checking user roles...');
        $this->info('========================');

        foreach ($users as $user) {
            $role = $user->role ?? 'NO ROLE SET';
            $this->line("User: {$user->email} - Role: {$role}");
        }

        $this->info('========================');
        $this->info('Total users: ' . $users->count());

        return 0;
    }
}
