<?php

namespace Database\Factories;

use Modules\Academic\Models\AcademicYear;
use Illuminate\Database\Eloquent\Factories\Factory;

class AcademicYearFactory extends Factory
{
    protected $model = AcademicYear::class;

    public function definition(): array
    {
        static $yearCounter = 2020;
        $startYear = $yearCounter++;
        $endYear = $startYear + 1;

        $startDate = "{$startYear}-01-01";
        $endDate = "{$endYear}-12-31";

        return [
            'name' => "{$startYear}-{$endYear}",
            'start_date' => $startDate,
            'end_date' => $endDate,
            'is_active' => $this->faker->boolean(30), // 30% chance of being active
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }

    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }

    public function current(): static
    {
        $now = now();
        return $this->state(fn (array $attributes) => [
            'name' => $now->format('Y') . '-' . $now->addYear()->format('Y'),
            'start_date' => $now->startOfYear()->format('Y-m-d'),
            'end_date' => $now->endOfYear()->format('Y-m-d'),
            'is_active' => true,
        ]);
    }
}
