<?php

namespace Database\Factories;

use Modules\Academic\Models\Classroom;
use Modules\Academic\Models\AcademicYear;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClassroomFactory extends Factory
{
    protected $model = Classroom::class;

    public function definition(): array
    {
        $forms = ['Form 1', 'Form 2', 'Form 3', 'Form 4', 'Form 5', 'Form 6'];
        $sections = ['A', 'B', 'C', 'D', 'E'];

        $form = $this->faker->randomElement($forms);
        $section = $this->faker->randomElement($sections);

        return [
            'academic_year_id' => AcademicYear::factory(),
            'name' => $form . ' - Section ' . $section,
            'capacity' => $this->faker->numberBetween(25, 40),
            'description' => $this->faker->optional()->sentence(),
        ];
    }

    public function forAcademicYear($academicYearId): static
    {
        return $this->state(fn (array $attributes) => [
            'academic_year_id' => $academicYearId,
        ]);
    }

    public function elementary(): static
    {
        $grades = ['Grade 1', 'Grade 2', 'Grade 3', 'Grade 4', 'Grade 5'];
        $grade = $this->faker->randomElement($grades);

        return $this->state(fn (array $attributes) => [
            'grade_level' => $grade,
            'name' => $grade . ' - Section ' . $attributes['section'],
        ]);
    }

    public function highSchool(): static
    {
        $grades = ['Grade 9', 'Grade 10', 'Grade 11', 'Grade 12'];
        $grade = $this->faker->randomElement($grades);

        return $this->state(fn (array $attributes) => [
            'grade_level' => $grade,
            'name' => $grade . ' - Section ' . $attributes['section'],
        ]);
    }

    public function withCapacity(int $capacity): static
    {
        return $this->state(fn (array $attributes) => [
            'capacity' => $capacity,
        ]);
    }
}
