<?php

namespace Database\Factories;

use Modules\Configuration\Models\DivisionRule;
use Modules\Academic\Models\AcademicYear;
use Illuminate\Database\Eloquent\Factories\Factory;

class DivisionRuleFactory extends Factory
{
    protected $model = DivisionRule::class;

    public function definition(): array
    {
        $divisions = [
            ['division' => 'I', 'min' => 7, 'max' => 17],
            ['division' => 'II', 'min' => 18, 'max' => 20],
            ['division' => 'III', 'min' => 21, 'max' => 24],
            ['division' => 'IV', 'min' => 25, 'max' => 31],
            ['division' => 'FAIL', 'min' => 32, 'max' => 35],
            ['division' => 'INCOMPLETE', 'min' => 0, 'max' => 6],
        ];

        $divisionData = $this->faker->randomElement($divisions);

        return [
            'academic_year_id' => AcademicYear::factory(),
            'division' => $divisionData['division'],
            'min_points' => $divisionData['min'],
            'max_points' => $divisionData['max'],
        ];
    }

    public function forAcademicYear($academicYearId): static
    {
        return $this->state(fn (array $attributes) => [
            'academic_year_id' => $academicYearId,
        ]);
    }

    public function divisionOne(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'I',
            'min_points' => 7,
            'max_points' => 17,
        ]);
    }

    public function divisionTwo(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'II',
            'min_points' => 18,
            'max_points' => 20,
        ]);
    }

    public function divisionThree(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'III',
            'min_points' => 21,
            'max_points' => 24,
        ]);
    }

    public function divisionFour(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'IV',
            'min_points' => 25,
            'max_points' => 31,
        ]);
    }

    public function fail(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'FAIL',
            'min_points' => 32,
            'max_points' => 35,
        ]);
    }

    public function incomplete(): static
    {
        return $this->state(fn (array $attributes) => [
            'division' => 'INCOMPLETE',
            'min_points' => 0,
            'max_points' => 6,
        ]);
    }
}
