<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Enrollment\Models\Enrollment;
use Modules\Students\Models\Student;
use Modules\Academic\Models\Classroom;
use Modules\Academic\Models\AcademicYear;

class EnrollmentFactory extends Factory
{
    protected $model = Enrollment::class;

    public function definition(): array
    {
        return [
            'student_id' => Student::factory(),
            'classroom_id' => Classroom::factory(),
            'academic_year_id' => AcademicYear::factory(),
            'enrolled_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'is_active' => $this->faker->boolean(90), // 90% chance of being active
        ];
    }

    /**
     * Create an active enrollment
     */
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }

    /**
     * Create an inactive enrollment
     */
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }

    /**
     * Create enrollment for specific student
     */
    public function forStudent($studentId): static
    {
        return $this->state(fn (array $attributes) => [
            'student_id' => $studentId,
        ]);
    }

    /**
     * Create enrollment for specific classroom
     */
    public function forClassroom($classroomId): static
    {
        return $this->state(fn (array $attributes) => [
            'classroom_id' => $classroomId,
        ]);
    }

    /**
     * Create enrollment for specific academic year
     */
    public function forAcademicYear($academicYearId): static
    {
        return $this->state(fn (array $attributes) => [
            'academic_year_id' => $academicYearId,
        ]);
    }

    /**
     * Create enrollment with recent enrollment date
     */
    public function recent(): static
    {
        return $this->state(fn (array $attributes) => [
            'enrolled_at' => $this->faker->dateTimeBetween('-30 days', 'now'),
        ]);
    }
}
