<?php

namespace Database\Factories;

use Modules\Academic\Models\ExamType;
use Modules\Academic\Models\AcademicYear;
use Illuminate\Database\Eloquent\Factories\Factory;

class ExamTypeFactory extends Factory
{
    protected $model = ExamType::class;

    public function definition(): array
    {
        $examTypes = [
            ['name' => 'Midterm Exam', 'weight' => 30],
            ['name' => 'Final Exam', 'weight' => 50],
            ['name' => 'Quiz', 'weight' => 10],
            ['name' => 'Assignment', 'weight' => 10],
            ['name' => 'Project', 'weight' => 20],
            ['name' => 'Practical Exam', 'weight' => 25],
        ];

        $examData = $this->faker->randomElement($examTypes);

        return [
            'academic_year_id' => AcademicYear::factory(),
            'name' => $examData['name'],
            'weight' => $examData['weight'],
            'description' => $this->faker->optional()->sentence(),
            'is_active' => true,
        ];
    }

    public function forAcademicYear($academicYearId): static
    {
        return $this->state(fn (array $attributes) => [
            'academic_year_id' => $academicYearId,
        ]);
    }

    public function midterm(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Midterm Exam',
            'weight' => 30,
        ]);
    }

    public function finalExam(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Final Exam',
            'weight' => 50,
        ]);
    }

    public function quiz(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Quiz',
            'weight' => 10,
        ]);
    }

    public function assignment(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Assignment',
            'weight' => 10,
        ]);
    }

    public function withWeightage(int $weightage): static
    {
        return $this->state(fn (array $attributes) => [
            'weightage' => $weightage,
        ]);
    }

    public function withMaxMarks(int $maxMarks): static
    {
        return $this->state(fn (array $attributes) => [
            'max_marks' => $maxMarks,
        ]);
    }
}
