<?php

namespace Database\Factories;

use Modules\Configuration\Models\GradingRule;
use Modules\Academic\Models\AcademicYear;
use Illuminate\Database\Eloquent\Factories\Factory;

class GradingRuleFactory extends Factory
{
    protected $model = GradingRule::class;

    public function definition(): array
    {
        $grades = [
            ['grade' => 'A+', 'min' => 95, 'max' => 100, 'points' => 10],
            ['grade' => 'A', 'min' => 90, 'max' => 94, 'points' => 9],
            ['grade' => 'A-', 'min' => 85, 'max' => 89, 'points' => 8],
            ['grade' => 'B+', 'min' => 80, 'max' => 84, 'points' => 7],
            ['grade' => 'B', 'min' => 75, 'max' => 79, 'points' => 6],
            ['grade' => 'B-', 'min' => 70, 'max' => 74, 'points' => 5],
            ['grade' => 'C+', 'min' => 65, 'max' => 69, 'points' => 4],
            ['grade' => 'C', 'min' => 60, 'max' => 64, 'points' => 3],
            ['grade' => 'D', 'min' => 50, 'max' => 59, 'points' => 2],
            ['grade' => 'F', 'min' => 0, 'max' => 49, 'points' => 0],
        ];

        $gradeData = $this->faker->randomElement($grades);

        return [
            'academic_year_id' => AcademicYear::factory(),
            'grade' => $gradeData['grade'],
            'min_marks' => $gradeData['min'],
            'max_marks' => $gradeData['max'],
            'points' => $gradeData['points'],
        ];
    }

    public function forAcademicYear($academicYearId): static
    {
        return $this->state(fn (array $attributes) => [
            'academic_year_id' => $academicYearId,
        ]);
    }

    public function gradeA(): static
    {
        return $this->state(fn (array $attributes) => [
            'grade' => 'A',
            'min_marks' => 90,
            'max_marks' => 94,
            'points' => 9,
        ]);
    }

    public function gradeB(): static
    {
        return $this->state(fn (array $attributes) => [
            'grade' => 'B',
            'min_marks' => 75,
            'max_marks' => 79,
            'points' => 6,
        ]);
    }

    public function gradeF(): static
    {
        return $this->state(fn (array $attributes) => [
            'grade' => 'F',
            'min_marks' => 0,
            'max_marks' => 49,
            'points' => 0,
        ]);
    }
}
