<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Guardians\Models\Guardian;
use App\Models\User;

class GuardianFactory extends Factory
{
    protected $model = Guardian::class;

    public function definition(): array
    {
        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        
        return [
            'user_id' => User::factory()->guardian(),
            'first_name' => $firstName,
            'last_name' => $lastName,
            'phone' => $this->faker->phoneNumber(),
            'address' => $this->faker->optional()->address(),
            'occupation' => $this->faker->optional()->jobTitle(),
            'is_active' => true,
        ];
    }

    /**
     * Create an active guardian
     */
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }

    /**
     * Create an inactive guardian
     */
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }

    /**
     * Create a guardian with specific user
     */
    public function forUser($userId): static
    {
        return $this->state(fn (array $attributes) => [
            'user_id' => $userId,
        ]);
    }

    /**
     * Create a guardian with specific occupation
     */
    public function withOccupation($occupation): static
    {
        return $this->state(fn (array $attributes) => [
            'occupation' => $occupation,
        ]);
    }

    /**
     * Create a father guardian
     */
    public function father(): static
    {
        return $this->state(fn (array $attributes) => [
            'first_name' => $this->faker->firstNameMale(),
        ]);
    }

    /**
     * Create a mother guardian
     */
    public function mother(): static
    {
        return $this->state(fn (array $attributes) => [
            'first_name' => $this->faker->firstNameFemale(),
        ]);
    }
}
