<?php

namespace Database\Factories;

use Modules\Academic\Models\Subject;
use Illuminate\Database\Eloquent\Factories\Factory;

class SubjectFactory extends Factory
{
    protected $model = Subject::class;

    public function definition(): array
    {
        $subjects = [
            'Mathematics', 'English Language', 'Science', 'Social Studies', 'History',
            'Geography', 'Physics', 'Chemistry', 'Biology', 'Computer Science',
            'Physical Education', 'Art', 'Music', 'Literature', 'Economics'
        ];

        return [
            'name' => $this->faker->randomElement($subjects),
            'code' => $this->faker->unique()->bothify('SUB###'),
            'description' => $this->faker->optional()->sentence(),
            'is_active' => $this->faker->boolean(90), // 90% chance of being active
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }

    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }

    public function mathematics(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Mathematics',
            'code' => 'MATH101',
            'description' => 'Core mathematics curriculum covering algebra, geometry, and calculus',
        ]);
    }

    public function english(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'English Language',
            'code' => 'ENG101',
            'description' => 'English language arts including reading, writing, and literature',
        ]);
    }

    public function science(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Science',
            'code' => 'SCI101',
            'description' => 'General science covering basic principles of physics, chemistry, and biology',
        ]);
    }
}
