<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\DashboardController;

Route::get('/', function () {
    return Inertia::render('auth/Login');
})->name('home');

Route::get('dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::get('debug/navigation', function () {
    return Inertia::render('Debug/Navigation');
})->middleware(['auth', 'verified'])->name('debug.navigation');

require __DIR__.'/settings.php';
require __DIR__.'/auth.php';

// Load Dusk routes for testing
if (file_exists(__DIR__.'/dusk.php')) {
    require __DIR__.'/dusk.php';
}
