@echo off
echo 🚀 FRONTEND TESTING SUITE
echo ==========================
echo.

REM Check if server is running
echo 🔍 Checking server status...
curl -s http://localhost:8000 >nul 2>&1
if %errorlevel% == 0 (
    echo ✅ Server is running
) else (
    echo ❌ Server is not running
    echo Starting server...
    start /B php artisan serve --host=0.0.0.0 --port=8000
    echo ⏳ Waiting for server to start...
    timeout /t 5 /nobreak >nul
)

echo.

REM Run quick error check
echo 🧪 Running quick error check...
php test-frontend-errors.php

echo.

REM Run backend tests
echo 🔧 Running backend tests...
php artisan test tests/Feature/Frontend/ToastNotificationTest.php --verbose

echo.

REM Ask if user wants to run browser tests
set /p response="🌐 Do you want to run browser tests? (requires Chrome/Chromium) [y/N]: "
if /i "%response%" == "y" (
    echo Running browser tests...
    php artisan dusk tests/Browser/ToastFunctionalityTest.php
) else (
    echo Skipping browser tests
)

echo.
echo ✅ Testing complete!
echo.
echo 📋 NEXT STEPS:
echo 1. Check the output above for any errors
echo 2. If errors found, fix them and re-run tests
echo 3. Test manually by visiting http://localhost:8000/subjects
echo 4. Try creating, editing, and deleting records
echo 5. Check browser console (F12) for JavaScript errors

pause
