#!/bin/bash

echo "🚀 FRONTEND TESTING SUITE"
echo "=========================="
echo ""

# Check if server is running
echo "🔍 Checking server status..."
if curl -s http://localhost:8000 > /dev/null; then
    echo "✅ Server is running"
else
    echo "❌ Server is not running"
    echo "Starting server..."
    php artisan serve --host=0.0.0.0 --port=8000 &
    SERVER_PID=$!
    echo "⏳ Waiting for server to start..."
    sleep 5
fi

echo ""

# Run quick error check
echo "🧪 Running quick error check..."
php test-frontend-errors.php

echo ""

# Run backend tests
echo "🔧 Running backend tests..."
php artisan test tests/Feature/Frontend/ToastNotificationTest.php --verbose

echo ""

# Ask if user wants to run browser tests
echo "🌐 Do you want to run browser tests? (requires Chrome/Chromium) [y/N]"
read -r response
if [[ "$response" =~ ^([yY][eE][sS]|[yY])$ ]]; then
    echo "Running browser tests..."
    php artisan dusk tests/Browser/ToastFunctionalityTest.php
else
    echo "Skipping browser tests"
fi

echo ""
echo "✅ Testing complete!"
echo ""
echo "📋 NEXT STEPS:"
echo "1. Check the output above for any errors"
echo "2. If errors found, fix them and re-run tests"
echo "3. Test manually by visiting http://localhost:8000/subjects"
echo "4. Try creating, editing, and deleting records"
echo "5. Check browser console (F12) for JavaScript errors"

# Clean up
if [ ! -z "$SERVER_PID" ]; then
    echo ""
    echo "🛑 Stopping test server..."
    kill $SERVER_PID
fi
