<?php

require_once 'vendor/autoload.php';

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

// Import the Enrollment model
use Modules\Enrollment\Models\Enrollment;

echo "=== Enrollment Data Structure Test ===\n\n";

try {
    // Get first few enrollments
    $enrollments = Enrollment::with(['student', 'academicYear', 'classroom'])->take(3)->get();
    
    if ($enrollments->isEmpty()) {
        echo "No enrollments found in database.\n";
        exit;
    }
    
    echo "Found " . $enrollments->count() . " enrollments\n\n";
    
    foreach ($enrollments as $index => $enrollment) {
        echo "Enrollment #" . ($index + 1) . " (ID: {$enrollment->id}):\n";
        echo "  status: " . ($enrollment->status ?? 'NULL') . "\n";
        echo "  enrolled_at: " . ($enrollment->enrolled_at ?? 'NULL') . "\n";
        echo "  student_id: " . ($enrollment->student_id ?? 'NULL') . "\n";
        echo "  academic_year_id: " . ($enrollment->academic_year_id ?? 'NULL') . "\n";
        echo "  classroom_id: " . ($enrollment->classroom_id ?? 'NULL') . "\n";
        
        if ($enrollment->student) {
            echo "  student.first_name: " . ($enrollment->student->first_name ?? 'NULL') . "\n";
            echo "  student.last_name: " . ($enrollment->student->last_name ?? 'NULL') . "\n";
        } else {
            echo "  student: NULL\n";
        }
        
        if ($enrollment->academicYear) {
            echo "  academicYear.name: " . ($enrollment->academicYear->name ?? 'NULL') . "\n";
        } else {
            echo "  academicYear: NULL\n";
        }
        
        if ($enrollment->classroom) {
            echo "  classroom.name: " . ($enrollment->classroom->name ?? 'NULL') . "\n";
        } else {
            echo "  classroom: NULL\n";
        }
        
        echo "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== Test Complete ===\n";
