<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use Modules\Academic\Models\ExamType;
use Modules\Academic\Models\AcademicYear;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ExamTypeSimpleTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test simple access to exam types edit page
     */
    public function test_simple_edit_access()
    {
        // Create admin user
        $adminUser = User::factory()->create([
            'role' => 'admin',
            'email' => 'admin@simple.test',
        ]);

        // Create academic year
        $academicYear = AcademicYear::factory()->create([
            'name' => '2024-2025',
            'start_date' => '2024-09-01',
            'end_date' => '2025-06-30',
            'is_active' => true,
        ]);

        // Create exam type
        $examType = ExamType::factory()->create([
            'name' => 'Simple Test Exam',
            'description' => 'Test exam for simple testing',
            'academic_year_id' => $academicYear->id,
            'weight' => 30.00,
            'is_active' => true,
        ]);

        echo "Created exam type with ID: {$examType->id}\n";
        echo "Academic year ID: {$academicYear->id}\n";

        // Test as admin
        $response = $this->actingAs($adminUser)->get("/exam-types/{$examType->id}/edit");

        echo "Response Status: " . $response->getStatusCode() . "\n";
        
        if ($response->getStatusCode() !== 200) {
            echo "Response Content: " . $response->getContent() . "\n";
        }

        $response->assertStatus(200);
    }

    /**
     * Test simple access to exam types create page
     */
    public function test_simple_create_access()
    {
        // Create admin user
        $adminUser = User::factory()->create([
            'role' => 'admin',
            'email' => 'admin@create.test',
        ]);

        // Create academic year
        AcademicYear::factory()->create([
            'name' => '2024-2025',
            'start_date' => '2024-09-01',
            'end_date' => '2025-06-30',
            'is_active' => true,
        ]);

        // Test as admin
        $response = $this->actingAs($adminUser)->get('/exam-types/create');

        echo "Create Response Status: " . $response->getStatusCode() . "\n";
        
        if ($response->getStatusCode() !== 200) {
            echo "Create Response Content: " . $response->getContent() . "\n";
        }

        $response->assertStatus(200);
    }

    /**
     * Test if we can access the index page
     */
    public function test_simple_index_access()
    {
        // Create admin user
        $adminUser = User::factory()->create([
            'role' => 'admin',
            'email' => 'admin@index.test',
        ]);

        // Test as admin
        $response = $this->actingAs($adminUser)->get('/exam-types');

        echo "Index Response Status: " . $response->getStatusCode() . "\n";
        
        if ($response->getStatusCode() !== 200) {
            echo "Index Response Content: " . substr($response->getContent(), 0, 500) . "\n";
        }

        $response->assertStatus(200);
    }
}
