import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { Router, ActivatedRoute, ParamMap } from '@angular/router';
import { MemberService } from '../_services/member.service';
import { SavingsComponent } from '../savings/savings.component';
import { SavingsService } from '../_services/savings.service';
import { LoanService } from '../_services/loan.service';
import { Title } from '@angular/platform-browser';
import { FormGroup, FormBuilder } from '@angular/forms';
import { Member } from '../_models/member';
import { Group } from '../_models/group';
import { Loan } from '../_models/loan';
import { Saving } from '../_models/saving';
import { DivPurpose } from '../_models/div-purpose';
import { DividendService } from '../_services/dividend.service';
import { Dividend } from '../_models/dividend';

@Component({
  selector: 'app-dividend-create',
  templateUrl: './dividend-create.component.html',
  styleUrls: ['./dividend-create.component.css']
})
export class DividendCreateComponent implements OnInit {
  @ViewChild('trf', { static: false }) trfRef: ElementRef;

  pageTitle = "CAPEP KENYA : Dividend Allocation"

  dividendForm: FormGroup

  member: Member;
  members: Member[]
  group: Group;
  groups: Group[];
  loan: Loan;
  loans: Loan[];
  saving: Saving;
  savings: Saving[]
  dividend: Dividend;
  dividends: Dividend[] = [];
  purpose: DivPurpose;
  purposes: DivPurpose[]
  _group_name: any;
  _group_code: string;
  _member_name: string;
  _member_id_no: string;
  _membership_no: number;
  _group_id: number;
  _savings_total: number;
  _savings_bf: number;
  _total_savings: any;
  _group_savings_total: number;
  _group_savings_bf: number;
  _group_total_savings: number;

  //Div control
  public loanDiv: boolean = false
  public savingsDiv: boolean = false
  public withdrawDiv: boolean = false
  successMsg: string;
  errorMsg: any;
  loanrepays: any;
  _total_repay: number;
  _loan_bf: number;
  lrates: any;
  _loan_interest: number;
  _pendingMsg: string;
  _adv_bf: number;
  _adv_loan_interest: number;
  _pendingLoansMsg: string;
  _pendingAdvMsg: string;


  constructor(private title: Title, private router: Router, private formBuilder: FormBuilder, private route: ActivatedRoute, private memberService: MemberService, private savingsService: SavingsService, private loanService: LoanService, private dividendService: DividendService) { }

  ngOnInit() {
    this.title.setTitle(this.pageTitle)

    //Instanciate form
    this.dividendForm = this.formBuilder.group({
      group_id: [null],
      member_id: [null],
      member_savings: [null],
      group_total_shares: [null],
      trf: [null],
      d_rate: [null],
      shared_interest: [null],
      dividend_amount: [null],
      _action_name1: [null],
      _action_name2: [null],
      allocate_date: [null],
      group_total_shares_currency: [{ value: null, disabled: true }],
      _loans_bf: [0],
      _adv_bf: [0],
      adv_id_fk: [null],
      loan_id_fk: [null]


    })

    //this.trfRef.nativeElement.focus()

    //Fetch Dividend Purpose
    this.dividendService.getPurpose()
      .subscribe(data => {
        //console.log("Dividend purpose", data)
        this.purpose = data;
      })


    //fetch members information
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.memberService.getMemberById(id)
        .subscribe(data => {
          // console.log("This data", data)
          this.member = data;
          this._group_id = +this.member.map(function (a) { return a['group_id_fk']; });
          this._group_name = this.member.map(function (a) { return a['group_name']; });
          this._group_code = this.member.map(function (a) { return a['group_code']; });
          this._member_name = this.member.map(function (a) { return a['member_name']; });
          this._member_id_no = this.member.map(function (a) { return a['member_id_no']; });
          this._membership_no = +this.member.map(function (a) { return a['membership_no']; });

          //patch member id to form
          this.dividendForm.patchValue({
            member_id: id
          })

          //BEGIN SAVINGS FETCH          
          this.savingsService.getSavingsById(id).subscribe(s => {
            this.savings = s;
            //console.log("This member savings", this.savings);
            //get total savings
            this._savings_total = +this.savings.reduce((result, a) => {
              var savings_amount = a.savings_amount;
              return result + savings_amount;
            }, 0);
            //get savings bf
            this._savings_bf = +this.savings.reduce((result, a) => {
              let savings_bf = a.savings_bf;
              return result + savings_bf;
            }, 0);
            //get default bf
            let _default_bf = +this.savings.reduce((result, a) =>{
              let default_value = a.default_amount;
              return result + default_value;
            },0)
            //Get total savings bf
            this._total_savings = this._savings_total + this._savings_bf - _default_bf;

            this.dividendForm.patchValue({
              member_savings: this._total_savings
            })

            if (this._total_savings === 0){
              this.formDisable()
            }

          });
          //END SAVINGS FETCH
          //BEGIN LOAN FETCH
          this.loanService.getloanById(id)
            .subscribe(data => {
              this.loans = data;
              // console.log("This member's loans are", this.loans)
              let _last = this.loans[this.loans.length - 1]
              //get repayment

              //check if member exist
              let _memberExist = this.loans.some(loan => {
                return loan.member_id_fk = id
              })
              console.log("does member exist", _memberExist)

              if (!_memberExist) {
                console.log("I don't exist")
                this._loan_bf = 0
                this._adv_bf = 0
                this.dividendForm.patchValue({
                  loans_bf: this._loan_bf,
                  adv_bf: this._adv_bf
                });
              } else {
                console.log("i exist")
                for (let _loans of this.loans) {

                  //begin longterm
                  if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 1) {
                    this.dividendForm.patchValue({
                      loan_id_fk: _loans.loan_id
                    });
                    //console.log("This loan is long term active", _loans.loan_id)
                    this.loanService.getRepaymentsID(_loans.loan_id)
                      .subscribe(data => {
                        this.loanrepays = data;
                        //console.log("Repays for this loan ", this.loanrepays)
                        if (this.loanrepays.some(_loan => {
                          return _loan.loan_id_fk === _loans.loan_id;
                        })) {
                          for (let _loan_repay of this.loanrepays) {
                            // console.log("This loan repays amount", _loan_repay.principal_amount)
                            //get total repay
                            this._total_repay = +this.loanrepays.reduce((result, a) => {
                              let _principal_amount = a.principal_amount;
                              return result + _principal_amount;
                            }, 0);
                            //console.log("Total repayment", this._total_repay)
                          }
                          this._loan_bf = _loans.loan_amount - this._total_repay;
                          //console.log("Total loan bf is", this._loan_bf)
                          //Get interest repayment
                          this.loanService.getRates()
                            .subscribe(data => {
                              this.lrates = data;
                              //console.log("this rates", this.lrates)
                              for (let _lrates of this.lrates) {
                                this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                //console.log("loan interest", this._loan_interest)
                                this.dividendForm.patchValue({
                                  loan_interest: this._loan_interest,
                                  loans_bf: this._loan_bf
                                });
                              }
                            })
                        } else {
                          this._loan_bf = _loans.loan_amount;
                          this.loanService.getRates()
                            .subscribe(data => {
                              this.lrates = data;
                              //console.log("this rates", this.lrates)
                              for (let _lrates of this.lrates) {
                                this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                                //console.log("loan interest", this._loan_interest)
                                this.dividendForm.patchValue({
                                  loan_interest: this._loan_interest,
                                  loans_bf: this._loan_bf
                                });
                              }
                            })
                          // console.log("This new loan", this._loan_bf)                  
                        }
                      })
                  } else {
                    this._loan_bf = 0
                    this._loan_interest = 0
                    this.dividendForm.patchValue({
                      loan_interest: this._loan_interest,
                      loans_bf: this._loan_bf
                    });
                  }
                  //Pending loans
                  if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                    this._pendingMsg = "" + _loans.loan_amount
                  }

                  //End Long Term
                  //begin advance
                  if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 2) {
                    //console.log("This loan is advance active", _loans.loan_id)
                    this.dividendForm.patchValue({
                      adv_id_fk: _loans.loan_id
                    });
                    this.loanService.getRepaymentsID(_loans.loan_id)
                      .subscribe(data => {
                        this.loanrepays = data;
                        //console.log("Repays for this advance loan ", this.loanrepays)
                        if (this.loanrepays.some(_loan => {
                          return _loan.loan_id_fk === _loans.loan_id;
                        })) {
                          for (let _loan_repay of this.loanrepays) {
                            // console.log("This advance loan repays amount", _loan_repay.principal_amount)
                            //get total repay
                            this._total_repay = +this.loanrepays.reduce((result, a) => {
                              let _principal_amount = a.principal_amount;
                              return result + _principal_amount;
                            }, 0);
                            //console.log("Total advance repayment", this._total_repay)
                          }
                          this._adv_bf = _loans.loan_amount - this._total_repay;
                          // console.log("Total adv bf is", this._adv_bf)
                          //Get interest repayment
                          this.loanService.getRates()
                            .subscribe(data => {
                              this.lrates = data;
                              //console.log("this rates", this.lrates)
                              for (let _lrates of this.lrates) {
                                this._adv_loan_interest = (_lrates.advance_rate * this._adv_bf) / 100
                                //console.log("loan interest", this._loan_interest)
                                this.dividendForm.patchValue({
                                  adv_loan_interest: this._adv_loan_interest,
                                  adv_bf: this._adv_bf
                                });
                              }
                            })
                        } else {
                          this._adv_bf = _loans.loan_amount;
                          // console.log("This new loan", this._adv_bf)
                          this.dividendForm.patchValue({
                            adv_bf: this._adv_bf
                          })
                        }
                      })
                  } else {
                    this._adv_bf = 0
                    this._adv_loan_interest = 0
                    this.dividendForm.patchValue({
                      adv_loan_interest: this._adv_loan_interest,
                      adv_bf: this._adv_bf
                    });
                  }
                  //Pending Advance
                  //if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 2) {
                  //  this._pendingAdvMsg = "" + _loans.loan_amount
                  // }

                  if (this._pendingMsg) {
                    this._pendingLoansMsg = "Application denied: You already have pending loan applications!"
                  }

                  if ((this._pendingMsg && _loans.loan_amount > 0) && (_loans.loan_amount > 0)) {
                    this._pendingLoansMsg = "Application denied: You have a pre-existing loan and a pending loan application"
                  }
                  //End advance
                }
              }


            })
          //END LOAN FETCH   


          //FETCH SAVINGS BY GROUP ID
          this.savingsService.getSavingsByGId(this._group_id)
            .subscribe(data => {
              this.savings = data
              //console.log("This group savings", this.savings);
              //get total savings
              this._group_savings_total = +this.savings.reduce((result, a) => {
                var group_savings_amount = a.savings_amount;
                return result + group_savings_amount;
              }, 0);

              //get savings bf
              this._group_savings_bf = +this.savings.reduce((result, a) => {
                let group_savings_bf = a.savings_bf;
                return result + group_savings_bf;
              }, 0);              

              //Get total savings bf
              this._group_total_savings = this._group_savings_total + this._group_savings_bf;
              let _currency = "KShs."
              let _group_total_currency = _currency + this._group_total_savings
              console.log(_group_total_currency)

              this.dividendForm.patchValue({
                group_total_shares_currency: _group_total_currency,
                group_total_shares: this._group_total_savings
              })
            })

        })
    })
  }//End ngOnInit()

  //Begin Action 1 change
  onChangeAction(purpose_id) {
    console.log("id", this.dividendForm.value._action_name1)
    if (this.dividendForm.value._action_name1 == 1) {
      console.log("This loan")
      this.loanDiv = true
      this.savingsDiv = false
      this.withdrawDiv = false
      //this.action2Div = true
    } else if (this.dividendForm.value._action_name1 == 2) {
      console.log("This savings")
      this.savingsDiv = true
      this.loanDiv = false
      this.withdrawDiv = false
    } else if (this.dividendForm.value._action_name1 == 3) {
      console.log("This withdraw")
      this.withdrawDiv = true
      this.loanDiv = false
      this.savingsDiv = false    
    }
  }//End on change action

  //Begin on trf amount change
  onAmountChange() {

    if (this.dividendForm.value.trf == "") {
      this.dividendForm.patchValue({
        shared_interest: "",
        d_rate: "",
        dividend_amount: ""
      })
    } else {
      //console.log("This has changed")
      let _total_interest = this.dividendForm.value.trf - this.dividendForm.value.group_total_shares
      let _shared_interest = _total_interest / 2
      let _div_rate = Math.round((_shared_interest / this.dividendForm.value.group_total_shares * 100) * 100) / 100
      let _dividend = this.dividendForm.value.member_savings * _div_rate
      //console.log("Interest Shared",_total_interest)

      this.dividendForm.patchValue({
        shared_interest: _shared_interest,
        d_rate: _div_rate,
        dividend_amount: _dividend
      })
    }
  }

  //disable form
  formDisable(){
    this.dividendForm.get('trf').disable();
    this.dividendForm.get('shared_interest').disable();
    this.dividendForm.get('d_rate').disable();
    this.dividendForm.get('dividend_amount').disable();
    this.dividendForm.get('_action_name1').disable();
    this.dividendForm.get('_action_name2').disable();
    this.dividendForm.get('allocate_date').disable();
    this.errorMsg = "You do not qualify for any dividend"
  }




  save() {

    console.log("This action", this.dividendForm.value._action_name1)
    const newDividend = {
      member_id_fk: this.dividendForm.value.member_id,
      dividend_amount: this.dividendForm.value.dividend_amount,
      dividend_rate: this.dividendForm.value.d_rate,
      purpose_1: this.dividendForm.value._action_name1,
      //purpose_2: this.dividendForm.value._action_name2,
      //createdAt: this.dividendForm.value.allocate_date
    }

    this.dividendService.addDividend(newDividend)
      .subscribe(dividend => {
        //this.dividends.push(dividend);
        this.successMsg = "Dividend successfully submitted"

        this.dividendService.getDividends()
          .subscribe(data => {
            console.log("Data dividends", data)
            this.dividends = data;


            let _last_dividend = this.dividends[this.dividends.length - 1]

            console.log("THis dividend id is", _last_dividend.dividend_id)
          },
            error => this.errorMsg = error
          )
      })
  }

}
