import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, ParamMap } from '@angular/router';
import { LoanService } from '../_services/loan.service';
import { MemberService } from '../_services/member.service';
import { SavingsService } from '../_services/savings.service';
import { Title } from '@angular/platform-browser';

@Component({
  selector: 'app-loan-details',
  templateUrl: './loan-details.component.html',
  styleUrls: ['./loan-details.component.css']
})
export class LoanDetailsComponent implements OnInit {
  [x: string]: any;
  pageTitle = "CAPEP KENYA : Loan application review"
  _member_id: any;
  loans: any;
  _loan_amount: any;
  _type_name: any;
  _application_date: any;
  _end_date: any;
  member: any;
  _group_name: any;
  _group_code: any;
  _member_name: any;
  _member_id_no: any;
  _membership_no: number;
  _dateJoined: any;
  _loan_status: number;
  _loan_type_name: number;
  _repay_loan: any;
  _action_date: any;
  _comments: any;
  _total_repay: number;
  dateMsg: any; 
  _guarantors:[]
  _purpose:[]

  constructor(private route: ActivatedRoute, private router: Router, private loanService: LoanService, private memberService: MemberService, private savingsService: SavingsService, private title: Title) { }

  ngOnInit() {
    this.title.setTitle(this.pageTitle);

    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.loanService.getLoansbyLID(id)
        .subscribe(data => {
          console.log("Loan is", data)
          this.loans = data;
          this._member_id = this.loans.map(a => a.member_id);
          this._loan_amount = this.loans.map(a => a.loan_amount);
          this._loan_type_name = this.loans.map(a => a.loan_type_id_fk)
          this._loan_status = this.loans.map(a => a.loan_status)
          this._application_date = this.loans.map(a => a.start_date);
          this._end_date = this.loans.map(a => a.end_date);
          this._action_date = this.loans.map(a => a.action_date);
          this._comments = this.loans.map(a => a._comments);
          this._guarantors = this.loans.map(a=>a.guarantorsName)
          this._purpose = this.loans.map(a=>a.loan_purpose)
          console.log("This member id is", this._member_id);
          console.log("Guarantors", this._guarantors);

          //null comments
          if (this._comments == ""){
            this._comments = "- No comments provided"
          }

          if( this._application_date == "" ){
            this.dateMsg = "Not provided"
          }

          if( this._end_date == "" ){
            this.dateMsg = "Not provided"
          }

          if( this._action_date == "" ){
            this.dateMsg = "Not provided"
          }


          //fetch member
          this.memberService.getMemberById(this._member_id)
            .subscribe(data => {
              this.member = data;
              console.log(this.member)
              this._group_name = this.member.map(a => { return a.group_name });
              this._group_code = this.member.map(a => { return a.group_code });
              this._member_name = this.member.map(a => { return a.member_name })
              this._member_id_no = this.member.map(a => { return a.member_id_no })
              this._member_name = this.member.map(a => { return a.member_name })
              this._membership_no = +this.member.map(a => { return a.membership_no });
              this._dateJoined = this.member.map(a => { return a.dateJoined });
            })
          //End fetch member

          //Fetch loan repay
          this.loanService.getRepaymentsID(id)
            .subscribe(data => {
              this._repay_loan = data;
              //calculate loan repayment
              this._total_repay = +this._repay_loan.reduce((result, a) => {
                let _principal_amount = a.principal_amount;
                return result + _principal_amount;
              }, 0);

              console.log("This repayment", this._total_repay)
              this._repay_loan.forEach((p, index) => p._total_repaid =this._total_repay);
              console.log("Repaments", this._repay_loan)
            })
        })
    })
  }

  
  //Navigation
  memberDetails(){
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.loanService.getLoansbyLID(id)
        .subscribe(data => {
          console.log("Loan is", data)
          this.loans = data;
          for (let l of this.loans){
            console.log("meber id", l.member_id)
            this.router.navigate(['../../', l.member_id], { relativeTo: this.route })
          }      
          
          
        })})
  }

}
