import { Component, OnInit, ViewChild, ElementRef, ChangeDetectorRef } from '@angular/core';
import { FormGroup, FormControl, FormBuilder } from '@angular/forms';
import { Router, ActivatedRoute, ParamMap } from '@angular/router';
import { ToastrService } from 'ngx-toastr';

//Import Services
import { LoanService } from '../_services/loan.service';
import { MemberService } from '../_services/member.service'

//Import Models
import { Loan } from '../_models/loan';
import { Member } from '../_models/member'
import { SavingsService } from '../_services/savings.service';
import { Saving } from '../_models/saving';
import { GroupService } from '../_services/group.service';
import { Title } from '@angular/platform-browser';
import { LoanRates } from '../_models/loan-rates';
import { LoanRepayPeriodService } from '../_services/loan-repay-period.service';


@Component({
  selector: 'app-loanapplication',
  templateUrl: './loanapplication.component.html',
  styleUrls: ['./loanapplication.component.css']
})
export class LoanapplicationComponent implements OnInit {
  @ViewChild('loan_amount', { static: false }) loan_amountRef: ElementRef;
  @ViewChild('start_date', { static: false }) start_dateRef: ElementRef;

  pageTitle = "CAPEP KENYA: Loan application";

  //ng select for loan purpose
  loan_purposelist = [{ id: 1, p_name: 'Medical Emergency' }, { id: 2, p_name: 'Debt Consolidation' },
  { id: 3, p_name: 'Travel' }, { id: 4, p_name: 'Education Related' }, { id: 5, p_name: 'Personal Consumption' }
    , { id: 6, p_name: 'Micro Enterprice' }, { id: 7, p_name: 'Other' }];


  loan_types = [{ loan_type_id: 1, loan_type: 'Long term' }, { loan_type_id: 2, loan_type: 'Advance' }];
  marked = false;
  theCheckbox = false;
  maxDate = new Date().toJSON().slice(0, 10);
  minDate = "2019-01-01"
  overide_value = 1;

  loanappForm: FormGroup;

  loan: Loan;
  loans: Loan[];
  member: Member;
  members: Member[];
  rate: LoanRates;
  rates: LoanRates[]
  member_dets: any;
  _group_name: any;
  _group_code: any;
  _group_officer: any;
  _member_name: any;
  _membership_no: any;
  _member_id_no: any;
  _savings_bf: any;

  saving: Saving;
  savings: Saving[];

  savings_total: any;
  _group_id: any;
  loan_t: string;
  amount: any;
  feedback: string;
  negFeedback: string;
  successMsg: string;
  errorMsg: any;
  _savings_total: number;
  _total_savings: any;
  savingsForm: any;
  loanrepays: any;
  _total_repay: number;
  _loan_bf: number;
  lrates: any;
  _loan_interest: number;
  _adv_bf: number;
  _adv_loan_interest: number;
  _member_id: number;
  guarantors: any;
  _mID: any;
  negError: string;
  conditions: any;
  group: any;
  _group_reg_date: any;
  conditionsFeedback: string;
  _pendingMsg: string;
  _pendingAdvMsg: string;
  _pendingLoansMsg: string;
  repayperiodMsg: string;
  negDateErr: string;
  x: number;

  _insurance_rate: number = 3;


  constructor(private router: Router, private title: Title, private groupService: GroupService, private loanService: LoanService, private loanRepayPeriod: LoanRepayPeriodService, private formBuilder: FormBuilder, private memberService: MemberService, private savingsService: SavingsService, private route: ActivatedRoute) {

  }


  //checkbox
  toggleVisibility(e) {
    this.marked = e.target.checked;
    if (this.marked) {
      var o_status = 1;
      this.loanappForm.patchValue({
        overide_status: o_status
      });
      // this.formEnable();
    }
    else {
      var o_status = 0;
      this.loanappForm.patchValue({
        overide_status: o_status
      });
    }
    //this.formDisable();
  };


  ngOnInit() {
    this.title.setTitle(this.pageTitle)

    this.loanappForm = this.formBuilder.group({
      savings_bf: [null],
      loans_bf: [null],
      adv_bf: [null],
      loan_limit: [null],
      member_id_fk: [null],
      loan_type_id: [null],
      loan_amount: [{ value: 0, disabled: true }],
      loan_fee: [{ value: null, disabled: true }],
      loan_insurance_rate: [{ value: 0, disabled: true }],
      _insurance_rate: [0],
      loan_purpose: [{ value: null, disabled: true }],
      guarantorsName: [{ value: null, disabled: true }],
      loan_status: [0],
      overide_status: [0],
      repayment_status: [0],
      overide_comments: [null],
      start_date: [{ value: null, disabled: true }],
      end_date: [{ value: null, disabled: true }],
    }); //end form builder



    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.memberService.getMemberById(id)
        .subscribe(data => {
          this.member = data;
          this._group_id = this.member.map(function (a) { return a['group_id'] });
          this._group_name = this.member.map(function (a) { return a['group_name']; });
          this._group_code = this.member.map(function (a) { return a['group_code']; });
          this._member_name = this.member.map(function (a) { return a['member_name']; });
          this._membership_no = +this.member.map(function (a) { return a['membership_no']; });
          this._member_id_no = this.member.map(function (a) { return a['member_id_no']; });
          this._member_id = +this.member.map(function (a) { return a['member_id'] });

          //patch member id to form 
          this.loanappForm.patchValue({
            member_id_fk: this._member_id
          })

          //fetch the guarantors
          this.memberService.getMemberByGId(this._group_id)
            .subscribe(data => {
              this.guarantors = data;
              //console.log("Id at this point is", id)
              const obj = this.guarantors.find(obj => { return obj.member_id == id });
              for (var i = 0; i < this.guarantors.length; i++) {
                if (this.guarantors[i] === obj && obj !== -1) {
                  this.guarantors.splice(i, 1);
                }
              }

            })

        })

      //BEGIN SAVINGS FETCH          
      this.savingsService.getSavingsById(id).subscribe(s => {
        this.savings = s;
        //console.log("This member savings", this.savings);
        //get total savings
        this._savings_total = +this.savings.reduce((result, a) => {
          var savings_amount = a.savings_amount;
          return result + savings_amount;
        }, 0);
        //get savings bf
        this._savings_bf = +this.savings.reduce((result, a) => {
          let savings_bf = a.savings_bf;
          return result + savings_bf;
        }, 0);
        //get default bf
        let _default_bf = +this.savings.reduce((result, a) => {
          let default_value = a.default_amount;
          return result + default_value;
        }, 0)
        //Get total savings bf
        this._total_savings = this._savings_total + this._savings_bf - _default_bf;
        for (let s of this.savings) {
          //console.log("Savings bf", s.savings_bf)
        }
      });
      //END SAVINGS FETCH


      //fetch members by group id 

      // fetch member by ID         

      //BEGIN LOAN FETCH
      this.loanService.getloanById(id)
        .subscribe(data => {
          this.loans = data;
          // console.log("This member's loans are", this.loans)
          let _last = this.loans[this.loans.length - 1]

          //get loan bf
        //  let _bf = +this.loans.reduce((result,a) =>{
          //  let total_loan_bf = a.loan_bf;
           // return result + total_loan_bf
         // })
          //get repayment

          //check if member exist
          let _memberExist = this.loans.some(loan => {
            return loan.member_id_fk = id
          })
          console.log("does member exist", _memberExist)

          if (!_memberExist) {
            console.log("I don't exist")
            this._loan_bf = 0
            this._adv_bf = 0
            this.loanappForm.patchValue({
              loans_bf: this._loan_bf,
              adv_bf: this._adv_bf
            });
          } else {
            console.log("i exist")
            for (let _loans of this.loans) {

              //begin longterm
              if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 1) {
                this.loanappForm.patchValue({
                  loan_id_fk: _loans.loan_id
                });
                //console.log("This loan is long term active", _loans.loan_id)
                this.loanService.getRepaymentsID(_loans.loan_id)
                  .subscribe(data => {
                    this.loanrepays = data;
                    //console.log("Repays for this loan ", this.loanrepays)
                    if (this.loanrepays.some(_loan => {
                      return _loan.loan_id_fk === _loans.loan_id;
                    })) {
                      for (let _loan_repay of this.loanrepays) {
                        // console.log("This loan repays amount", _loan_repay.principal_amount)
                        //get total repay
                        this._total_repay = +this.loanrepays.reduce((result, a) => {
                          let _principal_amount = a.principal_amount;
                          return result + _principal_amount;
                        }, 0);
                        //console.log("Total repayment", this._total_repay)
                      }
                     // let _bf = +this.loans.reduce((result,a) =>{
                       // let total_loan_bf = a.loan_bf;
                        //return result + total_loan_bf
                      //})
                      this._loan_bf = _loans.loan_amount - this._total_repay;
                      //console.log("Total loan bf is", this._loan_bf)
                      //Get interest repayment
                      this.loanService.getRates()
                        .subscribe(data => {
                          this.lrates = data;
                          this._insurance_rate = this.lrates.map(a => a.insurance_rate)
                          //console.log("this rates", this.lrates)
                          for (let _lrates of this.lrates) {
                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                            //console.log("loan interest", this._loan_interest)
                            this.loanappForm.patchValue({
                              loan_interest: this._loan_interest,
                              loans_bf: this._loan_bf,
                              _insurance_rate: this._insurance_rate
                            });
                          }
                        })
                    } else {
                      this._loan_bf = _loans.loan_amount;
                      this.loanService.getRates()
                        .subscribe(data => {
                          this.lrates = data;
                          //console.log("this rates", this.lrates)
                          for (let _lrates of this.lrates) {
                            this._loan_interest = (_lrates.normal_rate * this._loan_bf) / 100
                            //console.log("loan interest", this._loan_interest)
                            this.loanappForm.patchValue({
                              loan_interest: this._loan_interest,
                              loans_bf: this._loan_bf
                            });
                          }
                        })
                      // console.log("This new loan", this._loan_bf)                  
                    }
                  })
              } else {
                this._loan_bf = 0
                this._loan_interest = 0
                this.loanappForm.patchValue({
                  loan_interest: this._loan_interest,
                  loans_bf: this._loan_bf
                });
              }
              //Pending loans
              if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                this._pendingMsg = "" + _loans.loan_amount
              }
              //End Long Term

              //begin advance
              if (_last && _loans.loan_status === 1 && _loans.loan_type_id_fk === 2) {
                //console.log("This loan is advance active", _loans.loan_id)
                this.loanappForm.patchValue({
                  adv_id_fk: _loans.loan_id
                });
                this.loanService.getRepaymentsID(_loans.loan_id)
                  .subscribe(data => {
                    this.loanrepays = data;
                    //console.log("Repays for this advance loan ", this.loanrepays)
                    if (this.loanrepays.some(_loan => {
                      return _loan.loan_id_fk === _loans.loan_id;
                    })) {
                      for (let _loan_repay of this.loanrepays) {
                        // console.log("This advance loan repays amount", _loan_repay.principal_amount)
                        //get total repay
                        this._total_repay = +this.loanrepays.reduce((result, a) => {
                          let _principal_amount = a.principal_amount;
                          return result + _principal_amount;
                        }, 0);
                        //console.log("Total advance repayment", this._total_repay)
                      }
                      let _adv_interest = _loans.loan_amount * 10 / 100
                      this._adv_bf = _loans.loan_amount - this._total_repay + _adv_interest;

                      this.loanappForm.patchValue({
                        adv_bf: this._adv_bf
                      });

                    } else {
                      let _adv_interest = _loans.loan_amount * 10 / 100
                      this._adv_bf = _loans.loan_amount + _adv_interest;
                      // console.log("This new loan", this._adv_bf)
                      this.loanappForm.patchValue({
                        adv_bf: this._adv_bf
                      })
                    }
                  })
              } else {
                this._adv_bf = 0
                this._adv_loan_interest = 0
                this.loanappForm.patchValue({
                  adv_loan_interest: this._adv_loan_interest,
                  adv_bf: this._adv_bf
                });
              }
              //Pending Advance
              //if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 2) {
              //  this._pendingAdvMsg = "" + _loans.loan_amount
              // }

              if (this._pendingMsg) {
                this._pendingLoansMsg = "Application denied: You already have pending loan applications!"
              }

              if ((this._pendingMsg && _loans.loan_amount > 0) && (_loans.loan_amount > 0)) {
                this._pendingLoansMsg = "Application denied: You have a pre-existing loan and a pending loan application"
              }
              //End advance
            }
          }


        })
      //END LOAN FETCH   

      //LOAN CONDITIONS BEGIN
      this.loanService.getLoanConditions()
        .subscribe(data => {
          this.conditions = data;
          console.log("Loan conditions", data);
          //console.log("This group is", this._group_id)
          for (let _conditions of this.conditions) {
            //Get group maturity date
            this.groupService.getGroupById(this._group_id)
              .subscribe(data => {
                //console.log("this group", data)
                this.group = data;
                this._group_reg_date = this.group.map(a => { return a["group_reg_date"] })
                console.log("reg date", this._group_reg_date)
                var _reg_date = new Date(this._group_reg_date);
                var _todayDate = new Date();
                var _dateDiff = +_todayDate.getMonth() - +_reg_date.getMonth();

                console.log("Conditions", _conditions.group_months)
                if (_dateDiff < _conditions.group_months) {
                  this.conditionsFeedback = "Loan eligibility condition not met: Group should be active for" + _conditions.group_months;
                } else {
                  //Get group total membership
                  this.memberService.getMemberByGId(this._group_id)
                    .subscribe(data => {
                      this.members = data;
                      if (this.members.length < _conditions.group_membership) {
                        this.conditionsFeedback = "Loan eligibility condition not met: Group membership is less than" + _conditions.group_membership;
                      } else {
                        this.savingsService.getSavingsById(this._member_id)
                          .subscribe(data => {
                            console.log("Data savings", data)
                            //get total savings
                            this._savings_total = +this.savings.reduce((result, a) => {
                              var savings_amount = a.savings_amount;
                              return result + savings_amount;
                            }, 0);
                            //get savings bf
                            this._savings_bf = +this.savings.reduce((result, a) => {
                              let savings_bf = a.savings_bf;
                              return result + savings_bf;
                            }, 0);
                            //Get total savings bf
                            this._total_savings = this._savings_total + this._savings_bf
                            console.log("Total savings", this._total_savings)

                            if (this._total_savings < _conditions.minimum_savings) {
                              this.conditionsFeedback = "Loan eligibility condition not met: Member's savings are less than " + _conditions.minimum_savings;
                            }
                          })
                      }
                    })
                }
              })
          }
        })
      //LOAN CONDITIONS END     

      this.loanappForm.patchValue({
        group_id: this._group_id,
        group_name: this._group_name,
        group_code: this._group_code,
        group_officer: this._group_officer,
        member_name: this._member_name,
        membership_no: this._membership_no,
        member_id_no: this._member_id_no,
      });
    })

    //purpose scrolldown
  }//End ngOnInit


  //Loan type select
  onChangeLoanType(loan_type_id) {
    this.negError = ""
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.loanService.getloanById(id)
        .subscribe(data => {
          this.loans = data;
          var _last = this.loans[this.loans.length - 1]

          //check if member exist
          let _memberExist = this.loans.some(loan => {
            return loan.member_id_fk = id
          })
          if (!_memberExist) {
            this.formEnable()
          } else {
            for (let _loans of this.loans) {
              this.savingsService.getSavingsById(id)
                .subscribe(data => {
                  this.savings = data;
                  //get total savings
                  this._savings_total = +this.savings.reduce((result, a) => {
                    var savings_amount = a.savings_amount;
                    return result + savings_amount;
                  }, 0);
                  //get savings bf
                  this._savings_bf = +this.savings.reduce((result, a) => {
                    let savings_bf = a.savings_bf;
                    return result + savings_bf;
                  }, 0);
                  //Get total savings bf
                  this._total_savings = this._savings_total + this._savings_bf
                  //begin loan type test
                  this.loanService.getRates()
                    .subscribe(data => {
                      this.rates = data;
                      //begin for
                      for (let lrate of this.rates) {
                        if (this.loanappForm.value.loan_type_id == 1) {
                          var limit = (this._total_savings * lrate.long_term);

                          //Enable form elements
                          this.formEnable()
                          this.loan_amountRef.nativeElement.focus();
                        }
                        else {
                          var limit = (this._total_savings * lrate.adv_term);
                          this.formEnable()
                          this.loan_amountRef.nativeElement.focus();

                        }
                        if ((this.loanappForm.value.loan_type_id == 1) && (this.loanappForm.value.loans_bf == 0)) {
                          this.loan_t = "Long term";
                          this.amount = this.loanappForm.value.loan_bf;
                          this.feedback = "You have a " + this.loan_t + " loan limit of: KShs." + limit;
                          this.negFeedback = "";
                          this.loanappForm.patchValue({
                            loan_status: 0
                          })
                          //enable form elements
                          this.formEnable()
                          this.loan_amountRef.nativeElement.focus();
                          this.loanappForm.get('guarantorsName').disable();
                        }
                        else if ((this.loanappForm.value.loan_type_id == 2) && (this.loanappForm.value.adv_bf == 0)) {
                          this.loan_t = "Advance";
                          this.amount = this.loanappForm.value.adv_bf;
                          this.feedback = "You have an " + this.loan_t + " loan limit of: KShs." + limit;
                          this.negFeedback = "";
                          this.loanappForm.patchValue({
                            loan_status: 1
                          })
                          //enable form elements
                          this.formEnable()
                          this.loan_amountRef.nativeElement.focus();
                        }
                        else if ((this.loanappForm.value.loans_bf > 0) && (this.loanappForm.value.adv_bf > 0)) {
                          this.negFeedback = "You do not qualify any loan at the moment: Kindly clear your loans before new application";
                          this.feedback = "";
                          this.loanappForm.patchValue({
                            loan_status: 0
                          })
                          //enable form elements
                          this.formDisable()
                        } else if (_last && _loans.loan_status === 0 && _loans.loan_type_id_fk === 1) {
                          this._pendingLoansMsg = "You already have pending loan applications!"
                          this.feedback = "";
                          this.loanappForm.patchValue({
                            loan_status: 0
                          })
                          //enable form elements
                          this.formDisable()

                        } else {
                          this.negFeedback = "You have an outstanding loan of the selected type";
                          this.feedback = "";
                          this.loanappForm.patchValue({
                            loan_status: 0
                          })
                          //enable form elements
                          this.formDisable()
                        }
                        //patch values
                        this.loanappForm.patchValue({
                          loan_limit: limit
                        }); //end patch              
                      } //end for            
                    });
                }); //end savings service     
            }
          }
        })
    }); //end of paramMap
  }; //End loan limit function


  onFocusDate1(start_date) {
    if (this.loanappForm.value.loan_amount == null) {
      this.negError = "Enter loan amount before selecting date"
      this.loan_amountRef.nativeElement.focus()
    } else {
      this.negError = ""
    }
  }

  onFocusDate2(end_date) {
    if (this.loanappForm.value.start_date == null) {
      this.negDateErr = "Select the start date"
      this.start_dateRef.nativeElement.focus()
    } else {
      this.negDateErr = ""
    }
  }

  onChangeDate1(start_date) {
    this.negDateErr = ""
  }

  onChangeDate(end_date) {
    console.log("This is working")
    let _start_date = new Date(this.loanappForm.value.start_date);
    let _end_date = new Date(this.loanappForm.value.end_date);
    let _dateDiff = +_end_date.getMonth() - +_start_date.getMonth()
    // console.log("Month difference", _dateDiff)
    this.loanRepayPeriod.getRepayPeriod()
      .subscribe(data => {
        // console.log("Repay periods", data)

        for (let _repayPeriod of data) {
          if (_dateDiff > _repayPeriod.repay_period) {
            // this.repayperiodMsg ="Loan repayment period should not go beyound "+ _repayPeriod.repay_period + " months"
          } else {
            //this.repayperiodMsg = "This is the repay period"+ _repayPeriod.repay_period
          }
        }
      })
  }


  onAmountChange() {
    if (this.loanappForm.value.loan_amount > this.loanappForm.value.loan_limit) {
      this.negError = "Amount entered surpasses the loan limit";
      this.loan_amountRef.nativeElement.focus();
    }
    else {
      this.negError = ""
    }

    //change loan rate
    if (this.loanappForm.value.loan_type_id == 1) {
      let _loan_insurance_rate = Math.round((this.loanappForm.value.loan_amount * this.loanappForm.value._insurance_rate / 100) / 5) * 5
      console.log("I am here today")
      this.loanappForm.patchValue({
        loan_insurance_rate: _loan_insurance_rate
      })

    } else {
      this.loanappForm.patchValue({
        loan_insurance_rate: 0
      })
    }


  }


  formDisable() {
    // this.loanappForm.get('loan_type_id').disable();
    this.loanappForm.get('loan_amount').disable();
    this.loanappForm.get('start_date').disable();
    this.loanappForm.get('end_date').disable();
    this.loanappForm.get('guarantorsName').disable();
    this.loanappForm.get('loan_purpose').disable();
    this.loanappForm.get('loan_fee').disable();
  };

  formEnable() {
    //this.loanappForm.get('loan_type_id').enable();
    this.loanappForm.get('loan_amount').enable();
    this.loanappForm.get('start_date').enable();
    this.loanappForm.get('end_date').enable();
    this.loanappForm.get('guarantorsName').enable();
    this.loanappForm.get('loan_purpose').enable();
    this.loanappForm.get('loan_fee').enable();
  };

  formReset() {
    this.loanappForm.get('loan_type_id').reset();
    this.loanappForm.get('loan_amount').reset();
    this.loanappForm.get('start_date').reset();
    this.loanappForm.get('end_date').reset();
    this.loanappForm.get('guarantorsName').reset();
    this.loanappForm.get('loan_purpose').reset();
    this.loanappForm.get('loan_fee').reset();
  }

  save() {
    console.log(this.loanappForm.value.guarantorsName.join(','));
    console.log(this.loanappForm.value.loan_purpose.join(','));
    console.log("This form", this.loanappForm.value)
    var newLoan = {
      member_id_fk: this.loanappForm.value.member_id_fk,
      loan_type_id_fk: this.loanappForm.value.loan_type_id,
      loan_amount: this.loanappForm.value.loan_amount,
      loan_fee: this.loanappForm.value.loan_fee,
      start_date: this.loanappForm.value.start_date,
      guarantorsName: this.loanappForm.value.guarantorsName.join(','),
      loan_purpose: this.loanappForm.value.loan_purpose.join(','),
      end_date: this.loanappForm.value.end_date,
      loan_status: this.loanappForm.value.loan_status,
      overide_status: this.loanappForm.value.overide_status,
      repayment_status: this.loanappForm.value.repayment_status,
      overide_comments: this.loanappForm.value.overide_comments,
    };
    this.loanService.addLoan(newLoan)
      .subscribe(loan => {
        console.log(loan);
        this.loans.push(loan);
        this.successMsg = "Loan application successfully submitted";
        this.feedback = ""
        this.negFeedback = ""
        this.conditionsFeedback = ""
        this.resetForm();
      },
        //display a failure error
        error => this.errorMsg = error);
    this.resetForm();
  };

  resetForm() {
    this.successMsg = "";
    this.feedback = "";
    this.negFeedback = "";
    this.loanappForm.patchValue({
      loan_type_id: "",
      loan_amount: "",
      start_date: "",
      end_date: "",
      loan_fee: "",
      guarantorsName: "",
      loan_purpose: "",
      overide_comments: ""
    });
  };

  golist() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.memberService.getMemberById(id)
        .subscribe(data => {
          this.members = data;
          for (let m of this.members) {
            console.log("this group id is", m.group_id_fk);
            this.router.navigate(['/group/llist', m.group_id_fk]);
          }
        });
    });
  }; //end golist

  goDets() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.router.navigate(['../../../member', id], { relativeTo: this.route });
    });
  };







}
