import { Component, OnInit } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { ActivatedRoute, Router, ParamMap } from '@angular/router';
import { MemberService } from '../_services/member.service';
import { GroupService } from '../_services/group.service';
import { Member } from '../_models/member';

@Component({
  selector: 'app-loans-members-list',
  templateUrl: './loans-members-list.component.html',
  styleUrls: ['./loans-members-list.component.css']
})
export class LoansMembersListComponent implements OnInit {
  pageTitle = 'CAPEP KENYA : Members loans list';

  public searchMnumber: string;
  public searchMname: string;
  group_id: number;
  member: Member;
  members: Member[]
  errorMsg: any;
  group: any;

  constructor(private title: Title, private route: ActivatedRoute, private router: Router, private memberService: MemberService, private groupService: GroupService) { }

  ngOnInit() {
    this.title.setTitle(this.pageTitle)
    this.getGroupMembership();
    this.loadGroup();
  }

  getGroupMembership() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.memberService.getMemberByGId(id)
        .subscribe(data => {
          this.members = data;
          console.log("this members", this.members)
        },
          //display a failure error
          error => {
            this.errorMsg = error;
            console.log("this error", this.errorMsg)
          }

        )
    });
  }

  loadGroup() {

    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.group_id = id;
      console.log(this.group_id);
      this.groupService.getGroupById(this.group_id)
        .subscribe(m => {
          this.group = m;
        },
          //display a failure error
          error => { this.errorMsg = error; });
    });
  }

  onSelect(member) {
    //this.router.navigate(['/branch', branch.branch_id]);
    this.router.navigate(['../../loans/create/', member.member_id], { relativeTo: this.route });
  };

  onSelectHistory(member) {
    this.router.navigate(['../../member', member.member_id], { relativeTo: this.route });
  };

  grouplist() {
    this.router.navigate(['group/lgroups']);
  };

  goMembers() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.router.navigate(['group/mlist', id]);
    });
  };

  goSavings() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.router.navigate(['group/slist', id]);
    });
  };

  goDividends = function () {
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = parseInt(params.get('id'));
      this.router.navigate(['group/dlist', id]);
    });
  }
}
