import { Component, OnInit } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { Loan } from '../_models/loan';
import { LoanService } from '../_services/loan.service';
import { SavingsService } from '../_services/savings.service';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-loansapplied',
  templateUrl: './loansapplied.component.html',
  styleUrls: ['./loansapplied.component.css']
})
export class LoansappliedComponent implements OnInit {
  pageTitle = "CAPEP KENYA: Loans Manager";
  loan: Loan;
  loans: Loan[]
  

  public acceptAction = 1;
  public declineAction = 2;
  myDate = new Date('YYYY-MM-DD');
  savings: any;
  _savings_bf: number;
  Acceptedloans: any;
  Declinedloans: any;
  _member_id_fk: any;
  _loan_type_id_fk: any;
  _loan_amount: any;
  _loan_fee: any;
  _loan_purpose: any;
  _guarantorsName: any;
  _overide_status: any;
  _repayment_status: any;
  _overide_comments: any;
  _comments: any;
  _start_date: any;
  _end_date: any;
  errorMsg: any;
  _savings_total: number;
  total_savings: number;

  _currency_sym = "KShs."

  constructor(private router: Router, private route: ActivatedRoute, private title: Title, private loanService: LoanService, private savingsService: SavingsService) { }

  ngOnInit() {
    this.title.setTitle(this.pageTitle);

    //new loans
    this.getNewLoan();
    //accepted loans
    this.getAcceptedLoan();
    //declined loans
    this.getDeclinedloan();
  }

  getNewLoan() {
    this.loanService.getNewLoans()
      .subscribe(data => {
        this.loans = data;
        console.log("This loans", this.loans)
        for (let loan of this.loans) {
          console.log("Members number is", loan.member_id_fk);
          
          this.savingsService.getSavingsById(loan.member_id_fk)
            .subscribe(data => {
              this.savings = data;
              
              //get savings bf
              this._savings_bf = +this.savings.reduce(function (result, _a) {
                let savings_bf = _a.savings_bf;
                return result + savings_bf;
              },0);
              //get savings 
              this._savings_total = +this.savings.reduce(function (result, _a) {
              let savings_amount = _a.savings_amount;
                return result + savings_amount;
              },0);

              this.loans.map((obj)=>{obj.total_savings = this._savings_total
              
                return obj
                console.log("this obj", this.loans)}) 

             this.savings.push(this._savings_total)
              console.log("new total", this.savings)
              //alert("This output"+this._savings_total)             
             

            //total savings
           // this.total_savings = this._savings_bf + this._savings_total
              //console.log("this savings", this.total_savings);
            });
        }
      });
  };

  getAcceptedLoan() {

    this.loanService.getAcceptedLoans()
      .subscribe(data => {
        console.log("Accepted loans", data)
        this.Acceptedloans = data;
      });
  };

  getDeclinedloan() {
    this.loanService.getDeclinedLoans()
      .subscribe(data => {
        this.Declinedloans = data;
      });
  };

  onAccept(loan) {

    console.log("loan id is", loan.loan_id);
    const updateLoan = {
      loan_status: this.acceptAction,
      action_date: this.myDate
    }
    this.loanService.updateLoanbyID(loan.loan_id, updateLoan)
      .subscribe(results => {
        console.log("This are the results", results);
        this.loanService.getNewLoans()
          .subscribe(data => {
            this.loans = data;
            this.getAcceptedLoan();
            this.getNewLoan()
          },
            error => this.errorMsg = error);
      });
  };

  onDecline(loan) {
    console.log("loan id is", loan.loan_id);
    const updateLoan = {
      loan_status: this.declineAction,
      action_date: this.myDate
    }
    this.loanService.updateLoanbyID(loan.loan_id, updateLoan)
      .subscribe(results => {
        console.log("This are the results", results);
        this.loanService.getNewLoans()
          .subscribe(data => {
            this.loans = data;
            this.getDeclinedloan()
            this.getNewLoan()
          },
            error => this.errorMsg = error);
      });
  };

  onSelectLoans(loan) {
    //window.alert("This loan is" + loan.loan_id)
    this.router.navigate(['../', loan.loan_id], { relativeTo: this.route });
  };

  onSelectLoansDecline(loan){
    this.router.navigate(['../decline', loan.loan_id], { relativeTo: this.route });
  }

}
