import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl} from '@angular/forms';
import { Title} from '@angular/platform-browser';
import {Router} from '@angular/router';

//import  services
import { AuthenticationService, TokenPayload } from '../auth/authentication.service';


@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})

export class LoginComponent implements OnInit {
  public errorMsg;
  loading = false;
  public successMsg;
  public loadingMsg = "Authenticating...Please wait";

  credentials: TokenPayload ={
    //user_id: 0,
    staff_id_fk:0,
    userName: '',
    email: '',
    password:'',
    roles:''
  }

  loginForm: {};
  
  private formSubmitAttempt: boolean;
  user: any;

  constructor(private router: Router, private fb: FormBuilder, private auth: AuthenticationService, private title: Title) { }

  login () {
    this.loading = true;
    this.errorMsg = ""
    this.auth.login(this.credentials).subscribe(
      () => {
        //this.user = data;
        //console.log(this.user)
        this.successMsg = "Successful Authentication";
        this.router.navigateByUrl('/dashboard')
      },
      err => {this.errorMsg = err;
        this.loading = false;
      }
    )
    
    
  }

  ngOnInit() {}

  
   
    
}
