import { Component, OnInit } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { GroupService } from '../_services/group.service';
import { Router, ActivatedRoute } from '@angular/router';
import { Group } from '../_models/group';

@Component({
  selector: 'app-member-groups',
  templateUrl: './member-groups.component.html',
  styleUrls: ['./member-groups.component.css']
})
export class MemberGroupsComponent implements OnInit {
  pageTitle = "CAPEP KENYA: Members:Groups list";

  public searchText: string;
  public searchGname: string;
  public searchGcode: string

  group: Group;
  groups: Group[]

  constructor(private title: Title, private groupService: GroupService, private router: Router, private route: ActivatedRoute) { }

  ngOnInit() {
    this.title.setTitle(this.pageTitle);

    this.groupService.getGroup()
    .subscribe(groups => { this.groups = groups });
  }

  onSelect(group) {
    //this.router.navigate(['/branch', branch.branch_id]);
    this.router.navigate(['../mlist', group.group_id], { relativeTo: this.route });
}

goSavings() {
    this.router.navigate(['group/sgroups']);
}

goLoans() {
    this.router.navigate(['group/lgroups']);
}

goDividends() {
    this.router.navigate(['group/dgroups']);
}

}
